/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glue.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.glue.model.Statement;

@SdkInternalApi
public class StatementMarshaller {
    private static final MarshallingInfo<Integer> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").build();
    private static final MarshallingInfo<String> CODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Code").build();
    private static final MarshallingInfo<String> STATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("State").build();
    private static final MarshallingInfo<StructuredPojo> OUTPUT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Output").build();
    private static final MarshallingInfo<Double> PROGRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Progress").build();
    private static final MarshallingInfo<Long> STARTEDON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartedOn").build();
    private static final MarshallingInfo<Long> COMPLETEDON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CompletedOn").build();
    private static final StatementMarshaller instance = new StatementMarshaller();

    public static StatementMarshaller getInstance() {
        return instance;
    }

    public void marshall(Statement statement, ProtocolMarshaller protocolMarshaller) {
        if (statement == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)statement.getId(), ID_BINDING);
            protocolMarshaller.marshall((Object)statement.getCode(), CODE_BINDING);
            protocolMarshaller.marshall((Object)statement.getState(), STATE_BINDING);
            protocolMarshaller.marshall((Object)statement.getOutput(), OUTPUT_BINDING);
            protocolMarshaller.marshall((Object)statement.getProgress(), PROGRESS_BINDING);
            protocolMarshaller.marshall((Object)statement.getStartedOn(), STARTEDON_BINDING);
            protocolMarshaller.marshall((Object)statement.getCompletedOn(), COMPLETEDON_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

