/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.io.opencensus.implcore.trace.propagation;

import com.google.cloud.hadoop.repackaged.gcs.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.trace.SpanContext;
import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.trace.SpanId;
import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.trace.TraceId;
import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.trace.TraceOptions;
import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.trace.Tracestate;
import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.trace.propagation.SpanContextParseException;
import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.trace.propagation.TextFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

final class B3Format
extends TextFormat {
    private static final Tracestate TRACESTATE_DEFAULT = Tracestate.builder().build();
    @VisibleForTesting
    static final String X_B3_TRACE_ID = "X-B3-TraceId";
    @VisibleForTesting
    static final String X_B3_SPAN_ID = "X-B3-SpanId";
    @VisibleForTesting
    static final String X_B3_PARENT_SPAN_ID = "X-B3-ParentSpanId";
    @VisibleForTesting
    static final String X_B3_SAMPLED = "X-B3-Sampled";
    @VisibleForTesting
    static final String X_B3_FLAGS = "X-B3-Flags";
    private static final List<String> FIELDS = Collections.unmodifiableList(Arrays.asList("X-B3-TraceId", "X-B3-SpanId", "X-B3-ParentSpanId", "X-B3-Sampled", "X-B3-Flags"));
    private static final String UPPER_TRACE_ID = "0000000000000000";
    private static final String SAMPLED_VALUE = "1";
    private static final String FLAGS_VALUE = "1";

    B3Format() {
    }

    @Override
    public List<String> fields() {
        return FIELDS;
    }

    @Override
    public <C> void inject(SpanContext spanContext, C carrier, TextFormat.Setter<C> setter) {
        Preconditions.checkNotNull(spanContext, "spanContext");
        Preconditions.checkNotNull(setter, "setter");
        Preconditions.checkNotNull(carrier, "carrier");
        setter.put(carrier, X_B3_TRACE_ID, spanContext.getTraceId().toLowerBase16());
        setter.put(carrier, X_B3_SPAN_ID, spanContext.getSpanId().toLowerBase16());
        if (spanContext.getTraceOptions().isSampled()) {
            setter.put(carrier, X_B3_SAMPLED, "1");
        }
    }

    @Override
    public <C> SpanContext extract(C carrier, TextFormat.Getter<C> getter) throws SpanContextParseException {
        Preconditions.checkNotNull(carrier, "carrier");
        Preconditions.checkNotNull(getter, "getter");
        try {
            String traceIdStr = getter.get(carrier, X_B3_TRACE_ID);
            if (traceIdStr != null) {
                if (traceIdStr.length() == 16) {
                    traceIdStr = UPPER_TRACE_ID + traceIdStr;
                }
            } else {
                throw new SpanContextParseException("Missing X_B3_TRACE_ID.");
            }
            TraceId traceId = TraceId.fromLowerBase16(traceIdStr);
            String spanIdStr = getter.get(carrier, X_B3_SPAN_ID);
            if (spanIdStr == null) {
                throw new SpanContextParseException("Missing X_B3_SPAN_ID.");
            }
            SpanId spanId = SpanId.fromLowerBase16(spanIdStr);
            TraceOptions traceOptions = TraceOptions.DEFAULT;
            if ("1".equals(getter.get(carrier, X_B3_SAMPLED)) || "1".equals(getter.get(carrier, X_B3_FLAGS))) {
                traceOptions = TraceOptions.builder().setIsSampled(true).build();
            }
            return SpanContext.create(traceId, spanId, traceOptions, TRACESTATE_DEFAULT);
        }
        catch (IllegalArgumentException e) {
            throw new SpanContextParseException("Invalid input.", e);
        }
    }
}

