/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.api;

import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.directory.api.ldap.model.constants.SaslQoP;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.filterchain.IoFilterAdapter;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.write.DefaultWriteRequest;
import org.apache.mina.core.write.WriteRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaslFilter
extends IoFilterAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(SaslFilter.class);
    public static final String DISABLE_SECURITY_LAYER_ONCE = SaslFilter.class.getName() + ".DisableSecurityLayerOnce";
    public static final String BYTES = SaslFilter.class.getName() + ".Buffer";
    public static final String OFFSET = SaslFilter.class.getName() + ".Offset";
    private final SaslClient saslClient;
    private final SaslServer saslServer;
    private boolean hasSecurityLayer;
    private int maxBufferSize;

    public SaslFilter(SaslClient saslClient) {
        if (saslClient == null) {
            throw new IllegalArgumentException();
        }
        this.saslServer = null;
        this.saslClient = saslClient;
        this.initHasSecurityLayer((String)saslClient.getNegotiatedProperty("javax.security.sasl.qop"));
        this.initMaxBuffer((String)saslClient.getNegotiatedProperty("javax.security.sasl.maxbuffer"));
    }

    public SaslFilter(SaslServer saslServer) {
        if (saslServer == null) {
            throw new IllegalArgumentException();
        }
        this.saslClient = null;
        this.saslServer = saslServer;
        this.initHasSecurityLayer((String)saslServer.getNegotiatedProperty("javax.security.sasl.qop"));
        this.initMaxBuffer((String)saslServer.getNegotiatedProperty("javax.security.sasl.maxbuffer"));
    }

    private void initHasSecurityLayer(String qop) {
        this.hasSecurityLayer = qop != null && (qop.equals(SaslQoP.AUTH_INT.getValue()) || qop.equals(SaslQoP.AUTH_CONF.getValue()));
    }

    private void initMaxBuffer(String maxBuffer) {
        this.maxBufferSize = maxBuffer != null ? Integer.parseInt(maxBuffer) : 65536;
    }

    public synchronized void messageReceived(IoFilter.NextFilter nextFilter, IoSession session, Object message) throws SaslException {
        LOG.debug("Message received:  {}", message);
        if (!this.hasSecurityLayer) {
            LOG.debug("Will not use SASL on received message.");
            nextFilter.messageReceived(session, message);
            return;
        }
        IoBuffer buf = (IoBuffer)message;
        while (buf.hasRemaining()) {
            byte[] bytes = (byte[])session.getAttribute((Object)BYTES, null);
            int offset = (Integer)session.getAttribute((Object)OFFSET, (Object)-1);
            if (bytes == null) {
                int bufferSize = buf.getInt();
                if (bufferSize > this.maxBufferSize) {
                    throw new IllegalStateException(bufferSize + " exceeds the negotiated receive buffer size limit: " + this.maxBufferSize);
                }
                bytes = new byte[bufferSize];
                offset = 0;
            }
            int length = Math.min(bytes.length - offset, buf.remaining());
            buf.get(bytes, offset, length);
            if ((offset += length) < bytes.length) {
                LOG.debug("Partial SASL message received:  {}/{}", (Object)offset, (Object)bytes.length);
                session.setAttribute((Object)BYTES, (Object)bytes);
                session.setAttribute((Object)OFFSET, (Object)offset);
                break;
            }
            LOG.debug("Will use SASL to unwrap received message of length:  {}", (Object)bytes.length);
            byte[] token = this.unwrap(bytes, 0, bytes.length);
            nextFilter.messageReceived(session, (Object)IoBuffer.wrap((byte[])token));
            session.removeAttribute((Object)BYTES);
            session.removeAttribute((Object)OFFSET);
        }
    }

    public synchronized void filterWrite(IoFilter.NextFilter nextFilter, IoSession session, WriteRequest writeRequest) throws SaslException {
        LOG.debug("Filtering write request:  {}", (Object)writeRequest);
        if (session.containsAttribute((Object)DISABLE_SECURITY_LAYER_ONCE)) {
            LOG.debug("Disabling SaslFilter once; will not use SASL on write request.");
            session.removeAttribute((Object)DISABLE_SECURITY_LAYER_ONCE);
            nextFilter.filterWrite(session, writeRequest);
            return;
        }
        if (!this.hasSecurityLayer) {
            LOG.debug("Will not use SASL on write request.");
            nextFilter.filterWrite(session, writeRequest);
            return;
        }
        IoBuffer buf = (IoBuffer)writeRequest.getMessage();
        int bufferLength = buf.remaining();
        byte[] bufferBytes = new byte[bufferLength];
        buf.get(bufferBytes);
        LOG.info("Will use SASL to wrap message of length:  {}", (Object)bufferLength);
        int max = this.maxBufferSize - 200;
        for (int offset = 0; offset < bufferLength; offset += max) {
            int length = Math.min(bufferLength - offset, max);
            byte[] saslLayer = this.wrap(bufferBytes, offset, length);
            IoBuffer saslLayerBuffer = IoBuffer.allocate((int)(4 + saslLayer.length));
            saslLayerBuffer.putInt(saslLayer.length);
            saslLayerBuffer.put(saslLayer);
            saslLayerBuffer.position(0);
            saslLayerBuffer.limit(4 + saslLayer.length);
            LOG.debug("Sending encrypted token of length {}.", (Object)saslLayerBuffer.limit());
            nextFilter.filterWrite(session, (WriteRequest)new DefaultWriteRequest((Object)saslLayerBuffer, writeRequest.getFuture()));
        }
    }

    private byte[] wrap(byte[] buffer, int offset, int length) throws SaslException {
        if (this.saslClient != null) {
            return this.saslClient.wrap(buffer, offset, length);
        }
        return this.saslServer.wrap(buffer, offset, length);
    }

    private byte[] unwrap(byte[] buffer, int offset, int length) throws SaslException {
        if (this.saslClient != null) {
            return this.saslClient.unwrap(buffer, offset, length);
        }
        return this.saslServer.unwrap(buffer, offset, length);
    }
}

