/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.lambda.endpoints.custompredict;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.memimpl.MemColumn;
import com.dataiku.dip.datalayer.memimpl.MemRow;
import com.dataiku.dip.io.ResponderKernelLink;
import com.dataiku.dip.io.SocketBlockLinkException;
import com.dataiku.dip.kernels.IDSSKernelBase;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.lambda.LambdaContext;
import com.dataiku.lambda.ServiceGenContext;
import com.dataiku.lambda.endpoints.EndpointUtils;
import com.dataiku.lambda.endpoints.predictcommon.PipelineMessage;
import com.dataiku.lambda.endpoints.predictcommon.PredictionStep;
import com.dataiku.lambda.endpoints.rfunction.RFunctionKernel;
import com.dataiku.lambda.model.api.MultiplePredictionQuery;
import com.dataiku.lambda.model.api.PredictionResponse;
import com.dataiku.lambda.model.serverconfig.CustomRPredictionEndpointConfig;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class CustomRPredictionStep
implements PredictionStep {
    private final CustomRPredictionEndpointConfig ep;
    private final ServiceGenContext ctx;
    private final File codePath;
    private final List<String> resourceFoldersPaths;
    private final List<String> userCodePaths;
    private RFunctionKernel kernel;
    private ResponderKernelLink link;
    private AutoDelete kernelWorkDir;
    @Autowired
    private LambdaContext lambdaContext;
    @Autowired
    PasswordEncryptionService passwordEncryptionService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.lambda.predict");

    public CustomRPredictionStep(CustomRPredictionEndpointConfig ep, ServiceGenContext ctx, File codePath, List<String> resourceFoldersPaths, List<String> userCodePaths) {
        SpringUtils.getInstance().autowire((Object)this);
        this.ep = ep;
        this.ctx = ctx;
        this.codePath = codePath;
        this.resourceFoldersPaths = resourceFoldersPaths;
        this.userCodePaths = userCodePaths;
    }

    public void init() throws Exception {
        this.link = new ResponderKernelLink(SecretKeyGenerator.generate((int)16));
        File codeEnvFolder = this.ctx.getFileInEndpointFolder(this.ep.id, "R-env-live");
        this.kernelWorkDir = this.lambdaContext.getTempFolder("lambda-cust-pred-R-" + SecretKeyGenerator.generate((int)8));
        logger.infoV("Created temporary kernel work directory %s for service %s - endpoint %s - generation %s", new Object[]{this.kernelWorkDir.getAbsolutePath(), this.ctx.getServiceId(), this.ep.id, this.ctx.getGenerationId()});
        try {
            this.kernel = new RFunctionKernel(this.link, this.ctx, this.userCodePaths, codeEnvFolder, (File)this.kernelWorkDir, ApplicationConfigurator.isDevLambdaServer(), (GeneralSettingsDAO.CGrouppableProcessType)(ApplicationConfigurator.isDevLambdaServer() ? GeneralSettingsDAO.CGrouppableProcessType.LAMBDA_DEV_SERVER : null));
            this.kernel.start();
            RFunctionKernel.StartRequest req = new RFunctionKernel.StartRequest(this.ep.userFunctionName, this.ep.passArgumentsAsList, this.codePath, this.resourceFoldersPaths);
            RFunctionKernel.StartResponse started = (RFunctionKernel.StartResponse)this.link.execute((Object)req, RFunctionKernel.StartResponse.class, "Failed to initiate function server");
            if (!started.ok) {
                throw new Exception("Failed to start custom prediction kernel: " + started.reason);
            }
        }
        catch (SocketBlockLinkException e) {
            e.withLogTail((IDSSKernelBase)this.kernel);
            IOException fe = this.kernel.maybeRethrowAsProcessDied((IOException)((Object)e));
            this.cleanupResources();
            throw fe;
        }
        catch (Exception e) {
            this.cleanupResources();
            throw e;
        }
    }

    protected void cleanupResources() {
        try {
            this.link.close();
            this.kernel.killWithoutMercy();
        }
        catch (Exception ex) {
            logger.error((Object)"Failed to cleanup custom prediction kernel", (Throwable)ex);
        }
        try {
            this.kernelWorkDir.close();
        }
        catch (Exception e) {
            logger.error((Object)"Error cleaning kernel work directory", (Throwable)e);
        }
        this.link = null;
        this.kernel = null;
        this.kernelWorkDir = null;
    }

    @Override
    public PredictionResponse process(PipelineMessage message) throws Exception {
        PredictionResponse resp = new PredictionResponse();
        for (int i = 0; i < message.itemsToPredict.size(); ++i) {
            RFunctionKernel.FunctionResponse kernelRet;
            MultiplePredictionQuery.Item itemToPredict = message.itemsToPredict.get(i);
            if (message.prePredictIgnoreReasons.get(i) != null) {
                PredictionResponse.PredictionResponseItem item = new PredictionResponse.PredictionResponseItem();
                item.ignored = true;
                item.ignoreReason = message.prePredictIgnoreReasons.get(i);
                resp.results.add(item);
                continue;
            }
            HashMap arguments = Maps.newHashMap();
            for (Map.Entry e : itemToPredict.features.entrySet()) {
                JsonElement v = (JsonElement)e.getValue();
                if (v instanceof JsonPrimitive) {
                    JsonPrimitive pv = (JsonPrimitive)v;
                    if (pv.isNumber()) {
                        arguments.put((String)e.getKey(), pv.getAsNumber().doubleValue());
                        continue;
                    }
                    if (pv.isBoolean()) {
                        arguments.put((String)e.getKey(), pv.getAsBoolean());
                        continue;
                    }
                    arguments.put((String)e.getKey(), pv.getAsString());
                    continue;
                }
                arguments.put((String)e.getKey(), v.toString());
            }
            if (!message.columnsSQLTypes.isEmpty()) {
                for (MemColumn memCol : message.table.columnsList) {
                    Integer sqlType = message.columnsSQLTypes.get(memCol.getName());
                    if (sqlType == null && arguments.containsKey(memCol.getName())) continue;
                    String value = ((MemRow)message.table.rows.get(i)).get((Column)memCol);
                    arguments.put(memCol.getName(), EndpointUtils.getSQLValue(value, sqlType));
                }
            }
            RFunctionRequest kernelReq = new RFunctionRequest();
            kernelReq.params = arguments;
            if (message.apiKey != null) {
                kernelReq.usedAPIKey = this.passwordEncryptionService.decryptIfEncrypted(message.apiKey.key);
            }
            try {
                logger.debugV("Sending request %s to kernel %s", new Object[]{kernelReq.params, this.kernel.getId()});
                kernelRet = (RFunctionKernel.FunctionResponse)this.link.execute((Object)kernelReq, RFunctionKernel.FunctionResponse.class, "Failed to run prediction");
                logger.debugV("Got response to request %s from kernel %s", new Object[]{kernelReq.params, this.kernel.getId()});
            }
            catch (SocketBlockLinkException e) {
                e.withLogTail((IDSSKernelBase)this.kernel);
                throw this.kernel.maybeRethrowAsProcessDied((IOException)((Object)e));
            }
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Kernel returned " + JSON.json((Object)kernelRet)));
            }
            if (!kernelRet.ok) {
                throw new Exception(kernelRet.reason);
            }
            JsonElement ret = kernelRet.resp;
            resp.timing.functionInternal = kernelRet.execTimeUS;
            if (ret != null && ret.isJsonObject()) {
                if (this.ep.modelType == CustomRPredictionEndpointConfig.CustomModelType.CLASSIFICATION) {
                    resp.results.add((PredictionResponse.PredictionResponseItem)JSON.parse((JsonElement)ret, PredictionResponse.ClassificationResponseItem.class));
                    continue;
                }
                resp.results.add((PredictionResponse.PredictionResponseItem)JSON.parse((JsonElement)ret, PredictionResponse.RegressionResponseItem.class));
                continue;
            }
            if (ret != null) {
                if (this.ep.modelType == CustomRPredictionEndpointConfig.CustomModelType.CLASSIFICATION) {
                    PredictionResponse.ClassificationResponseItem classificationItem = new PredictionResponse.ClassificationResponseItem();
                    classificationItem.prediction = ret.getAsString();
                    resp.results.add(classificationItem);
                    continue;
                }
                PredictionResponse.RegressionResponseItem regressionItem = new PredictionResponse.RegressionResponseItem();
                regressionItem.prediction = ret.getAsDouble();
                resp.results.add(regressionItem);
                continue;
            }
            PredictionResponse.PredictionResponseItem item = new PredictionResponse.PredictionResponseItem();
            item.ignored = true;
            item.ignoreReason = PredictionResponse.IgnoreReason.IGNORED_BY_MODEL;
            resp.results.add(item);
        }
        return resp;
    }

    @Override
    public void destroy() {
        if (this.link != null) {
            try {
                this.link.close();
                this.kernel.killWithoutMercy();
            }
            catch (Exception ex) {
                logger.error((Object)"Failed to cleanup custom prediction kernel", (Throwable)ex);
            }
        }
        if (this.kernel != null) {
            this.kernel.killNoWaitNoException(false);
        }
        if (this.kernelWorkDir != null) {
            this.kernelWorkDir.close();
        }
    }

    static class RFunctionRequest {
        Map<String, Object> params;
        String usedAPIKey;

        RFunctionRequest() {
        }
    }
}

