/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.lambda.endpoints.rfunction;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.io.ResponderKernelLink;
import com.dataiku.dip.io.SocketBlockLinkException;
import com.dataiku.dip.kernels.DSSKernelBase;
import com.dataiku.dip.kernels.IDSSKernelBase;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.lambda.LambdaContext;
import com.dataiku.lambda.ServiceGenContext;
import com.dataiku.lambda.endpoints.pool.PoolablePipeline;
import com.dataiku.lambda.endpoints.rfunction.RFunctionKernel;
import com.dataiku.lambda.model.serverconfig.RFunctionEndpointConfig;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class RFunctionPipeline
implements PoolablePipeline {
    private AutoDelete kernelWorkDir;
    private RFunctionKernel kernel;
    private ResponderKernelLink link;
    @Autowired
    private LambdaContext lambdaContext;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.lambda.predict.rfunction");

    public RFunctionPipeline(RFunctionEndpointConfig config, ServiceGenContext ctx) throws Exception {
        SpringUtils.getInstance().autowire((Object)this);
        ArrayList<String> resourceFoldersPaths = new ArrayList<String>();
        for (String mf : config.managedFolderRefs) {
            resourceFoldersPaths.add(ctx.getManagedFolderFolder(mf).getAbsolutePath());
        }
        List<String> codePaths = ctx.getLibPathsInEndpointFolder(config.id);
        this.link = new ResponderKernelLink(SecretKeyGenerator.generate((int)16));
        File codeEnvFolder = ctx.getFileInEndpointFolder(config.id, "R-env-live");
        this.kernelWorkDir = this.lambdaContext.getTempFolder("lambda-rfunc-" + SecretKeyGenerator.generate((int)8));
        logger.infoV("Created temporary kernel work directory %s for service %s - endpoint %s - generation %s", new Object[]{this.kernelWorkDir.getAbsolutePath(), ctx.getServiceId(), config.id, ctx.getGenerationId()});
        try {
            this.kernel = new RFunctionKernel(this.link, ctx, codePaths, codeEnvFolder, (File)this.kernelWorkDir, ApplicationConfigurator.isDevLambdaServer(), (GeneralSettingsDAO.CGrouppableProcessType)(ApplicationConfigurator.isDevLambdaServer() ? GeneralSettingsDAO.CGrouppableProcessType.LAMBDA_DEV_SERVER : null));
            this.kernel.start();
            RFunctionKernel.StartRequest req = new RFunctionKernel.StartRequest(config.userFunctionName, config.passArgumentsAsList, ctx.getFileInEndpointFolder(config.id, "code.R"), resourceFoldersPaths);
            RFunctionKernel.StartResponse started = (RFunctionKernel.StartResponse)this.link.execute((Object)req, RFunctionKernel.StartResponse.class, "Failed to initiate function server");
            if (!started.ok) {
                throw new Exception("Failed to start custom prediction kernel: " + started.reason);
            }
        }
        catch (SocketBlockLinkException e) {
            e.withLogTail((IDSSKernelBase)this.kernel);
            IOException fe = this.kernel.maybeRethrowAsProcessDied((IOException)((Object)e));
            this.cleanupResources();
            throw fe;
        }
        catch (Exception e) {
            this.cleanupResources();
            throw e;
        }
    }

    protected void cleanupResources() {
        try {
            this.link.close();
            this.kernel.killWithoutMercy();
        }
        catch (Exception ex) {
            logger.error((Object)"Failed to cleanup custom prediction kernel", (Throwable)ex);
        }
        try {
            this.kernelWorkDir.close();
        }
        catch (Exception e) {
            logger.error((Object)"Error cleaning kernel work directory", (Throwable)e);
        }
        this.link = null;
        this.kernel = null;
        this.kernelWorkDir = null;
    }

    public DSSKernelBase getKernel() {
        return this.kernel;
    }

    public ResponderKernelLink getLink() {
        return this.link;
    }

    @Override
    public void destroy() {
        if (this.link != null) {
            try {
                this.link.close();
                this.kernel.killWithoutMercy();
            }
            catch (Exception ex) {
                logger.error((Object)"Failed to cleanup custom prediction kernel", (Throwable)ex);
            }
        }
        if (this.kernel != null) {
            this.kernel.killNoWaitNoException(false);
        }
        if (this.kernelWorkDir != null) {
            this.kernelWorkDir.close();
        }
    }
}

