/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.lambda.server;

import com.dataiku.common.server.APIError;
import com.dataiku.common.server.DKUControllerBase;
import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.ApplicativeException;
import com.dataiku.dip.exceptions.NotAuthenticatedException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.io.SocketBlockLinkInteraction;
import com.dataiku.dip.io.SocketBlockLinkKernelException;
import com.dataiku.dip.security.auth.NotLoggedInException;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.lambda.endpoints.EndpointUnavailableException;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.servlet.ModelAndView;

public class LambdaAPIControllerBase
extends DKUControllerBase {
    static final String dssVersion = ApplicationConfigurator.getDSSVersion().product_version;
    private static final boolean PRETTY_RESULTS = false;
    static DKULogger logger = DKULogger.getLogger((String)"dku.lambda.api");

    protected void writeSimpleOK(HttpServletResponse resp) throws IOException {
        JsonObject obj = new JsonObject();
        obj.addProperty("ok", Boolean.valueOf(true));
        LambdaAPIControllerBase.writeJSON(resp, obj);
    }

    public static void setHeader(HttpServletResponse resp) {
        resp.setHeader("DSS-Version", dssVersion);
        resp.setHeader("DSS-APINode-API-Version", "1");
    }

    public static void writeJSON(HttpServletResponse resp, Object data) throws IOException {
        LambdaAPIControllerBase.setHeader(resp);
        if (data == null) {
            resp.setStatus(204);
        } else {
            DIPInternalControllerBase.writeJSON((HttpServletResponse)resp, (Object)data);
        }
    }

    protected void require(boolean test, String msg) {
        if (!test) {
            throw new DKUControllerBase.MalformedRequestException(msg);
        }
    }

    @ExceptionHandler(value={Throwable.class})
    public ModelAndView resolveException(HttpServletRequest req, HttpServletResponse resp, Throwable e) {
        if (e instanceof UnauthorizedException || e instanceof SocketBlockLinkKernelException) {
            logger.errorV("API call '" + req.getRequestURI() + "' failed: %s", new Object[]{e.getLocalizedMessage()});
        } else {
            logger.error((Object)("API call '" + req.getRequestURI() + "' failed"), e);
        }
        try {
            this.sendError(e, resp);
        }
        catch (Exception e2) {
            logger.error((Object)"Additional exception while sending error", (Throwable)e2);
        }
        return null;
    }

    private void sendError(Throwable e, HttpServletResponse resp) throws IOException {
        if (resp.isCommitted()) {
            logger.error((Object)"Response already committed, cannot send error", e);
            resp.sendError(-1);
            return;
        }
        LambdaAPIControllerBase.resetResponseButKeepHeaders((HttpServletResponse)resp);
        if (e instanceof NotLoggedInException || e instanceof NotAuthenticatedException) {
            LambdaAPIControllerBase.sendErrorFromThrowableNoStack((Throwable)e, (int)401, (HttpServletResponse)resp);
        } else if (e instanceof SecurityException || e instanceof UnauthorizedException) {
            LambdaAPIControllerBase.sendErrorFromThrowableNoStack((Throwable)e, (int)403, (HttpServletResponse)resp);
        } else if (e instanceof DKUControllerBase.MalformedRequestException) {
            LambdaAPIControllerBase.sendErrorFromThrowableNoStack((Throwable)e, (int)400, (HttpServletResponse)resp);
        } else if (e instanceof MissingServletRequestParameterException) {
            LambdaAPIControllerBase.sendErrorFromThrowableNoStack((Throwable)e, (int)400, (HttpServletResponse)resp);
        } else if (e instanceof HttpRequestMethodNotSupportedException) {
            LambdaAPIControllerBase.sendErrorFromThrowableNoStack((Throwable)e, (int)405, (HttpServletResponse)resp);
        } else if (e instanceof IllegalArgumentException) {
            LambdaAPIControllerBase.sendErrorFromThrowableNoStack((Throwable)e, (int)400, (HttpServletResponse)resp);
        } else if (e instanceof NotFoundException) {
            LambdaAPIControllerBase.sendErrorFromThrowableNoStack((Throwable)e, (int)404, (HttpServletResponse)resp);
        } else if (e instanceof EndpointUnavailableException) {
            LambdaAPIControllerBase.sendErrorFromThrowableNoStack((Throwable)e, (int)503, (HttpServletResponse)resp);
        } else if (e instanceof APIError.APIErrorException) {
            resp.setStatus(500);
            resp.setContentType("application/json");
            resp.getWriter().write(new Gson().toJson((Object)((APIError.APIErrorException)e).error));
        } else if (e instanceof ApplicativeException) {
            resp.setStatus(400);
            resp.setContentType("application/json");
            APIError ae = new APIError("ApplicativeException", e.getMessage());
            ae.title = ((ApplicativeException)e).getTitle();
            ae.code = ((ApplicativeException)e).code;
            ae.payload = ((ApplicativeException)e).payload;
            resp.getWriter().write(JSON.json((Object)ae));
        } else if (e instanceof SocketBlockLinkKernelException) {
            SocketBlockLinkInteraction.SocketBlockLinkKernelError error = ((SocketBlockLinkKernelException)e).error;
            if ("DkuCustomApiException".equals(error.getPythonExceptionClassName()) && error.customHttpStatusCode != null) {
                resp.setStatus(error.customHttpStatusCode.intValue());
                resp.setContentType("application/json");
                resp.getWriter().write(JSON.json((Object)error));
            } else {
                LambdaAPIControllerBase.sendErrorFromThrowableNoStack((Throwable)e, (int)500, (HttpServletResponse)resp);
            }
        } else {
            LambdaAPIControllerBase.sendErrorFromThrowableNoStack((Throwable)e, (int)500, (HttpServletResponse)resp);
        }
    }

    protected void writeJSON2(HttpServletResponse resp, Object obj) throws IOException {
        LambdaAPIControllerBase.writeJSON(resp, obj);
    }
}

