/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml.prediction.flow;

import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.MLPaths;
import com.dataiku.dip.analysis.ml.prediction.flow.AbstractPredictionScoringRecipePayloadParams;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.containers.exec.ContainerExecConfigSelector;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.containers.exec.ContainerExecSelection;
import com.dataiku.dip.containers.exec.KubernetesExecUtils;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.AbstractPythonRecipeRunner;
import com.dataiku.dip.dataflow.exec.ContainerRecipeParams;
import com.dataiku.dip.dataflow.exec.EnvironmentStash;
import com.dataiku.dip.dataflow.utils.FlowJobUtils;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.remoterun.RemoteRunsRegistry;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.impersonation.FilesystemACLUtils;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.utils.DKULogger;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public abstract class PyPredictionScoringRecipeSubrunner
extends AbstractPythonRecipeRunner {
    protected String baseRecipeJobDir;
    protected DKULogger logger;
    protected final FullModelId fmi;
    private final File activeModelFolder;
    private final AuthCtx authCtx;
    private final String codeEnvName;
    private final AbstractPredictionScoringRecipePayloadParams desc;
    private final RemoteRunsRegistry.ExecutionType executionType;
    private final AutoDelete outputTmpDir;
    private final JsonObject containerPayload;
    private final String command;
    private final String[] noContainerCommandArgs;

    protected PyPredictionScoringRecipeSubrunner(JobActivity activity, FullModelId fmi, File activeModelFolder, AuthCtx authCtx, String codeEnvName, AbstractPredictionScoringRecipePayloadParams desc, RemoteRunsRegistry.ExecutionType executionType, AutoDelete outputTmpDir, JsonObject containerPayload, String command, String ... cmdArgs) {
        super(activity);
        this.fmi = fmi;
        this.activeModelFolder = activeModelFolder;
        this.authCtx = authCtx;
        this.codeEnvName = codeEnvName;
        this.desc = desc;
        this.executionType = executionType;
        this.outputTmpDir = outputTmpDir;
        this.containerPayload = containerPayload;
        this.command = command;
        this.noContainerCommandArgs = cmdArgs;
    }

    @Override
    protected EnvironmentStash prepareEnvStash(File tmpDir, Map<String, String> extraEnv, ContainerExecRuntimeConfig containerConfig, String envName) throws IOException, SQLException, CodedException, DKUSecurityException, InterruptedException {
        EnvironmentStash envStash = super.prepareEnvStash(tmpDir, extraEnv, containerConfig, envName);
        return envStash;
    }

    @Override
    public void run() throws Exception {
        FilesystemACLUtils.grantFSReadACLs(this.authCtx, this.projectKey, this.fmi.getFolderEnsuringSecurity());
        FilesystemACLUtils.grantFSFullACLs(this.authCtx, this.projectKey, this.activeModelFolder);
        FilesystemACLUtils.grantFSFullACLs(this.authCtx, this.projectKey, new File[]{this.outputTmpDir});
        CodeEnvModel.UsedCodeEnvRef codeEnvRef = new CodeEnvModel.UsedCodeEnvRef(CodeEnvModel.EnvLang.PYTHON, this.codeEnvName);
        this.logger.info((Object)("Run recipe in code env " + StringUtils.defaultIfBlank((String)this.codeEnvName, (String)"built-in")));
        File additionalLogsDir = FlowJobUtils.getJobMadeDir(this.baseRecipeJobDir, "additional-logs");
        File mainLogFile = FlowJobUtils.getJobTouchedFile(this.baseRecipeJobDir, "python.log");
        ContainerExecSelection containerSelection = this.recipe.getModel().getParamsAs(ContainerRecipeParams.class).getContainerSelection();
        ContainerExecRuntimeConfig containerConfig = new ContainerExecConfigSelector().selectForML_autoTXN(this.authCtx, this.recipe.getProjectKey(), containerSelection, this.desc.backendType);
        if (containerConfig == null) {
            this.executeModule(this.codeEnvName, (File)this.outputTmpDir, this.command, this.noContainerCommandArgs);
        } else {
            switch (containerConfig.type) {
                case DOCKER: {
                    this.executeDockerCodeRecipe(codeEnvRef, containerConfig, this.activeModelFolder, mainLogFile, this.outputTmpDir, this.executionType, this.containerPayload.toString(), Collections.emptyMap(), this.getContainerizedReadablePaths(), this.getContainerizedWritablePaths());
                    break;
                }
                case KUBERNETES: {
                    this.executeKubernetesCodeRecipe(codeEnvRef, containerConfig, this.activeModelFolder, mainLogFile, additionalLogsDir, this.outputTmpDir, this.executionType, this.containerPayload.toString(), Collections.emptyMap(), this.getContainerizedReadablePaths(), this.getContainerizedWritablePaths(), new KubernetesExecUtils.KubernetesFailureCodeProvider(){

                        @Override
                        public InfoMessage.MessageCode codeForOOMKilled() {
                            return RecipeCodes.ERR_RECIPE_ML_SCORING_K8S_OOM;
                        }
                    });
                }
            }
        }
    }

    List<String> getContainerizedWritablePaths() {
        return Collections.singletonList(this.outputTmpDir.getAbsolutePath());
    }

    List<String> getContainerizedReadablePaths() {
        ArrayList<String> ret = new ArrayList<String>();
        ret.add(MLPaths.savedModelBaseFolder(this.fmi.getProjectKey(), this.fmi.getSavedModelID()).getAbsolutePath());
        ret.add(this.outputTmpDir.getAbsolutePath());
        return ret;
    }

    @Override
    public void init() throws Exception {
    }

    public static class Evaluation
    extends PyPredictionScoringRecipeSubrunner {
        private final File evaluationStoreFolder;

        private List<String> enrichListWithEvaluationStoreFolder(List<String> paths) {
            if (this.evaluationStoreFolder == null) {
                return paths;
            }
            ArrayList<String> ret = new ArrayList<String>(paths);
            ret.add(this.evaluationStoreFolder.getAbsolutePath());
            return ret;
        }

        @Override
        List<String> getContainerizedWritablePaths() {
            return this.enrichListWithEvaluationStoreFolder(super.getContainerizedWritablePaths());
        }

        @Override
        List<String> getContainerizedReadablePaths() {
            return this.enrichListWithEvaluationStoreFolder(super.getContainerizedReadablePaths());
        }

        public Evaluation(JobActivity activity, FullModelId fmi, File activeModelFolder, @Nullable File evaluationStoreFolder, AuthCtx authCtx, String codeEnvName, AbstractPredictionScoringRecipePayloadParams desc, RemoteRunsRegistry.ExecutionType executionType, AutoDelete outputTmpDir, JsonObject containerPayload, String command, String ... cmdArgs) {
            super(activity, fmi, activeModelFolder, authCtx, codeEnvName, desc, executionType, outputTmpDir, containerPayload, command, cmdArgs);
            this.baseRecipeJobDir = "evaluation-recipe";
            this.evaluationStoreFolder = evaluationStoreFolder;
            this.logger = DKULogger.getLogger((String)"dku.recipes.prediction.evaluation");
        }
    }

    public static class Scoring
    extends PyPredictionScoringRecipeSubrunner {
        public Scoring(JobActivity activity, FullModelId fmi, File activeModelFolder, AuthCtx authCtx, String codeEnvName, AbstractPredictionScoringRecipePayloadParams desc, RemoteRunsRegistry.ExecutionType executionType, AutoDelete outputTmpDir, JsonObject containerPayload, String command, String ... cmdArgs) {
            super(activity, fmi, activeModelFolder, authCtx, codeEnvName, desc, executionType, outputTmpDir, containerPayload, command, cmdArgs);
            this.baseRecipeJobDir = "scoring-recipe";
            this.logger = DKULogger.getLogger((String)"dku.recipes.prediction.scoring");
        }
    }
}

