/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml.vectorstore;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.security.IPBlacklistVerifier;
import com.dataiku.dip.server.services.ConnectionsTestService;
import com.dataiku.dip.util.ProxyUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.PerfUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.dataiku.dss.shadelib.org.apache.http.Header;
import com.dataiku.dss.shadelib.org.apache.http.HttpEntity;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.CloseableHttpResponse;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpGet;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpUriRequest;
import com.dataiku.dss.shadelib.org.apache.http.impl.client.CloseableHttpClient;
import com.dataiku.dss.shadelib.org.apache.http.impl.client.HttpClientBuilder;
import com.dataiku.dss.shadelib.org.apache.http.message.BasicHeader;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.utils.URIBuilder;

public abstract class VectorStoreConnectionRestClient
implements AutoCloseable {
    private final BasicHeader authHeader;
    private final ProxySettings proxySettings;
    private final CloseableHttpClient httpClient;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.vectorStoreRestClient");

    protected VectorStoreConnectionRestClient(String connectionType, BasicHeader authHeader) {
        this.authHeader = authHeader;
        this.proxySettings = ApplicationConfigurator.getProxySettings();
        int concurrentConnections = DKUApp.getParams().getIntParam("dku.ml." + connectionType.toLowerCase() + ".httpClientConcurrency", Integer.valueOf(8));
        int connectionsTTL = DKUApp.getParams().getIntParam("dku.ml." + connectionType.toLowerCase() + ".connectionsTimeToLiveInSeconds", Integer.valueOf(30));
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create().addInterceptorFirst(PerfUtils.MARK_HTTP_REQUEST_INTERCEPTOR).setMaxConnPerRoute(concurrentConnections).setConnectionTimeToLive((long)connectionsTTL, TimeUnit.SECONDS);
        this.httpClient = ProxyUtils.applyProxySettings((ProxySettings)this.proxySettings, (HttpClientBuilder)httpClientBuilder).build();
    }

    protected abstract String getClientEndpointUrl();

    protected abstract String parseErrorResponse(String var1);

    protected static boolean isURL(String nameOrURL) {
        return nameOrURL.startsWith("http://") || nameOrURL.startsWith("https://");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ConnectionsTestService.VectorStoreConnectionTestResult testAuth() {
        URIBuilder url = new URIBuilder(URI.create(this.getClientEndpointUrl()));
        try (CloseableHttpResponse resp = this.rawCall(url.toString());){
            if (200 == resp.getStatusLine().getStatusCode()) {
                ConnectionsTestService.VectorStoreConnectionTestResult vectorStoreConnectionTestResult2 = ConnectionsTestService.VectorStoreConnectionTestResult.ok();
                return vectorStoreConnectionTestResult2;
            }
            ConnectionsTestService.VectorStoreConnectionTestResult vectorStoreConnectionTestResult = ConnectionsTestService.VectorStoreConnectionTestResult.error("Error when attempting to fetch indexes: " + resp.getStatusLine().getReasonPhrase());
            return vectorStoreConnectionTestResult;
        }
        catch (Exception e) {
            return ConnectionsTestService.VectorStoreConnectionTestResult.error(e);
        }
    }

    private CloseableHttpResponse rawCall(String url) throws IOException {
        IPBlacklistVerifier.validateUriNotBlacklisted(url, this.proxySettings);
        logger.info((Object)("Fetching: " + url));
        HttpGet req = new HttpGet(url);
        if (this.authHeader == null || this.authHeader.getValue() == null) {
            throw new IOException("Missing authentication header");
        }
        logger.info((Object)String.format("Setting authorization header '%s'", this.authHeader.getName()));
        req.setHeader((Header)this.authHeader);
        CloseableHttpResponse resp = this.httpClient.execute((HttpUriRequest)req);
        HttpEntity respEntity = resp.getEntity();
        long length = respEntity.getContentLength();
        boolean hasContentType = respEntity.getContentType() != null && respEntity.getContentType().getValue() != null;
        boolean isJson = hasContentType && respEntity.getContentType().getValue().startsWith("application/json");
        int code = resp.getStatusLine().getStatusCode();
        logger.info((Object)("HTTP " + code + " (" + length + " bytes)"));
        if (code != 200) {
            try {
                InputStream is = ByteStreams.limit((InputStream)respEntity.getContent(), (long)0x100000L);
                String data = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
                if (isJson) {
                    String parsedError = this.parseErrorResponse(data);
                    throw new ResponseException(code, "HTTP " + code + ": " + parsedError);
                }
                if (!Objects.equals(data, "")) {
                    throw new ResponseException(code, "HTTP " + code + ": " + data);
                }
                throw new ResponseException(code, "HTTP " + code + ": " + resp.getStatusLine().getReasonPhrase());
            }
            catch (Throwable throwable) {
                resp.close();
                throw throwable;
            }
        }
        return resp;
    }

    @Override
    public void close() throws Exception {
        try {
            this.httpClient.close();
        }
        catch (IOException e) {
            logger.error((Object)"Error while closing Vector Store Rest client", (Throwable)e);
        }
    }

    public static class ResponseException
    extends HttpResponseException {
        public ResponseException(int statusCode, String reasonPhrase) {
            super(statusCode, reasonPhrase);
        }
    }
}

