/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.model.clustering.algorithms;

import com.dataiku.dip.analysis.model.ClusteringModelingParams;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.clustering.ClusteringMLTask;
import com.dataiku.dip.analysis.model.clustering.ClusteringParameterChecks;
import com.dataiku.dip.analysis.model.clustering.PreTrainClusteringModelingParams;
import com.dataiku.dip.analysis.model.clustering.algorithms.ClusteringAlgorithmMeta;
import com.dataiku.dip.analysis.model.core.WorkSet;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.Type;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

public class IsolationForestMeta
extends ClusteringAlgorithmMeta {
    private final MLTask.BackendType backendType;

    public IsolationForestMeta(MLTask.BackendType backendType) {
        this.backendType = backendType;
    }

    @Override
    public MLTask.BackendType backendType() {
        return this.backendType;
    }

    @Override
    public String generateName(PreTrainClusteringModelingParams rpmp) {
        return "Isolation Forest (Anomaly Detection)";
    }

    @Override
    public String generateDescription(PreTrainClusteringModelingParams rpmp) {
        return "Isolation Forest (Anomaly Detection)";
    }

    @Override
    public void validateParameters(ClusteringModelingParams pmp, ClusteringMLTask task, ClusteringParameterChecks checks) {
    }

    @Override
    public List<WorkSet.ModelingSet> expandModeling(ClusteringModelingParams pmp, ClusteringMLTask task) {
        ArrayList<WorkSet.ModelingSet> ret = new ArrayList<WorkSet.ModelingSet>();
        ClusteringModelingParams.IsolationForestParams iso = task.modeling.isolation_forest;
        if (iso.enabled && task.backendType == this.backendType) {
            PreTrainClusteringModelingParams.Algorithm algo = this.backendType == MLTask.BackendType.PY_MEMORY ? PreTrainClusteringModelingParams.Algorithm.PY_ISOLATION_FOREST : PreTrainClusteringModelingParams.Algorithm.MLLIB_ISOLATION_FOREST;
            PreTrainClusteringModelingParams rcmp = new PreTrainClusteringModelingParams(algo);
            rcmp.isolation_forest = iso;
            ret.add(new WorkSet.ModelingSet(rcmp));
        }
        return ret;
    }

    @Override
    public List<SchemaColumn> additionalScoringColumns() {
        return Lists.newArrayList((Object[])new SchemaColumn[]{new SchemaColumn("anomaly_score", Type.DOUBLE)});
    }
}

