/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.apideployer.deployments;

import com.dataiku.dip.apideployer.datamodel.config.AbstractDeployment;
import com.dataiku.dip.apideployer.deployments.DeploymentsDAO;
import com.dataiku.dip.dao.AbstractGlobalDAO;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.google.common.base.Preconditions;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public abstract class FileBasedDeploymentsDAO<D extends AbstractDeployment>
extends AbstractGlobalDAO<D>
implements DeploymentsDAO<D> {
    public static final String DEPLOYMENTS = "deployments";

    public abstract Class<D> getDeploymentClass();

    private D readDeployment(TransactionRef tr, RelFile file, boolean unsafe, String id) throws IOException {
        AbstractDeployment di = unsafe ? (AbstractDeployment)tr.readObjectUnsafe(file, this.getDeploymentClass()) : (AbstractDeployment)tr.readObject(file, this.getDeploymentClass());
        di.id = id;
        return (D)di;
    }

    protected List<D> list(boolean unsafe) throws IOException {
        TransactionRef tr = TransactionContext.retrieveRead();
        RelFile folder = this.deploymentsDir();
        ArrayList<D> ret = new ArrayList<D>();
        if (tr.isDirectory(folder)) {
            for (RelFile file : tr.listFiles(folder)) {
                if (!file.getLeafName().endsWith(".json")) continue;
                try {
                    String deploymentId = file.getLeafName().replace(".json", "");
                    ret.add(this.readDeployment(tr, file, unsafe, deploymentId));
                }
                catch (JsonParseException | IOException e) {
                    this.logger.warn((Object)String.format("Failed to read %s %s", this.getType(), file), e);
                }
            }
        }
        return ret;
    }

    protected D getOrNull(String id, boolean unsafe) throws IOException {
        RelFile file;
        TransactionRef tr = TransactionContext.retrieveRead();
        if (tr.exists(file = this.getDAOFile(id))) {
            return this.readDeployment(tr, file, unsafe, id);
        }
        return null;
    }

    protected abstract RelFile deploymentsDir();

    @Override
    public void save(D deployment) throws IOException {
        assert (((AbstractDeployment)deployment).id != null);
        RWTransactionRef tr = TransactionContext.retrieveWrite();
        RelFile file = this.getDAOFile(((AbstractDeployment)deployment).id);
        tr.writeObject(file, deployment);
    }

    public void delete(String id) throws IOException {
        RWTransactionRef tr = TransactionContext.retrieveWrite();
        tr.deleteFile(this.getDAOFile(id));
    }

    public int approximateCount() throws IOException {
        RelFile folder;
        TransactionRef tr = TransactionContext.retrieveRead();
        if (!tr.isDirectory(folder = this.deploymentsDir())) {
            return 0;
        }
        return tr.listFiles(folder).size();
    }

    protected RelFile getDAOFile(String id) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)id), (Object)(this.getType() + " id is not specified"));
        return new RelFile(this.deploymentsDir(), new String[]{id + ".json"});
    }
}

