/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.apideployer.published;

import com.dataiku.dip.apideployer.datamodel.config.PublishedItem;
import com.dataiku.dip.apideployer.published.PublishedItemsDAO;
import com.dataiku.dip.dao.AbstractGlobalDAO;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public abstract class FileBasedPublishedItemsDAO
extends AbstractGlobalDAO<PublishedItem>
implements PublishedItemsDAO {
    protected List<PublishedItem> list(boolean unsafe) throws IOException {
        TransactionRef tr = TransactionContext.retrieveRead();
        RelFile folder = this.publishedItemsDir();
        ArrayList<PublishedItem> ret = new ArrayList<PublishedItem>();
        if (tr.isDirectory(folder)) {
            for (RelFile file : tr.listFiles(folder)) {
                if (!file.getLeafName().endsWith(".json")) continue;
                try {
                    PublishedItem di = unsafe ? (PublishedItem)tr.readObjectUnsafe(file, PublishedItem.class) : (PublishedItem)tr.readObject(file, PublishedItem.class);
                    di.id = file.getLeafName().replace(".json", "");
                    ret.add(di);
                }
                catch (IOException e) {
                    this.logger.warn((Object)("Failed to read published " + this.getType() + " " + String.valueOf(file)), (Throwable)e);
                }
            }
        }
        return ret;
    }

    protected PublishedItem getOrNull(String id, boolean unsafe) throws IOException {
        RelFile file;
        TransactionRef tr = TransactionContext.retrieveRead();
        if (tr.exists(file = this.getDAOFile(id))) {
            PublishedItem ret = unsafe ? (PublishedItem)tr.readObjectUnsafe(file, PublishedItem.class) : (PublishedItem)tr.readObject(file, PublishedItem.class);
            ret.id = id;
            return ret;
        }
        return null;
    }

    @Override
    public void save(PublishedItem publishedItem) throws IOException {
        assert (publishedItem.id != null);
        RWTransactionRef tr = TransactionContext.retrieveWrite();
        RelFile file = this.getDAOFile(publishedItem.id);
        tr.writeObject(file, (Object)publishedItem);
    }

    public void delete(String id) throws IOException {
        RWTransactionRef tr = TransactionContext.retrieveWrite();
        tr.deleteFile(this.getDAOFile(id));
    }

    public int approximateCount() throws IOException {
        RelFile folder;
        TransactionRef tr = TransactionContext.retrieveRead();
        if (!tr.isDirectory(folder = this.publishedItemsDir())) {
            return 0;
        }
        return tr.listFiles(folder).size();
    }

    public abstract String getType();

    public abstract String getDeployerDirectoryString();

    public abstract String getTypeSubdirectoryString();

    private RelFile publishedItemsDir() {
        return new RelFile(new String[]{this.getDeployerDirectoryString(), this.getTypeSubdirectoryString()});
    }

    protected RelFile getDAOFile(String id) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)id), (Object)("Published " + this.getType() + " id is not specified"));
        return new RelFile(this.publishedItemsDir(), new String[]{id + ".json"});
    }
}

