/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.autorestart;

import com.dataiku.dip.autorestart.AutoRestartingLoopCurrentState;
import com.dataiku.dip.autorestart.AutoRestartingProcessRunner;
import com.dataiku.dip.futures.FutureAborter;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import java.util.HashMap;

public abstract class AutoRestartingLoopThread
extends SimpleFutureThread<Void> {
    private final AutoRestartingLoopCurrentState myState;
    private final AutoRestartingLoopParams params;
    public final String runId;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.autorestart.loopthread");

    public AutoRestartingLoopThread(AutoRestartingLoopCurrentState state, AutoRestartingLoopParams params, AuthCtx owner, String runId) {
        super(owner);
        this.params = params;
        this.myState = state;
        this.myState.futureId = this.jobId;
        this.runId = runId;
    }

    protected abstract AutoRestartingProcessRunner buildRunner();

    @Override
    protected Void compute() throws Exception {
        logger.info((Object)"Start backend (re)start MainLoop");
        long currentRestartDelay = this.params.initialRestartDelayMS;
        try (FutureAborter.AutoCloseableAbortHook hook = FutureAborter.pushAutoCloseableHook((Runnable)new Runnable(){

            @Override
            public void run() {
                logger.info((Object)"MainLoopThread future abort hook - stopping the runner");
                AutoRestartingLoopThread.this.myState.stopNoWait();
            }
        });){
            while (!this.myState.abortLoop && !this.isAborted()) {
                try {
                    this.myState.runner = this.buildRunner();
                    this.myState.runner.run();
                }
                catch (AutoRestartingProcessRunner.BackendStartFailedException e) {
                    logger.error((Object)"Backend start failed, aborting restart loop", (Throwable)e);
                    this.myState.startFailedException = e;
                    ++this.myState.crashCount;
                    this.myState.lastCrashLogTail = this.myState.runner.getLogTail();
                    logger.warn((Object)("Recorded crash log: " + JSON.pretty((Object)this.myState.lastCrashLogTail)));
                    this.myState.runner = null;
                    this.myState.port = null;
                    throw e;
                }
                catch (AutoRestartingProcessRunner.BackendDiedException e) {
                    this.myState.diedException = e;
                    if (!this.myState.abortLoop && !this.isAborted()) {
                        ++this.myState.crashCount;
                        this.myState.lastCrashLogTail = this.myState.runner.getLogTail();
                        logger.error((Object)("Backend died, crashCount=" + this.myState.crashCount), (Throwable)e);
                        logger.warn((Object)("Recorded crash log: " + JSON.pretty((Object)this.myState.lastCrashLogTail)));
                        if (this.params.abortAfterCrashes >= 0 && this.myState.crashCount >= this.params.abortAfterCrashes) {
                            logger.info((Object)("Backend died too many times, aborting (max= " + this.params.abortAfterCrashes + ")"));
                            this.myState.runner = null;
                            this.myState.port = null;
                            throw e;
                        }
                        currentRestartDelay += this.params.restartDelayIncMS;
                        if (this.params.maxRestartDelayMS > 0L) {
                            currentRestartDelay = Math.min(currentRestartDelay, this.params.maxRestartDelayMS);
                        }
                        logger.info((Object)("Will restart backend, after " + currentRestartDelay + " wait ..."));
                        Thread.sleep(currentRestartDelay);
                    } else {
                        logger.info((Object)"Backend died, was aborted", (Throwable)e);
                    }
                    this.myState.runner = null;
                    this.myState.port = null;
                }
                logger.info((Object)("Runner terminated abortLoop=" + this.myState.abortLoop));
                this.myState.runner = null;
                this.myState.port = null;
            }
            Void void_ = null;
            return void_;
        }
    }

    protected void enrichPayloadWithState(FuturePayload fp) {
        fp.extras = new HashMap();
        if (this.myState != null) {
            if (this.myState.port != null) {
                fp.extras.put("port", this.myState.port);
            }
            if (this.myState.runner != null) {
                fp.extras.put("pid", this.myState.runner.getPid());
            }
            fp.extras.put("crashCount", this.myState.crashCount);
        }
    }

    public static class AutoRestartingLoopParams {
        public int abortAfterCrashes = -1;
        public long initialRestartDelayMS = 0L;
        public long maxRestartDelayMS = 0L;
        public long restartDelayIncMS = 0L;
    }
}

