/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.cli;

import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.export.ZipUnzipDir;
import com.dataiku.dip.plugins.IPluginsRegistryService;
import com.dataiku.dip.plugins.RegularPluginsRegistryService;
import com.dataiku.dip.plugins.model.InstalledPluginState;
import com.dataiku.dip.plugins.model.PluginDesc;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import java.io.File;
import java.io.IOException;

public class PluginInstaller {
    public static String installFromZip(File archiveFile, AuthCtx installUser, boolean isUpdate, File targetDir) throws Exception {
        try (AutoDelete tmpDir = DSSTempUtils.getTempFolder((String)"plugin-install", (String)archiveFile.getName());){
            File tmpUnzipDir = new File((File)tmpDir, "unzip");
            ZipUnzipDir.extractFolder(archiveFile, tmpUnzipDir);
            String string = PluginInstaller.install((File)tmpDir, tmpUnzipDir, installUser, isUpdate, targetDir);
            return string;
        }
    }

    public static String installFromPath(File pluginDir, AuthCtx installUser, boolean isUpdate, File targetDir) throws Exception {
        try (AutoDelete tmpDir = DSSTempUtils.getTempFolder((String)"plugin-install", (String)pluginDir.getName());){
            String string = PluginInstaller.install((File)tmpDir, pluginDir, installUser, isUpdate, targetDir);
            return string;
        }
    }

    private static String install(File tmpDir, File pluginDir, AuthCtx installUser, boolean isUpdate, File targetDir) throws Exception {
        File pluginJSON;
        File tmpOldDir = new File(tmpDir, "old");
        File truePluginDir = pluginDir;
        if (!new File(pluginDir, "plugin.json").exists()) {
            File dirCandidate = null;
            for (File sub : pluginDir.listFiles()) {
                if (!sub.isDirectory() || !new File(sub, "plugin.json").exists()) continue;
                if (dirCandidate != null) {
                    throw new Exception("This plugin doesn't contain a plugin.json at top level, but several plugin.json below. Cannot choose the right one.");
                }
                dirCandidate = sub;
            }
            if (dirCandidate != null) {
                truePluginDir = dirCandidate;
            }
        }
        if (!(pluginJSON = new File(truePluginDir, "plugin.json")).isFile()) {
            throw new Exception("Missing descriptor: plugin.json not found in " + String.valueOf(truePluginDir));
        }
        PluginDesc pd = (PluginDesc)JSON.parseFile((File)pluginJSON, PluginDesc.class);
        if (pd.id == null || pd.id.length() == 0) {
            throw new Exception("Invalid plugin.json in the archive: the identifier field 'id' is not defined");
        }
        File devDir = RegularPluginsRegistryService.getDevPluginFolder(pd.id);
        if (devDir != null && devDir.exists()) {
            if (!isUpdate) {
                throw new CodedException((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_NOT_ALLOWED, "Target " + devDir.getAbsolutePath() + " already exists, you cannot upload it again");
            }
            throw new CodedException((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_NOT_ALLOWED, "Target " + devDir.getAbsolutePath() + " is a development plugin, you cannot update it");
        }
        if (targetDir == null) {
            targetDir = RegularPluginsRegistryService.getInstalledPluginFolder(pd.id);
        }
        if (isUpdate && !targetDir.exists()) {
            throw new CodedException((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_NOT_INSTALLED, "Target " + targetDir.getAbsolutePath() + " does not exist, you cannot update it");
        }
        if (!isUpdate && targetDir.exists()) {
            throw new CodedException((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_NOT_ALLOWED, "Target " + targetDir.getAbsolutePath() + " already exists, you should update it");
        }
        String pluginId = pd.id;
        System.out.println();
        System.out.println("Installing plugin " + pluginId + " into " + targetDir.getAbsolutePath());
        System.out.println();
        InstalledPluginState.PluginActionRecord record = new InstalledPluginState.PluginActionRecord();
        record.ts = System.currentTimeMillis();
        record.user = installUser.getIdentifier();
        record.action = isUpdate ? InstalledPluginState.PluginActionType.UPGRADE : InstalledPluginState.PluginActionType.INSTALL;
        InstalledPluginState ips = null;
        File stateFile = new File(targetDir, "state.json");
        if (isUpdate) {
            if (!stateFile.exists()) {
                throw new IOException("Plugin state file does not exist: " + String.valueOf(stateFile));
            }
            ips = (InstalledPluginState)JSON.parseFile((File)stateFile, InstalledPluginState.class);
        } else {
            ips = new InstalledPluginState();
        }
        ips.actions.add(record);
        try {
            if (isUpdate) {
                FileUtils.moveDirectory((File)targetDir, (File)tmpOldDir);
            }
            assert (!targetDir.isDirectory());
            try {
                DKUFileUtils.mkdirsParent((File)targetDir);
                FileUtils.moveDirectory((File)truePluginDir, (File)targetDir);
                JSON.prettyToFile((Object)ips, (File)stateFile);
            }
            catch (Exception e) {
                DKUFileUtils.deleteDirectory((File)targetDir);
                throw e;
            }
            System.out.println();
            System.out.println("Installation of plugin " + pluginId + " done. Restart DSS to use your plugin");
            System.out.println();
            return pd.id;
        }
        catch (Exception ex) {
            if (isUpdate) {
                System.out.println();
                System.out.println("Failed to install new version of plugin, rolling back the old files");
                System.out.println();
                DKUFileUtils.deleteDirectory((File)targetDir);
                FileUtils.moveDirectory((File)tmpOldDir, (File)targetDir);
            }
            throw ex;
        }
    }
}

