/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.cluster;

import com.dataiku.dip.cluster.ClusterSettings;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.io.AbstractNonImpersonatedSecretProtectedPythonKernel;
import com.dataiku.dip.io.SingleCommandKernelLink;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.process.IsolableProcess;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.utils.DKUtils;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;

public class PythonClusterKernel
extends AbstractNonImpersonatedSecretProtectedPythonKernel<SingleCommandKernelLink> {
    private final OutputStream outputLog;
    private final APITicketService.Ticket ticket;

    public PythonClusterKernel(SingleCommandKernelLink link, APITicketService.Ticket ticket, String pluginResourceFolderPath, String pluginPythonLibFolderPath, File tmpDir, OutputStream outputLog, boolean impersonate, String projectKey, AuthCtx authCtx, String envName) {
        super(authCtx, link, null, pluginResourceFolderPath, PythonClusterKernel.makePythonLibs("plugin-lib", pluginPythonLibFolderPath), projectKey, envName, tmpDir);
        this.ticket = ticket;
        this.outputLog = outputLog;
    }

    @Override
    protected String getPythonModule() {
        return "dataiku.cluster.server";
    }

    protected void startStandardTailers() throws IOException {
        this.outputConsumer.withOutputConsumer((DKUtils.ExecSubscription)new DKUtils.TailerLineSubscription(this.smartLogTailBuilder));
        this.outputConsumer.withErrorConsumer((DKUtils.ExecSubscription)new DKUtils.TailerLineSubscription(this.smartLogTailBuilder));
        this.outputConsumer.withOutputConsumer((DKUtils.ExecSubscription)new DKUtils.OutputStreamSubscription(this.outputLog, true));
        this.outputConsumer.withErrorConsumer((DKUtils.ExecSubscription)new DKUtils.OutputStreamSubscription(this.outputLog, true));
    }

    @Override
    protected IsolableProcess createAndStartProcess(ProcessBuilder pb, GeneralSettingsDAO.CGrouppableProcessType cgrouppableProcessType) throws DKUSecurityException, IOException, InterruptedException {
        pb.environment().put("DKU_API_TICKET", this.ticket.getSecret());
        return super.createAndStartProcess(pb, cgrouppableProcessType);
    }

    public static class ClusterResponse {
        public boolean ok;
        public JsonObject response;
    }

    public static class ClusterStartResponse {
        public JsonObject hadoopSettings;
        public JsonObject hiveSettings;
        public JsonObject impalaSettings;
        public JsonObject sparkSettings;
        public JsonObject containerSettings;
        public JsonObject data;
    }

    public static class ClusterCommand {
        public final String code;
        public final String clusterId;
        public final String clusterName;
        public final JsonObject config;
        public final JsonObject pluginConfig;
        public final String type;
        public final JsonObject data;
        public final ClusterSettings globalSettings;

        public ClusterCommand(String clusterId, String clusterName, String code, JsonObject config, JsonObject pluginConfig, String type, JsonObject data, ClusterSettings globalSettings) {
            this.clusterId = clusterId;
            this.clusterName = clusterName;
            this.code = code;
            this.config = config;
            this.pluginConfig = pluginConfig;
            this.type = type;
            this.data = data;
            this.globalSettings = globalSettings;
        }
    }
}

