/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.codestudio.blocks;

import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.codestudio.CodeStudioMeta;
import com.dataiku.dip.codestudio.blocks.BlockBasedCodeStudioTemplateParams;
import com.dataiku.dip.codestudio.blocks.CodeStudioBlock;
import com.dataiku.dip.codestudio.blocks.CodeStudioBlockRegistry;
import com.dataiku.dip.codestudio.object.CodeStudioObject;
import com.dataiku.dip.codestudio.template.CodeStudioTemplate;
import com.dataiku.dip.codestudio.template.CodeStudioTemplateParams;
import com.dataiku.dip.containers.exec.KubernetesExecUtils;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;

public class BlockBasedCodeStudioMeta
implements CodeStudioMeta {
    public static final String TYPE = "block_based";
    private static Logger logger = Logger.getLogger((String)"dip.codestudio.blockBased");

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public boolean isPublic() {
        return true;
    }

    @Override
    public CodeStudioTemplate.CodeStudioTemplateType getTemplateType() {
        CodeStudioTemplate.CodeStudioTemplateType ret = new CodeStudioTemplate.CodeStudioTemplateType();
        ret.type = this.getType();
        ret.label = "Defined by building blocks";
        ret.description = "User-specified set of building blocks";
        return ret;
    }

    @Override
    public CodeStudioObject.CodeStudioObjectType getCodeStudioType(CodeStudioTemplate template) {
        CodeStudioObject.CodeStudioObjectType ret = new CodeStudioObject.CodeStudioObjectType();
        ret.type = this.getType();
        ret.templateId = template.id;
        ret.label = template.getLabel();
        ret.shortDesc = template.shortDesc;
        ret.icon = template.icon;
        return ret;
    }

    @Override
    public Class<? extends CodeStudioTemplateParams> templateParamsClass() {
        return BlockBasedCodeStudioTemplateParams.class;
    }

    @Override
    public List<CodeEnvModel.CodeEnvUsage> collectUsages(CodeStudioTemplate template) {
        ArrayList usages = Lists.newArrayList();
        BlockBasedCodeStudioTemplateParams params = template.getParamsAs(BlockBasedCodeStudioTemplateParams.class);
        for (CodeStudioBlock b : params.blocks) {
            usages.addAll(CodeStudioBlockRegistry.getMeta(b).collectUsages(b, template));
        }
        return usages;
    }

    @Override
    public CodeStudioMeta.CreationSpec getCreationSpec(AuthCtx authCtx, CodeStudioTemplate template, CodeStudioMeta.CreationEnv creationEnv) throws Exception {
        BlockBasedCodeStudioTemplateParams params = template.getParamsAs(BlockBasedCodeStudioTemplateParams.class);
        CodeStudioMeta.CreationSpec ret = new CodeStudioMeta.CreationSpec();
        for (CodeStudioBlock b : params.blocks) {
            ret = CodeStudioBlockRegistry.getMeta(b).apply(authCtx, b, ret, creationEnv);
        }
        return ret;
    }

    @Override
    public CodeStudioMeta.ImageBuildSpec getBuildSpec(AuthCtx authCtx, CodeStudioTemplate template, CodeStudioMeta.ImageBuildEnv buildEnv) throws IOException, DKUSecurityException {
        BlockBasedCodeStudioTemplateParams params = template.getParamsAs(BlockBasedCodeStudioTemplateParams.class);
        CodeStudioMeta.ImageBuildSpec spec = new CodeStudioMeta.ImageBuildSpec();
        for (CodeStudioBlock b : params.blocks) {
            spec = CodeStudioBlockRegistry.getMeta(b).apply(authCtx, b, spec, buildEnv, template);
        }
        return spec;
    }

    @Override
    public CodeStudioMeta.CodeStudioLaunchSpec getLaunchSpec(AuthCtx authCtx, CodeStudioTemplate template, CodeStudioMeta.CodeStudioLaunchEnv launchEnv) throws IOException, DKUSecurityException {
        BlockBasedCodeStudioTemplateParams params = template.getParamsAs(BlockBasedCodeStudioTemplateParams.class);
        CodeStudioMeta.CodeStudioLaunchSpec ret = new CodeStudioMeta.CodeStudioLaunchSpec();
        for (CodeStudioBlock b : params.blocks) {
            ret = CodeStudioBlockRegistry.getMeta(b).apply(authCtx, b, ret, launchEnv);
        }
        if (launchEnv instanceof CodeStudioMeta.CodeStudioWebAppLaunchEnv) {
            Integer exposedPort = ((CodeStudioMeta.CodeStudioWebAppLaunchEnv)launchEnv).exposedPortToDisplay;
            ret.exposedPorts = exposedPort != null ? ret.exposedPorts.stream().filter(ep -> ep.port == exposedPort).collect(Collectors.toList()) : ret.exposedPorts.stream().limit(1L).collect(Collectors.toList());
        }
        if (!launchEnv.publiclyExposed) {
            ret.exposedPorts.stream().forEach(ep -> {
                ep.containerPort = ep.port + 1;
            });
        }
        String prevRole = launchEnv.labels.putIfAbsent("dataiku.com/dku-role", "main");
        ret.yaml = KubernetesExecUtils.getDeploymentConfForCodeStudio(authCtx, ret, launchEnv);
        if (prevRole == null) {
            launchEnv.labels.remove("dataiku.com/dku-role");
        }
        for (CodeStudioBlock b : params.blocks) {
            ret = CodeStudioBlockRegistry.getMeta(b).postProcess(authCtx, b, ret, launchEnv);
        }
        return ret;
    }

    @Override
    public CodeStudioMeta.TemplateExportSpec exportTemplate(AuthCtx authCtx, CodeStudioTemplate template) throws Exception {
        BlockBasedCodeStudioTemplateParams params = template.getParamsAs(BlockBasedCodeStudioTemplateParams.class);
        CodeStudioMeta.TemplateExportSpec ret = new CodeStudioMeta.TemplateExportSpec();
        for (CodeStudioBlock b : params.blocks) {
            ret = CodeStudioBlockRegistry.getMeta(b).exportBlock(authCtx, b, ret);
        }
        return ret;
    }

    @Override
    public CodeStudioTemplate importTemplate(AuthCtx authCtx, CodeStudioTemplate srcTemplate, CodeStudioMeta.TemplateExportSpec exportSpec, CodeStudioMeta.TemplateImportSpec importSpec) throws Exception {
        BlockBasedCodeStudioTemplateParams params = srcTemplate.getParamsAs(BlockBasedCodeStudioTemplateParams.class);
        params.blocks = params.blocks.stream().map(b -> CodeStudioBlockRegistry.getMeta(b).importBlock(authCtx, (CodeStudioBlock)b, exportSpec, importSpec)).collect(Collectors.toList());
        return srcTemplate;
    }
}

