/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionUtils;
import com.dataiku.dip.connections.ConnectionWithAWSAuthCredentials;
import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.connections.ConnectionWithEncryptedFields;
import com.dataiku.dip.connections.ConnectionWithPerUserOAuth2Credentials;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.VectorStoreConnection;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.datasets.elasticsearch.ElasticSearchDialect;
import com.dataiku.dip.datasets.elasticsearch.ElasticSearchHttpClient;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledge;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.model.ICredentialsService;
import com.dataiku.dip.security.model.OAuth2Client;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.connections.ConnectionCodes;
import com.dataiku.dip.server.services.ConnectionsTestService;
import com.dataiku.dip.util.ProxyUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.Pair;
import com.dataiku.dip.utils.PerfUtils;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.ParseException;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.dataiku.dss.shadelib.org.apache.http.Header;
import com.dataiku.dss.shadelib.org.apache.http.HttpEntity;
import com.dataiku.dss.shadelib.org.apache.http.HttpEntityEnclosingRequest;
import com.dataiku.dss.shadelib.org.apache.http.HttpHost;
import com.dataiku.dss.shadelib.org.apache.http.auth.AuthScope;
import com.dataiku.dss.shadelib.org.apache.http.auth.Credentials;
import com.dataiku.dss.shadelib.org.apache.http.auth.UsernamePasswordCredentials;
import com.dataiku.dss.shadelib.org.apache.http.impl.client.DefaultHttpClient;
import com.dataiku.dss.shadelib.org.apache.http.message.BasicHeader;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.auth.credentials.AwsCredentials;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.http.SdkHttpFullRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.http.SdkHttpMethod;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.http.SdkHttpRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.http.auth.aws.signer.AwsV4HttpSigner;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.http.auth.spi.signer.SignRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.http.auth.spi.signer.SignedRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.identity.spi.Identity;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class ElasticSearchConnection
extends DSSConnection
implements VectorStoreConnection,
ConnectionWithEncryptedFields,
ConnectionWithPerUserOAuth2Credentials,
ConnectionWithAWSAuthCredentials {
    public Params params = new Params();
    public static final String connectionType = "ElasticSearch";
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.elasticsearch");

    @Override
    public RetrievableKnowledge.VectorStoreType getVectorStoreType() {
        return RetrievableKnowledge.VectorStoreType.ELASTICSEARCH;
    }

    @Override
    public String getConnectionName() {
        return this.name;
    }

    public ElasticSearchConnection() {
    }

    public ElasticSearchConnection(String name, String host, int port, ElasticSearchDialect dialect) {
        this.name = name;
        this.params.host = host;
        this.params.port = port;
        this.params.dialect = dialect;
    }

    public String getServerAddress() {
        return (this.params.ssl ? "https" : "http") + "://" + this.params.host + ":" + this.params.port + "/";
    }

    public String getTestURL() {
        Object url = this.getServerAddress();
        if (this.isAWSOpenSearchServerless()) {
            url = (String)url + "_cat/indices";
        }
        return url;
    }

    public boolean isAWSOpenSearchServerless() {
        return this.params.authType.isAwsSpecific() && this.params.aws.service == AWSServiceType.OPENSEARCH_SERVERLESS;
    }

    public ElasticSearchHttpClient getHttpClient(AuthCtx authCtx, @Nullable String projectKey) throws DKUSecurityException, IOException {
        DefaultHttpClient client = this.params.ssl && this.params.trustAnySSLCertificate ? ConnectionUtils.newNonValidatingHttpClient() : new DefaultHttpClient();
        client.addRequestInterceptor(PerfUtils.MARK_HTTP_REQUEST_INTERCEPTOR);
        ProxyUtils.applyProxySettings((ProxySettings)this.getProxySettings(), (DefaultHttpClient)client);
        List<Header> headers = this.getCustomHeaders(authCtx, projectKey);
        ElasticSearchHttpClient.CredentialsRefresher credentialsRefresher = null;
        ElasticSearchHttpClient.RequestSigner requestSigner = null;
        switch (this.params.authType) {
            case NONE: {
                break;
            }
            case PASSWORD: {
                try {
                    ICredentialsService.BasicCredential creds = this.getFullyResolvedCredentials_fsLike(new ConnectionWithBasicCredential.CredentialResolutionContext(authCtx, projectKey), ICredentialsService.BasicCredential.class);
                    if (creds == null) break;
                    String username = creds.user;
                    String password = creds.password;
                    HttpHost httpHost = new HttpHost(this.params.host, this.params.port);
                    client.getCredentialsProvider().setCredentials(new AuthScope(httpHost), (Credentials)new UsernamePasswordCredentials(username, password));
                }
                catch (DKUSecurityException | IOException e) {
                    logger.warn((Object)"Couldn't refresh credentials", e);
                }
                break;
            }
            case OAUTH2_APP: {
                credentialsRefresher = () -> new BasicHeader("Authorization", "Bearer " + this.getAccessToken(authCtx, this.getProxySettings()).getAccessToken());
                break;
            }
            case AWS_KEYPAIR: 
            case AWS_ENVIRONMENT: 
            case AWS_STS: 
            case AWS_CUSTOM: {
                requestSigner = this.getAWSRequestSigner(this.getAWSResolvedCredentials(authCtx, projectKey));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown auth type: " + String.valueOf((Object)this.params.authType));
            }
        }
        return new ElasticSearchHttpClient(client, headers, credentialsRefresher, requestSigner);
    }

    private ElasticSearchHttpClient.RequestSigner getAWSRequestSigner(AwsCredentials credentials) {
        if (StringUtils.isBlank((String)this.params.aws.region)) {
            throw new IllegalArgumentException("\"Region\" parameter is not defined for AWS Authentication");
        }
        return request -> {
            HttpEntityEnclosingRequest entityRequest;
            HttpEntity entity;
            URI uri = request.getURI();
            AwsV4HttpSigner signer = AwsV4HttpSigner.create();
            SdkHttpFullRequest.Builder fullRequestBuilder = SdkHttpFullRequest.builder().uri(uri).method(SdkHttpMethod.fromValue((String)request.getMethod()));
            for (Header header : request.getAllHeaders()) {
                fullRequestBuilder.appendHeader(header.getName(), header.getValue());
            }
            String body = null;
            if (request instanceof HttpEntityEnclosingRequest && (entity = (entityRequest = (HttpEntityEnclosingRequest)request).getEntity()) != null) {
                body = new String(entity.getContent().readAllBytes(), StandardCharsets.UTF_8);
            }
            String finalBody = body;
            SignedRequest req = signer.sign(r -> ((SignRequest.Builder)((SignRequest.Builder)((SignRequest.Builder)((SignRequest.Builder)r.identity((Identity)credentials)).request((SdkHttpRequest)fullRequestBuilder.build())).payload((Object)(finalBody != null ? () -> IOUtils.toInputStream((String)finalBody, (Charset)StandardCharsets.UTF_8) : null))).putProperty(AwsV4HttpSigner.SERVICE_SIGNING_NAME, (Object)this.params.aws.service.name)).putProperty(AwsV4HttpSigner.REGION_NAME, (Object)this.params.aws.region));
            request.setHeaders((Header[])req.request().headers().entrySet().stream().map(e -> new BasicHeader((String)e.getKey(), String.join((CharSequence)",", (Iterable)e.getValue()))).toArray(BasicHeader[]::new));
        };
    }

    private List<Header> getCustomHeaders(AuthCtx authCtx, String projectKey) {
        ElasticSearchConnectionHeaderProvider provider;
        String className = DKUApp.getProperty((String)"dku.connections.elasticsearch.headerProvider", (String)"");
        if (StringUtils.isBlank((String)className)) {
            return new ArrayList<Header>();
        }
        try {
            Class<?> clazz = Class.forName(className);
            provider = (ElasticSearchConnectionHeaderProvider)clazz.newInstance();
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to resolve ElasticSearch custom header provider", t);
        }
        VariablesService variablesService = (VariablesService)SpringUtils.getBean(VariablesService.class);
        VariablesContext vc = StringUtils.isBlank((String)projectKey) ? variablesService.getForConnection(this, authCtx) : variablesService.getForConnectionAndProject(this, authCtx, projectKey);
        ArrayList<Header> headers = new ArrayList<Header>();
        for (Pair<String, String> header : provider.getHeaders(this, authCtx, projectKey)) {
            String value = vc.expand((String)header.second);
            headers.add((Header)new BasicHeader((String)header.first, value));
        }
        return headers;
    }

    @Override
    public String getType() {
        return connectionType;
    }

    @Override
    public void expandParametersInPlaceAtDAOLevelUsingGlobalContextOnly(VariablesContext vc) {
        this.params.host = vc.expand(this.params.host);
    }

    @Override
    public void encryptFields(PasswordEncryptionService cryptoService, GeneralSettingsDAO.SecuritySettings securitySettings) {
        if (securitySettings.secureSecretKeys) {
            this.params.password = cryptoService.encryptIfNotEncryptedOrEmpty(this.params.password);
            this.params.oauth.clientSecret = cryptoService.encryptIfNotEncryptedOrEmpty(this.params.oauth.clientSecret);
        }
        AbstractSQLConnection.CustomDatabaseProperty.encryptList(this.params.aws != null ? this.params.aws.customAWSCredentialsProviderParams : null, cryptoService);
    }

    @Override
    public void decryptFields(PasswordEncryptionService cryptoService) {
        this.params.password = cryptoService.decryptIfEncrypted(this.params.password);
        this.params.oauth.clientSecret = cryptoService.decryptIfEncrypted(this.params.oauth.clientSecret);
        AbstractSQLConnection.CustomDatabaseProperty.decryptList(this.params.aws != null ? this.params.aws.customAWSCredentialsProviderParams : null, cryptoService);
    }

    @Override
    public List<AbstractSQLConnection.CustomDatabaseProperty> getDkuProperties() {
        return this.params.dkuProperties;
    }

    @Override
    protected <T> T getFullyResolvedCredentials_internal(ConnectionWithBasicCredential.CredentialResolutionContext ctx, Class<T> clazz) throws DKUSecurityException, IOException, SQLException {
        if (this.params.authType == AuthType.PASSWORD) {
            assert (clazz.isAssignableFrom(ICredentialsService.BasicCredential.class));
            if (StringUtils.isNotBlank((String)this.params.username)) {
                ICredentialsService.BasicCredential creds = new ICredentialsService.BasicCredential(this.params.username, this.params.password);
                return clazz.cast(creds);
            }
            return null;
        }
        if (this.params.authType.isAwsSpecific()) {
            assert (clazz.isAssignableFrom(ConnectionWithAWSAuthCredentials.SerializableAWSCredential.class));
            ConnectionWithAWSAuthCredentials.SerializableAWSCredential creds = this.getResolvedCredential(ctx.authCtx);
            return clazz.cast(creds);
        }
        return null;
    }

    @Override
    public boolean actuallyHasPerUserOAuth2Credential() {
        return this.credentialsMode == DSSConnection.CredentialsMode.PER_USER && this.params.authType == AuthType.OAUTH2_APP;
    }

    @Override
    public boolean hasRefreshTokenRotation() {
        return this.params.oauth.refreshTokenRotation;
    }

    @Override
    public OAuth2Client buildOAuth2Client(ProxySettings proxySettings, AuthCtx authCtx) throws DKUSecurityException {
        VariablesService variablesService = (VariablesService)SpringUtils.getBean(VariablesService.class);
        VariablesContext vc = variablesService.getForConnection(this, authCtx);
        String scope = vc.expand(this.params.oauth.scope);
        String clientId = vc.expand(this.params.oauth.clientId);
        String clientSecret = vc.expand(this.params.oauth.clientSecret);
        String authorizationEndpoint = vc.expand(this.params.oauth.authorizationEndpoint);
        String tokenEndpoint = vc.expand(this.params.oauth.tokenEndpoint);
        logger.info((Object)("Using OAuth2 authorize endpoint: " + authorizationEndpoint));
        logger.info((Object)("Using OAuth2 token endpoint: " + tokenEndpoint));
        boolean useCache = this.getDkuPropertiesAsParams().getBoolParam("dku.connection.oauth.enableCache", true);
        return new OAuth2Client.Builder().authorizationEndpoint(authorizationEndpoint).tokenEndpoint(tokenEndpoint).clientId(clientId).clientSecret(clientSecret).scope(scope).usePkce(true).proxy(proxySettings).useAccessTokenCache(useCache).build();
    }

    @Override
    public ICredentialsService.OAuth2Credential getResolvedOAuth2Credential(AuthCtx authCtx) {
        return new ICredentialsService.OAuth2Credential(this.getAccessToken(authCtx, this.getProxySettings()).getAccessToken());
    }

    public OAuth2Client.AccessTokenResult getAccessToken(AuthCtx authCtx, ProxySettings proxySettings) {
        PasswordEncryptionService cryptoService = (PasswordEncryptionService)SpringUtils.getBean(PasswordEncryptionService.class);
        boolean useCache = this.getDkuPropertiesAsParams().getBoolParam("dku.connection.oauth.enableCache", true);
        this.decryptFields(cryptoService);
        try {
            OAuth2Client oAuth2Client = this.buildOAuth2Client(proxySettings, authCtx);
            if (this.credentialsMode == DSSConnection.CredentialsMode.PER_USER) {
                logger.infoV("Exchanging user '%s' refresh token for an access token", new Object[]{authCtx.getIdentifier()});
                return this.getAccessTokenFromRefreshTokenAndUpdateIfNeeded(authCtx, oAuth2Client, false);
            }
            logger.info((Object)"Get an access token using client credential flow");
            return oAuth2Client.acquireAccessTokenResultWithClientCredentialsGrant(useCache);
        }
        catch (DKUSecurityException e) {
            throw new CodedRuntimeException(e.getCode(), "Failed to get OAuth2 access token", (Throwable)e);
        }
        catch (ParseException | IOException | URISyntaxException e) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)ConnectionCodes.ERR_CONNECTION_INVALID_CONFIG, "Failed to get OAuth2 access token", e);
        }
    }

    public com.dataiku.dip.utils.Params getDkuPropertiesAsParams() {
        return AbstractSQLConnection.CustomDatabaseProperty.toParams(this.getDkuProperties());
    }

    private AwsCredentials getAWSResolvedCredentials(AuthCtx authCtx, String projectKey) throws IOException, DKUSecurityException {
        this.params.aws.credentialsMode = this.params.authType.awsCredentialMode;
        ConnectionWithAWSAuthCredentials.SerializableAWSCredential creds = this.getFullyResolvedCredentials_fsLike(new ConnectionWithBasicCredential.CredentialResolutionContext(authCtx, projectKey), ConnectionWithAWSAuthCredentials.SerializableAWSCredential.class);
        if (creds == null) {
            throw new IOException("Failed to resolve credentials");
        }
        return creds.toAWSCredentials();
    }

    @Override
    @Nonnull
    public ConnectionWithAWSAuthCredentials.IAWSAuthParams getIAWSAuthNonResolvedParams() {
        return this.params.aws;
    }

    @Override
    public ProxySettings getProxySettingsFromConnection() {
        return this.getProxySettings();
    }

    @Override
    public DSSConnection.CredentialsMode getCredentialsMode() {
        assert (this.params.authType.isAwsSpecific());
        return DSSConnection.CredentialsMode.GLOBAL;
    }

    @Override
    public boolean actuallyHasAWSAuthCredentials() {
        return this.params.authType.isAwsSpecific();
    }

    @Override
    public ConnectionsTestService.ConnectionTestResult testConnection(AuthCtx authCtx, ConnectionsTestService connectionsTestService) throws Exception {
        return connectionsTestService.testElasticSearch(authCtx, this);
    }

    public static class Params
    extends DSSConnection.DkuConnectionParams {
        public String host;
        public String username;
        public String password;
        public int port = 9200;
        public boolean ssl = false;
        public boolean trustAnySSLCertificate = false;
        public ElasticSearchDialect dialect = ElasticSearchDialect.ES_LE_2;
        public List<AbstractSQLConnection.CustomDatabaseProperty> dkuProperties = new ArrayList<AbstractSQLConnection.CustomDatabaseProperty>();
        public ElasticSearchManagedDatasetNamingRule namingRule = new ElasticSearchManagedDatasetNamingRule();
        public AuthType authType = AuthType.NONE;
        public OAuth2Params oauth = new OAuth2Params();
        public AWSParams aws = new AWSParams();
        public static final long DEFAULT_REFRESH_WAIT_MAX_DELAY_MS = 90000L;
        public static final long DEFAULT_REFRESH_WAIT_DELAY_MS = 20000L;
        public static final long DEFAULT_CONCURRENT_DELETE_DELAY_MS = 500L;
        public static final long DEFAULT_MAX_RETRIES_ON_DELETE_INDEX = 5L;
    }

    public static enum AuthType {
        NONE(null),
        PASSWORD(null),
        OAUTH2_APP(null),
        AWS_KEYPAIR(ConnectionWithAWSAuthCredentials.AWSCredentialMode.KEYPAIR),
        AWS_ENVIRONMENT(ConnectionWithAWSAuthCredentials.AWSCredentialMode.ENVIRONMENT),
        AWS_STS(ConnectionWithAWSAuthCredentials.AWSCredentialMode.STS_ASSUME_ROLE),
        AWS_CUSTOM(ConnectionWithAWSAuthCredentials.AWSCredentialMode.CUSTOM_PROVIDER);

        public final ConnectionWithAWSAuthCredentials.AWSCredentialMode awsCredentialMode;

        private AuthType(ConnectionWithAWSAuthCredentials.AWSCredentialMode awsCredentialMode) {
            this.awsCredentialMode = awsCredentialMode;
        }

        public boolean isAwsSpecific() {
            return this.awsCredentialMode != null;
        }
    }

    public static class AWSParams
    extends ConnectionWithAWSAuthCredentials.AWSAuthParams {
        public AWSServiceType service = AWSServiceType.OPENSEARCH_SERVERLESS;
        public String region;
    }

    public static enum AWSServiceType {
        OPENSEARCH_SERVERLESS("aoss"),
        OPENSEARCH_HOSTED("es");

        public final String name;

        private AWSServiceType(String name) {
            this.name = name;
        }
    }

    public static interface ElasticSearchConnectionHeaderProvider {
        public List<Pair<String, String>> getHeaders(ElasticSearchConnection var1, AuthCtx var2, @Nullable String var3);
    }

    public static class OAuth2Params {
        public String clientId;
        public String clientSecret;
        public String authorizationEndpoint;
        public String tokenEndpoint;
        public String scope;
        public boolean refreshTokenRotation;
    }

    public static class ElasticSearchManagedDatasetNamingRule {
        public String indexNameDatasetNamePrefix;
        public String indexNameDatasetNameSuffix;
    }
}

