/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.connections.CredentialsRemoteFetchConfigurationProvider;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.GoogleCredentialCache;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dataflow.cde.CDEProcessUtils;
import com.dataiku.dip.logging.MainLoggingConfigurator;
import com.dataiku.dip.rpc.TicketBasedIntercomAPIClient;
import com.dataiku.dip.server.connections.ConnectionCodes;
import com.dataiku.dss.shadelib.com.google.api.client.auth.oauth2.TokenResponse;
import com.dataiku.dss.shadelib.com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.dataiku.dss.shadelib.com.google.api.client.googleapis.util.Utils;
import com.dataiku.dss.shadelib.com.google.api.client.http.HttpTransport;
import com.dataiku.dss.shadelib.com.google.api.client.json.JsonFactory;
import com.dataiku.dss.shadelib.com.google.auth.http.HttpTransportFactory;
import com.dataiku.dss.shadelib.com.google.auth.oauth2.AccessToken;
import com.dataiku.dss.shadelib.com.google.auth.oauth2.GoogleCredentials;
import com.dataiku.dss.shadelib.com.google.auth.oauth2.ServiceAccountCredentials;
import com.dataiku.dss.shadelib.com.google.auth.oauth2.UserCredentials;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.google.common.base.Charsets;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class GoogleCredentialsBuilder {
    private static final Pattern JSON_PRIVATE_KEY_FILE_PATTERN = Pattern.compile(".*\\.json", 2);
    private static final Pattern P12_PRIVATE_KEY_FILE_PATTERN = Pattern.compile(".*\\.p12", 2);
    private static final String P12FILE_PASSWORD = "notasecret";
    private static final String P12FILE_PRIVATEKEY_ALIAS = "privatekey";
    private static final String PKCS_12 = "pkcs12";
    private static Map<String, PrivateKeyLastModified> privateKeyLastModifieds = new HashMap<String, PrivateKeyLastModified>();

    public static long getLastModified(String keyPath, MainLoggingConfigurator.ProcessType rmiTo, DSSConnection conn) throws IOException {
        PrivateKeyLastModified current = privateKeyLastModifieds.get(keyPath);
        if (current != null && System.currentTimeMillis() - current.timestamp < 300000L) {
            return current.lastModified;
        }
        current = new PrivateKeyLastModified();
        CredentialsRemoteFetchConfigurationProvider.CredentialsRemoteFetchInfo fetchInfo = new CredentialsRemoteFetchConfigurationProvider.CredentialsRemoteFetchInfo(rmiTo);
        current.lastModified = CredentialsRemoteFetchConfigurationProvider.getFromRemote(fetchInfo, "/connections/get-private-key-last-modified", Long.class, "name", conn.name);
        current.timestamp = System.currentTimeMillis();
        privateKeyLastModifieds.put(keyPath, current);
        return current.lastModified;
    }

    private static GoogleCredentialCache.RawTokenResponse getRefreshAccessTokenFromJEK() throws IOException {
        assert (ApplicationConfigurator.getProcessType() == MainLoggingConfigurator.ProcessType.CDE);
        String executionId = System.getenv("DKU_EXECUTION_ID");
        try (TicketBasedIntercomAPIClient apiClient = CDEProcessUtils.newIntercomAPIClient();){
            GoogleCredentialCache.RawTokenResponse rawTokenResponse = (GoogleCredentialCache.RawTokenResponse)apiClient.postFormToJSON("/tintercom/connections/refresh-google-credential-access-token", GoogleCredentialCache.RawTokenResponse.class, new Object[]{"executionId", executionId});
            return rawTokenResponse;
        }
    }

    public GoogleCredentials buildNewGoogleCredentials(HttpTransport httpTransport, String secretKey, String serviceAccountId, boolean useADC) {
        NewGoogleCredentialsBuilder googleCredentialsBuilder = new NewGoogleCredentialsBuilder(httpTransport);
        return this.buildGoogleCredentials(googleCredentialsBuilder, secretKey, serviceAccountId, useADC);
    }

    public GoogleCredential buildOldGoogleCredential(HttpTransport httpTransport, String secretKey, String serviceAccountId, boolean useADC) {
        OldGoogleCredentialsBuilder googleCredentialsBuilder = new OldGoogleCredentialsBuilder(httpTransport);
        return this.buildGoogleCredentials(googleCredentialsBuilder, secretKey, serviceAccountId, useADC);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T buildGoogleCredentials(AbstractGoogleCredentialsBuilder<T> credentialsBuilder, String secretKey, String serviceAccountId, boolean useADC) {
        String trimmedSecretKey;
        String string = trimmedSecretKey = secretKey != null ? secretKey.trim() : "";
        if (StringUtils.isBlank((String)trimmedSecretKey) && !useADC) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)ConnectionCodes.ERR_CONNECTION_INVALID_CONFIG, "Secret key should not be left blank");
        }
        if (useADC) {
            try {
                if (ApplicationConfigurator.getProcessType() != MainLoggingConfigurator.ProcessType.CDE) return credentialsBuilder.buildFromLocalEnvironment();
                SerializableGoogleCredentials credentials = credentialsBuilder.getSerializableGoogleCredentialsFromJEK();
                if (credentials.data != null) return credentialsBuilder.buildFromJson(credentials.data);
                return credentialsBuilder.buildFromRemoteEnvironment(() -> GoogleCredentialsBuilder.getRefreshAccessTokenFromJEK());
            }
            catch (IOException e) {
                throw new CodedRuntimeException((InfoMessage.MessageCode)ConnectionCodes.ERR_CONNECTION_INVALID_CONFIG, "Unable to extract private key from supplied JSON string.", (Throwable)e);
            }
        }
        if (GoogleCredentialsBuilder.isJson(trimmedSecretKey)) {
            try {
                return credentialsBuilder.buildFromJson(new ByteArrayInputStream(trimmedSecretKey.getBytes(Charsets.UTF_8)));
            }
            catch (IOException e) {
                throw new CodedRuntimeException((InfoMessage.MessageCode)ConnectionCodes.ERR_CONNECTION_INVALID_CONFIG, "Unable to extract private key from supplied JSON string.", (Throwable)e);
            }
        }
        if (JSON_PRIVATE_KEY_FILE_PATTERN.matcher(trimmedSecretKey).matches()) {
            try (InputStream stream = credentialsBuilder.getInputStream(trimmedSecretKey);){
                T t = credentialsBuilder.buildFromJson(stream);
                return t;
            }
            catch (IOException e) {
                throw new CodedRuntimeException((InfoMessage.MessageCode)ConnectionCodes.ERR_CONNECTION_INVALID_CONFIG, "Unable to extract private key from supplied JSON file.", (Throwable)e);
            }
        }
        if (!P12_PRIVATE_KEY_FILE_PATTERN.matcher(trimmedSecretKey).matches()) throw new CodedRuntimeException((InfoMessage.MessageCode)ConnectionCodes.ERR_CONNECTION_INVALID_CONFIG, "Invalid secret key file path. Only .json files are accepted.");
        try (InputStream stream = credentialsBuilder.getInputStream(trimmedSecretKey);){
            T t = credentialsBuilder.buildFromP12(stream, serviceAccountId);
            return t;
        }
        catch (IOException | GeneralSecurityException e) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)ConnectionCodes.ERR_CONNECTION_INVALID_CONFIG, "Unable to extract private key from supplied P12 file.", (Throwable)e);
        }
    }

    public static SerializableGoogleCredentials getSerializableCredentialFromEnvironment(String credentialTypeStr) throws IOException {
        SerializableGoogleCredentials.CredentialType credentialType = SerializableGoogleCredentials.CredentialType.valueOf(credentialTypeStr);
        String filePath = System.getenv("GOOGLE_APPLICATION_CREDENTIALS");
        if (StringUtils.isBlank((String)filePath) || !new File(filePath).exists()) {
            filePath = new File(new File(System.getProperty("user.home", ""), ".config"), "gcloud/application_default_credentials.json").getAbsolutePath();
        }
        if (new File(filePath).exists()) {
            try (FileInputStream is = new FileInputStream(filePath);){
                SerializableGoogleCredentials serializableGoogleCredentials = new SerializableGoogleCredentials(IOUtils.toByteArray((InputStream)is), credentialType);
                return serializableGoogleCredentials;
            }
        }
        return new SerializableGoogleCredentials(credentialType);
    }

    public static SerializableGoogleCredentials getSerializableCredentialFromPath(String filePath, String credentialTypeStr) throws IOException {
        SerializableGoogleCredentials.CredentialType credentialType = SerializableGoogleCredentials.CredentialType.valueOf(credentialTypeStr);
        try (FileInputStream is = new FileInputStream(filePath);){
            SerializableGoogleCredentials serializableGoogleCredentials = new SerializableGoogleCredentials(IOUtils.toByteArray((InputStream)is), credentialType);
            return serializableGoogleCredentials;
        }
    }

    public static boolean isJson(String str) {
        String trimmed = str.trim();
        return trimmed.startsWith("{") && trimmed.endsWith("}");
    }

    public static class PrivateKeyLastModified {
        public long timestamp;
        public long lastModified;
    }

    public static class NewGoogleCredentialsBuilder
    extends AbstractGoogleCredentialsBuilder<GoogleCredentials> {
        private final HttpTransportFactory httpTransportFactory = () -> httpTransport;

        public NewGoogleCredentialsBuilder(HttpTransport httpTransport) {
            super(SerializableGoogleCredentials.CredentialType.NEW);
        }

        @Override
        public GoogleCredentials buildFromLocalEnvironment() throws IOException {
            return GoogleCredentials.getApplicationDefault((HttpTransportFactory)this.httpTransportFactory);
        }

        @Override
        public GoogleCredentials buildFromRemoteEnvironment(final RawTokenResponseFetcher tokenFetch) throws IOException {
            return new GoogleCredentials(){
                private static final long serialVersionUID = 1L;

                public AccessToken refreshAccessToken() throws IOException {
                    GoogleCredentialCache.RawTokenResponse rawTokenResponse = tokenFetch.get();
                    return rawTokenResponse.toAccessToken();
                }
            };
        }

        @Override
        public GoogleCredentials buildFromJson(InputStream stream) throws IOException {
            return GoogleCredentials.fromStream((InputStream)stream, (HttpTransportFactory)this.httpTransportFactory);
        }

        @Override
        public GoogleCredentials buildFromP12(InputStream stream, String serviceAccountId) throws KeyStoreException, UnrecoverableKeyException, NoSuchAlgorithmException, CertificateException, IOException {
            KeyStore p12 = KeyStore.getInstance(GoogleCredentialsBuilder.PKCS_12);
            p12.load(stream, GoogleCredentialsBuilder.P12FILE_PASSWORD.toCharArray());
            Key key = p12.getKey(GoogleCredentialsBuilder.P12FILE_PRIVATEKEY_ALIAS, GoogleCredentialsBuilder.P12FILE_PASSWORD.toCharArray());
            Certificate cert = p12.getCertificate(GoogleCredentialsBuilder.P12FILE_PRIVATEKEY_ALIAS);
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            md.update(cert.getEncoded());
            String keyId = Base64.getEncoder().encodeToString(md.digest());
            return ServiceAccountCredentials.fromPkcs8(null, (String)serviceAccountId, (String)this.encodePrivateKey(key), (String)keyId, Collections.emptyList(), (HttpTransportFactory)this.httpTransportFactory, null);
        }

        private String encodePrivateKey(Key key) {
            Base64.Encoder encoder = Base64.getMimeEncoder(64, "\n".getBytes());
            String encodedCertText = new String(encoder.encode(key.getEncoded()));
            return "-----BEGIN PRIVATE KEY-----\n" + encodedCertText + "\n-----END PRIVATE KEY-----";
        }

        @Override
        GoogleCredentials buildFromOauth2(String appId, String appSecret, String refreshToken, String accessToken, String tokenEndpoint) throws IOException {
            URI uri;
            try {
                uri = new URI(tokenEndpoint);
            }
            catch (URISyntaxException e) {
                throw new IOException("Bad token endpoint", e);
            }
            return UserCredentials.newBuilder().setHttpTransportFactory(this.httpTransportFactory).setAccessToken(new AccessToken(accessToken, null)).setRefreshToken(refreshToken).setClientId(appId).setClientSecret(appSecret).setTokenServerUri(uri).build();
        }
    }

    public static abstract class AbstractGoogleCredentialsBuilder<T> {
        SerializableGoogleCredentials.CredentialType credentialType;

        public AbstractGoogleCredentialsBuilder(SerializableGoogleCredentials.CredentialType credentialType) {
            this.credentialType = credentialType;
        }

        protected SerializableGoogleCredentials getSerializableGoogleCredentialsFromJEK() throws IOException {
            assert (ApplicationConfigurator.getProcessType() == MainLoggingConfigurator.ProcessType.CDE);
            String executionId = System.getenv("DKU_EXECUTION_ID");
            try (TicketBasedIntercomAPIClient apiClient = CDEProcessUtils.newIntercomAPIClient();){
                SerializableGoogleCredentials serializableGoogleCredentials = (SerializableGoogleCredentials)apiClient.postFormToJSON("/tintercom/connections/get-google-credentials-from-environment", SerializableGoogleCredentials.class, new Object[]{"executionId", executionId, "credentialType", this.credentialType});
                return serializableGoogleCredentials;
            }
        }

        public InputStream getInputStream(String path) throws IOException {
            if (ApplicationConfigurator.getProcessType() == MainLoggingConfigurator.ProcessType.CDE) {
                String executionId = System.getenv("DKU_EXECUTION_ID");
                try (TicketBasedIntercomAPIClient apiClient = CDEProcessUtils.newIntercomAPIClient();){
                    SerializableGoogleCredentials credentials = (SerializableGoogleCredentials)apiClient.postFormToJSON("/tintercom/connections/get-google-credentials-from-file", SerializableGoogleCredentials.class, new Object[]{"executionId", executionId, "path", path, "credentialType", this.credentialType});
                    InputStream inputStream = credentials.toInputStream();
                    return inputStream;
                }
            }
            return Files.newInputStream(Paths.get(path, new String[0]), new OpenOption[0]);
        }

        abstract T buildFromLocalEnvironment() throws IOException;

        abstract T buildFromRemoteEnvironment(RawTokenResponseFetcher var1) throws IOException;

        abstract T buildFromJson(InputStream var1) throws IOException;

        T buildFromJson(String data) throws IOException {
            return this.buildFromJson(new ByteArrayInputStream(data.getBytes(StandardCharsets.UTF_8)));
        }

        abstract T buildFromP12(InputStream var1, String var2) throws GeneralSecurityException, IOException;

        T buildFromP12(String base64Data, String serviceAccountId) throws GeneralSecurityException, IOException {
            return this.buildFromP12(new ByteArrayInputStream(Base64.getDecoder().decode(base64Data)), serviceAccountId);
        }

        abstract T buildFromOauth2(String var1, String var2, String var3, String var4, String var5) throws IOException;
    }

    public static class OldGoogleCredentialsBuilder
    extends AbstractGoogleCredentialsBuilder<GoogleCredential> {
        private final HttpTransport httpTransport;

        public OldGoogleCredentialsBuilder(HttpTransport httpTransport) {
            super(SerializableGoogleCredentials.CredentialType.OLD);
            this.httpTransport = httpTransport;
        }

        @Override
        public GoogleCredential buildFromLocalEnvironment() throws IOException {
            return GoogleCredential.getApplicationDefault((HttpTransport)this.httpTransport, (JsonFactory)Utils.getDefaultJsonFactory());
        }

        @Override
        public GoogleCredential buildFromRemoteEnvironment(final RawTokenResponseFetcher tokenFetch) throws IOException {
            return new GoogleCredential(){

                protected TokenResponse executeRefreshToken() throws IOException {
                    GoogleCredentialCache.RawTokenResponse rawTokenResponse = tokenFetch.get();
                    return rawTokenResponse.toTokenResponse();
                }
            };
        }

        @Override
        public GoogleCredential buildFromJson(InputStream stream) throws IOException {
            GoogleCredential credential = GoogleCredential.fromStream((InputStream)stream).toBuilder().setTransport(this.httpTransport).build();
            if (credential.getServiceAccountId() == null) {
                throw new CodedRuntimeException((InfoMessage.MessageCode)ConnectionCodes.ERR_CONNECTION_INVALID_CONFIG, "Invalid private key. This is not a service account key or the 'client_email' field is missing.");
            }
            return credential;
        }

        @Override
        public GoogleCredential buildFromP12(InputStream stream, String serviceAccountEmail) throws GeneralSecurityException, IOException {
            if (StringUtils.isBlank((String)serviceAccountEmail)) {
                throw new CodedRuntimeException((InfoMessage.MessageCode)ConnectionCodes.ERR_CONNECTION_INVALID_CONFIG, "Service account email should be filled when using a .p12 file as secret key.");
            }
            return new GoogleCredential.Builder().setTransport(this.httpTransport).setJsonFactory(Utils.getDefaultJsonFactory()).setServiceAccountId(serviceAccountEmail).setServiceAccountPrivateKeyFromP12File(stream).setServiceAccountScopes(new ArrayList()).build();
        }

        @Override
        GoogleCredential buildFromOauth2(String appId, String appSecret, String refreshToken, String accessToken, String tokenEndpoint) throws IOException {
            return new GoogleCredential.Builder().setTransport(this.httpTransport).setJsonFactory(Utils.getDefaultJsonFactory()).setClientSecrets(appId, appSecret).setTokenServerEncodedUrl(tokenEndpoint).build().setRefreshToken(refreshToken).setAccessToken(accessToken);
        }
    }

    public static class SerializableGoogleCredentials {
        private final String data;
        private final CredentialType credentialType;

        public SerializableGoogleCredentials(CredentialType credentialType) {
            this.data = null;
            this.credentialType = credentialType;
        }

        public SerializableGoogleCredentials(byte[] data, CredentialType credentialType) {
            this.data = org.apache.commons.codec.binary.Base64.encodeBase64String((byte[])data);
            this.credentialType = credentialType;
        }

        public InputStream toInputStream() {
            return new ByteArrayInputStream(org.apache.commons.codec.binary.Base64.decodeBase64((String)this.data));
        }

        private static enum CredentialType {
            OLD,
            NEW;

        }
    }

    public static interface RawTokenResponseFetcher {
        public GoogleCredentialCache.RawTokenResponse get() throws IOException;
    }
}

