/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dashboards.export;

import com.dataiku.dip.dashboards.DashboardsService;
import com.dataiku.dip.dashboards.export.execution.DashboardEnrichedExport;
import com.dataiku.dip.dashboards.export.execution.DashboardExportPostProcessor;
import com.dataiku.dip.dashboards.export.execution.DashboardExportScriptRunner;
import com.dataiku.dip.dashboards.export.model.DashboardExport;
import com.dataiku.dip.dashboards.model.Dashboard;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.graphicsexport.BaseExportService;
import com.dataiku.dip.graphicsexport.model.ExportFormat;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.notifications.HrefContext;
import com.dataiku.dip.server.services.InternalAPIKeysService;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DashboardsExportService
extends BaseExportService<DashboardExport, ExportFormat, DashboardEnrichedExport> {
    @Autowired
    private DashboardsService dashboardsService;

    @Override
    protected BaseExportService.ExportFutureThread newFutureThread(AuthCtx user, DashboardExport export) throws IOException, DKUSecurityException {
        return new DashboardExportFutureThread(user, (DashboardEnrichedExport)this.checkAndEnrichExport(user, export, Privileges.ProjectLevelPrivilegeType.READ_DASHBOARDS));
    }

    @Override
    protected DashboardEnrichedExport checkAndEnrichExport(DashboardExport export, HrefContext hrefContext, boolean browserSandBoxing) throws IOException {
        Preconditions.checkArgument((!export.dashboards.isEmpty() ? 1 : 0) != 0, (Object)"At least one dashboard target must be to be specified");
        ArrayList<DashboardEnrichedExport.EnrichedDashboardExportTarget> dashboardExportItems = new ArrayList<DashboardEnrichedExport.EnrichedDashboardExportTarget>();
        for (DashboardExport.Target target : export.dashboards) {
            dashboardExportItems.add(this.checkAndEnrichDashboardTarget(export.projectKey, target, hrefContext));
        }
        return new DashboardEnrichedExport(export.exportId, export.projectKey, this.checkAndEnrichExportFormat(export.format, DashboardExport.SCREEN_RANGE_W, DashboardExport.SCREEN_RANGE_H), dashboardExportItems, browserSandBoxing);
    }

    @Override
    protected ExportFormat newExportFormat() {
        return new ExportFormat();
    }

    private DashboardEnrichedExport.EnrichedDashboardExportTarget checkAndEnrichDashboardTarget(String projectKey, DashboardExport.Target dashboardTarget, HrefContext hrefContext) throws IOException {
        Preconditions.checkArgument((!StringUtils.isBlank((String)dashboardTarget.dashboardId) ? 1 : 0) != 0, (Object)"All dashboard targets must contains a valid dashboard Id.");
        Dashboard dashboard = this.dashboardsService.getOrNullUnsafe(projectKey, dashboardTarget.dashboardId);
        if (dashboard == null) {
            throw new NotFoundException("Dashboard " + projectKey + "." + dashboardTarget.dashboardId + " does not exist.");
        }
        Preconditions.checkArgument((dashboardTarget.slideIndex == null || dashboardTarget.slideIndex >= 0 && dashboardTarget.slideIndex < dashboard.pages.size() ? 1 : 0) != 0, (Object)"Specified slide index is out of range.");
        DashboardEnrichedExport.EnrichedDashboardExportTarget target = new DashboardEnrichedExport.EnrichedDashboardExportTarget();
        target.dashboardId = dashboardTarget.dashboardId;
        target.slideIndex = dashboardTarget.slideIndex;
        target.dashboard = dashboard;
        target.url = hrefContext.dashboard(dashboard.projectKey, dashboard.id, true);
        target.filtersBySlide = dashboardTarget.filtersBySlide;
        return target;
    }

    private class DashboardExportFutureThread
    extends BaseExportService.ExportFutureThread {
        public DashboardExportFutureThread(AuthCtx user, DashboardEnrichedExport export) {
            super(DashboardsExportService.this, user, export);
        }

        @Override
        protected int getExportTargetCount() {
            int size = ((DashboardEnrichedExport)this.export).dashboards.size();
            return size > 1 ? size : -1;
        }

        @Override
        protected String getTitle() {
            return "Exporting dashboard";
        }

        @Override
        protected void executeScript(InternalAPIKeysService.APIKey key, File rawExportDirectory, FutureProgressState progressState) throws IOException, InterruptedException {
            new DashboardExportScriptRunner((DashboardEnrichedExport)this.export, rawExportDirectory, key, progressState).execute();
        }

        @Override
        protected File postProcessGeneratedFiles(File rawExportDirectory, File postProcessDirectory, File finalExportDirectory) throws Exception {
            return new DashboardExportPostProcessor((DashboardEnrichedExport)this.export, rawExportDirectory, postProcessDirectory, finalExportDirectory).execute();
        }

        @Override
        protected FuturePayload buildExportFuturePayload() {
            return this.buildExportFuturePayload("dashboard", this.export.format.fileType.toString());
        }
    }
}

