/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dashboards.export;

import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dashboards.DashboardsService;
import com.dataiku.dip.dashboards.export.DashboardsExportService;
import com.dataiku.dip.dashboards.export.model.DashboardExport;
import com.dataiku.dip.dashboards.model.Dashboard;
import com.dataiku.dip.export.ZipUnzipDir;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.graphicsexport.model.ExportFormat;
import com.dataiku.dip.graphicsexport.model.ExportResult;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ImageService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.workspaces.WorkspacesService;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DashboardsScreenshotsService {
    @Autowired
    private WorkspacesService workspacesService;
    @Autowired
    private DashboardsService dashboardsService;
    @Autowired
    private ImageService imageService;
    @Autowired
    private TaggableObjectsService taggableObjectsService;
    @Autowired
    protected GeneralSettingsDAO generalSettingsDAO;
    @Autowired
    protected FutureService futureService;
    @Autowired
    protected DashboardsExportService dashboardsExportService;
    private final Map<String, String> currentScreenshots = new HashMap<String, String>();
    private static final DKULogger logger = DKULogger.getLogger(DashboardsScreenshotsService.class);

    public void buildScreenshotsIfNeeded(AuthCtx user, Set<TaggableObjectsService.TaggableObjectRef> objectRefs) throws Exception {
        boolean graphicsExportsEnabled = this.generalSettingsDAO.read().graphicsExportsEnabled;
        for (TaggableObjectsService.TaggableObjectRef objectRef : objectRefs) {
            this.buildScreenshotIfNeeded(user, objectRef, graphicsExportsEnabled, true, this.screenshotNeedsUpdate(objectRef));
        }
    }

    public void buildScreenshotIfNeeded(AuthCtx user, TaggableObjectsService.TaggableObjectRef objectRef) throws Exception {
        this.buildScreenshotIfNeeded(user, objectRef, this.generalSettingsDAO.read().graphicsExportsEnabled, this.workspacesService.hasWorkspacesContainingObject(objectRef.projectKey, ITaggingService.TaggableType.DASHBOARD, objectRef.id), true);
    }

    private void buildScreenshotIfNeeded(AuthCtx user, TaggableObjectsService.TaggableObjectRef objectRef, boolean graphicsExportsEnabled, boolean isInWorkspace, boolean needUpdate) throws Exception {
        if (objectRef.type == ITaggingService.TaggableType.DASHBOARD && graphicsExportsEnabled && isInWorkspace && needUpdate) {
            this.futureService.runFuture(new DashboardScreenshotFutureThread(user, objectRef), 0L, new TypeToken<FutureResponse<Void>>(){});
        }
    }

    private boolean screenshotNeedsUpdate(TaggableObjectsService.TaggableObjectRef objectRef) throws IOException {
        Dashboard dashboard = this.dashboardsService.getMandatory(objectRef.projectKey, objectRef.id);
        return dashboard.versionTag == null || dashboard.versionTag.getLastModifiedOn() > this.imageService.getCapturedObjectThumbnailLastModified(objectRef.projectKey, objectRef.type.name(), objectRef.id);
    }

    private String createScreenshotKey(TaggableObjectsService.TaggableObjectRef objectRef) {
        return objectRef.projectKey + "_" + objectRef.id;
    }

    private class DashboardScreenshotFutureThread
    extends SimpleFutureThread<Void> {
        private final TaggableObjectsService.TaggableObjectRef dashboardRef;

        public DashboardScreenshotFutureThread(AuthCtx user, TaggableObjectsService.TaggableObjectRef dashboardRef) {
            super(user);
            this.dashboardRef = dashboardRef;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Void compute() throws Exception {
            block24: {
                String currentExportJobId;
                String currentDashboardKey = DashboardsScreenshotsService.this.createScreenshotKey(this.dashboardRef);
                Map<String, String> map = DashboardsScreenshotsService.this.currentScreenshots;
                synchronized (map) {
                    currentExportJobId = DashboardsScreenshotsService.this.currentScreenshots.get(currentDashboardKey);
                }
                if (currentExportJobId != null) {
                    DashboardsScreenshotsService.this.futureService.abort(currentExportJobId);
                    logger.infoV("Abort existing build of screenshot for: %s", new Object[]{this.dashboardRef.id});
                }
                try {
                    ExportFormat exportFormat = new ExportFormat();
                    exportFormat.paperSize = ExportFormat.PaperSize.CUSTOM;
                    exportFormat.fileType = ExportFormat.FileType.PNG;
                    exportFormat.height = 1080;
                    exportFormat.width = 1920;
                    DashboardExport.Target target = new DashboardExport.Target(this.dashboardRef.id, 0);
                    DashboardExport export = new DashboardExport(this.dashboardRef.projectKey, exportFormat, target);
                    FutureResponse exportResponse = DashboardsScreenshotsService.this.dashboardsExportService.export(this.owner, export);
                    Map<String, String> map2 = DashboardsScreenshotsService.this.currentScreenshots;
                    synchronized (map2) {
                        DashboardsScreenshotsService.this.currentScreenshots.put(currentDashboardKey, exportResponse.jobId);
                    }
                    exportResponse = DashboardsScreenshotsService.this.futureService.waitForFinalResponse(exportResponse);
                    if (exportResponse.aborted || !exportResponse.hasResult) break block24;
                    File exportFile = ((ExportResult)exportResponse.result).exportFile;
                    if (exportFile.getName().endsWith(".zip")) {
                        try (AutoDelete tempFolder = DSSTempUtils.getTempFolder((String)(this.dashboardRef.projectKey + "_screenshots_" + this.dashboardRef.id));){
                            ZipUnzipDir.extractFolder(exportFile, (File)tempFolder);
                            String[] part1found = tempFolder.list((dir, name) -> name.endsWith("_Part-1.png"));
                            if (part1found != null && part1found.length > 0) {
                                DashboardsScreenshotsService.this.imageService.setCapturedThumbnail_NT(this.dashboardRef.projectKey, "DASHBOARD", this.dashboardRef.id, Files.readAllBytes(Paths.get(tempFolder.getPath(), part1found[0])), null, 128);
                                logger.infoV("Thumbnail generated for dashboard: %s", new Object[]{this.dashboardRef.id});
                            }
                            logger.error((Object)"Cannot find screenshot part1, thumbnail will be unavailable/outdated");
                        }
                    } else {
                        DashboardsScreenshotsService.this.imageService.setCapturedThumbnail_NT(this.dashboardRef.projectKey, "DASHBOARD", this.dashboardRef.id, Files.readAllBytes(exportFile.toPath()), null, 128);
                        logger.infoV("Thumbnail generated for dashboard: %s", new Object[]{this.dashboardRef.id});
                    }
                    Map<String, String> map3 = DashboardsScreenshotsService.this.currentScreenshots;
                    synchronized (map3) {
                        DashboardsScreenshotsService.this.currentScreenshots.remove(currentDashboardKey);
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"Error occurred during generation of thumbnail", (Throwable)e);
                    Map<String, String> map4 = DashboardsScreenshotsService.this.currentScreenshots;
                    synchronized (map4) {
                        DashboardsScreenshotsService.this.currentScreenshots.remove(currentDashboardKey);
                    }
                }
            }
            return null;
        }

        public FuturePayload getPayload() {
            FuturePayload fp = new FuturePayload();
            fp.action = "generate_dashboard_screenshot";
            fp.targets.add(new FuturePayload.FuturePayloadTarget(this.dashboardRef.projectKey, this.dashboardRef.id, "", "Dashboard"));
            return fp;
        }
    }
}

