/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.fuzzyjoin.builtinengine.verifier;

import com.dataiku.dip.dataflow.exec.fuzzyjoin.FuzzyJoinRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.fuzzyjoin.builtinengine.verifier.Matcher;
import java.util.HashSet;
import java.util.Set;

public class JaccardMatcher
extends Matcher {
    public JaccardMatcher(double threshold, Integer relativeTo, boolean debugMode) {
        super(threshold, relativeTo, debugMode);
    }

    @Override
    protected boolean isValidInputs(String query, String candidate) {
        return query != null && candidate != null;
    }

    @Override
    protected double computeDistance(String query, String candidate) {
        Set<Character> querySet = this.makeSet(query);
        Set<Character> candidateSet = this.makeSet(candidate);
        return 1.0 - this.jaccardSimilarity(querySet, candidateSet);
    }

    @Override
    protected FuzzyJoinRecipePayloadParams.DistanceType getDistanceType() {
        return FuzzyJoinRecipePayloadParams.DistanceType.JACCARD;
    }

    private Set<Character> makeSet(String s) {
        HashSet<Character> set = new HashSet<Character>();
        for (int i = 0; i < s.length(); ++i) {
            set.add(Character.valueOf(s.charAt(i)));
        }
        return set;
    }

    private double jaccardSimilarity(Set<Character> setA, Set<Character> setB) {
        if (setA.isEmpty() || setB.isEmpty()) {
            return 0.0;
        }
        HashSet<Character> unionSet = new HashSet<Character>(setA);
        unionSet.addAll(setB);
        int intersectionSize = setA.size() + setB.size() - unionSet.size();
        return (double)intersectionSize / (double)unionSet.size();
    }
}

