/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.pivot;

import com.dataiku.dip.cluster.SparkSettings;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.AbstractSparkBasedRecipeRunner;
import com.dataiku.dip.dataflow.exec.SparkExecutionEnginesHelper;
import com.dataiku.dip.dataflow.exec.pivot.AbstractPivotRecipeSQLlikeExecutor;
import com.dataiku.dip.dataflow.exec.pivot.ModalitySlugifier;
import com.dataiku.dip.dataflow.exec.pivot.ModalitySlugifiers;
import com.dataiku.dip.dataflow.exec.pivot.PivotElement;
import com.dataiku.dip.dataflow.exec.pivot.PivotElementsModalitiesSnapshot;
import com.dataiku.dip.dataflow.exec.pivot.PivotRecipeModalityCollectionJobDef;
import com.dataiku.dip.dataflow.exec.pivot.PivotRecipeModalityCollectionJobDefBuilder;
import com.dataiku.dip.dataflow.exec.pivot.PivotRecipeModalityCollectionJobResult;
import com.dataiku.dip.dataflow.exec.pivot.PivotRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.pivot.PivotedModality;
import com.dataiku.dip.dataflow.utils.FlowJobUtils;
import com.dataiku.dip.datasets.DatasetUtils;
import com.dataiku.dip.recipes.code.sparksql.SparkSQLExecutor;
import com.dataiku.dip.recipes.code.sparksql.SparkSQLMultiQueryExecutor;
import com.dataiku.dip.recipes.visualsql.VisualSQLRecipesBaseService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.spark.SparkJob;
import com.dataiku.dip.spark.SparkJobHelper;
import com.dataiku.dip.spark.SparkOverrideConfig;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.SparkSQLDialect;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class PivotRecipeSparkExecutor
extends AbstractPivotRecipeSQLlikeExecutor {
    private static final SparkSQLDialect dialect = new SparkSQLDialect();
    private final SparkSQLExecutor.SparkSQLExecutorParams sparkSQLParams;
    private static Logger logger = Logger.getLogger((String)"dip.recipe.pivot.spark.executor");

    public PivotRecipeSparkExecutor(VisualSQLRecipesBaseService.SQLBasedEngineStatus engine, JobActivity activity, PivotRecipePayloadParams params, SparkSQLExecutor.SparkSQLExecutorParams sparkSQLParams) {
        super(engine, activity, params);
        this.sparkSQLParams = sparkSQLParams;
    }

    @Override
    protected SQLUtils.SQLTable getSQLTable() throws IOException {
        return DatasetUtils.getResolvedTableWithSparkSQLFallback(this.inputDS, dialect, this.params.engineParams);
    }

    @Override
    protected void execute(List<PivotElementsModalitiesSnapshot.PivotElementsModalities> pivotElementsModalities) throws Exception {
        HashMap queries = Maps.newHashMap();
        queries.put(this.outputDS.getFullName(), this.generateSQL(pivotElementsModalities, dialect));
        final SparkSQLMultiQueryExecutor runner = new SparkSQLMultiQueryExecutor(this.activity, this.sparkSQLParams, queries);
        try (AutoCloseable hook = this.startAbortableTask(new Runnable(){

            @Override
            public void run() {
                logger.info((Object)"Aborting pivoting query");
                runner.notifyBeforeAborting();
            }
        });){
            SpringUtils.getInstance().autowire((Object)runner);
            runner.init();
            runner.run();
        }
    }

    @Override
    protected SQLDialect getInputDialect() throws IOException {
        return dialect;
    }

    @Override
    protected SQLDialect getOutputDialect() throws IOException {
        return dialect;
    }

    @Override
    protected AbstractSQLConnection getInputSQLConnection() throws IOException {
        throw new Error("Unreachable (spark != jdbc)");
    }

    @Override
    protected PivotElementsModalitiesSnapshot getModalities(List<PivotElement> pivotElements) throws Exception {
        PivotRecipeModalityCollectionJobDefBuilder defBuilder = new PivotRecipeModalityCollectionJobDefBuilder(this.activity);
        defBuilder = defBuilder.withInput(this.sparkSQLParams.useGlobalMetastore, this.sparkSQLParams.readParams);
        ArrayList pivotModalities = Lists.newArrayList();
        boolean queryNeeded = false;
        for (int i = 0; i < pivotElements.size(); ++i) {
            PivotElement pivotElement = pivotElements.get(i);
            if (pivotElement.valueLimit == PivotElement.PivotValueLimit.EXPLICIT) {
                pivotModalities.add(new PivotElementsModalitiesSnapshot.PivotElementsModalities(pivotElement, this.getExplicitModalities(pivotElement)));
                continue;
            }
            defBuilder = defBuilder.withCollection(i, this.getModalityCollectionQuery(pivotElement), pivotElement);
            pivotModalities.add(new PivotElementsModalitiesSnapshot.PivotElementsModalities(pivotElement, null));
            queryNeeded = true;
        }
        if (queryNeeded) {
            PivotRecipeModalityCollectionJobDef def = defBuilder.build();
            final PivotRecipeSparkModalityCollectionExecutor subRunner = new PivotRecipeSparkModalityCollectionExecutor(this.activity, def, this.sparkSQLParams);
            try (AutoCloseable hook = this.startAbortableTask(new Runnable(){

                @Override
                public void run() {
                    logger.info((Object)"Aborting modality collection query");
                    subRunner.notifyBeforeAborting();
                }
            });){
                SpringUtils.getInstance().autowire((Object)subRunner);
                subRunner.init();
                subRunner.run();
            }
            ModalitySlugifier modalitySlugifier = ModalitySlugifiers.getSlugifier(this.params.modalitySlugification);
            for (PivotRecipeModalityCollectionJobResult.PivotRecipeModalityCollectionResult modalityCollectionResult : subRunner.results.modalityCollectionResults) {
                int pivotIndex = modalityCollectionResult.pivotIndex;
                PivotElementsModalitiesSnapshot.PivotElementsModalities old = (PivotElementsModalitiesSnapshot.PivotElementsModalities)pivotModalities.get(pivotIndex);
                PivotElement pivotElement = old.pivotElement;
                List<Object> modalities = Lists.newArrayList();
                for (List<String> keyValues : modalityCollectionResult.modalities) {
                    PivotedModality modality = PivotedModality.fromModalities(keyValues, pivotElement, modalitySlugifier);
                    modalities.add(modality);
                }
                if (this.params.sortModalities) {
                    modalities = this.sortModalities(pivotElement, (List<PivotedModality>)modalities);
                }
                pivotModalities.set(pivotIndex, new PivotElementsModalitiesSnapshot.PivotElementsModalities(pivotElement, (List<PivotedModality>)modalities));
            }
        }
        PivotElementsModalitiesSnapshot snapshot = new PivotElementsModalitiesSnapshot();
        snapshot.pivotElementsModalities = pivotModalities;
        snapshot.engineType = this.engine.type;
        return snapshot;
    }

    public class PivotRecipeSparkModalityCollectionExecutor
    extends AbstractSparkBasedRecipeRunner {
        private final PivotRecipeModalityCollectionJobDef def;
        private final SparkSQLExecutor.SparkSQLExecutorParams executorParams;
        private PivotRecipeModalityCollectionJobResult results;

        public PivotRecipeSparkModalityCollectionExecutor(JobActivity activity, PivotRecipeModalityCollectionJobDef def, SparkSQLExecutor.SparkSQLExecutorParams executorParams) {
            super(activity);
            this.def = def;
            this.executorParams = executorParams;
        }

        @Override
        public void run() throws Exception {
            final SparkOverrideConfig sparkConfig = this.executorParams.sparkConfig;
            logger.info((Object)("Executing SparkSQL with sparkConfig: " + JSON.json((Object)sparkConfig)));
            this.runSpark("Spark", PivotRecipeSparkExecutor.this.params.engineParams.sparkSQL.executionEngine, new SparkExecutionEnginesHelper.SparkRecipeJobBuilder(){

                @Override
                public <T extends SparkJob> T buildSparkJob(SparkJobHelper<T> helper, File runDir, SparkSettings sparkSettings, List<SimpleKeyValue> effectiveConf) throws Exception {
                    AutoDelete serializedFile = FlowJobUtils.getJobTempFile("pivot-modalities", "pivot-modality-collection-desc", "json");
                    JSON.prettyToFile((Object)PivotRecipeSparkModalityCollectionExecutor.this.def, (File)serializedFile);
                    T job = helper.makeClassJob("DSS (Pivot modality collection): " + PivotRecipeSparkModalityCollectionExecutor.this.activity.id(), false, effectiveConf, "com.dataiku.dip.spark.PivotRecipeModalityCollectionJob", serializedFile.getAbsolutePath());
                    ((SparkJob)job).secretDriverFiles.add(serializedFile.getAbsolutePath());
                    return job;
                }

                @Override
                public SparkOverrideConfig getRecipeOverrideConf() {
                    return sparkConfig;
                }

                @Override
                public Map<String, String> getContextOverrideConf() {
                    return new HashMap<String, String>();
                }
            }, new SparkJobHelper.SparkJobPostProcessor(){

                @Override
                public void postProcess(SparkJobHelper.SparkJobContext context) throws Exception {
                    File resultsFile = new File(context.getLocalRunDir(), "results.json");
                    PivotRecipeSparkModalityCollectionExecutor.this.results = (PivotRecipeModalityCollectionJobResult)JSON.parseFile((File)resultsFile, PivotRecipeModalityCollectionJobResult.class);
                }
            }, null);
        }

        @Override
        public void init() throws Exception {
        }

        @Override
        public void notifyBeforeAborting() {
        }
    }
}

