/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.pivot;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.RecipeEnginesPreferenceConfig;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.QueryGenerationUtils;
import com.dataiku.dip.dataflow.exec.VisualSQLRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.computedcolumn.ComputedColumn;
import com.dataiku.dip.dataflow.exec.filter.FilterDesc;
import com.dataiku.dip.dataflow.exec.filter.FilterDescUtils;
import com.dataiku.dip.dataflow.exec.grouping.GroupingRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.pivot.CustomAggregateDefinition;
import com.dataiku.dip.dataflow.exec.pivot.PivotElement;
import com.dataiku.dip.dataflow.exec.pivot.PivotElementsModalitiesSnapshot;
import com.dataiku.dip.dataflow.exec.pivot.PivotRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.pivot.PivotRecipeSchemaComputer;
import com.dataiku.dip.dataflow.exec.pivot.PivotSQLGenerator;
import com.dataiku.dip.dataflow.exec.pivot.PivotSchemaGenerator;
import com.dataiku.dip.dataflow.exec.pivot.PivotedModality;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.datasets.DatasetUtils;
import com.dataiku.dip.datasets.SchemaUtils;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.queries.ExecutionPlanService;
import com.dataiku.dip.recipes.common.RecipeConfigUtils;
import com.dataiku.dip.recipes.common.RecipeEngineStatus;
import com.dataiku.dip.recipes.common.RecipeStatus;
import com.dataiku.dip.recipes.common.VisualSQLRecipeStatusComputer;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.recipes.visualsql.VisualSQLRecipeStatus;
import com.dataiku.dip.recipes.visualsql.VisualSQLRecipesBaseService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.recipes.PivotRecipeService;
import com.dataiku.dip.sql.DummySQLDialect;
import com.dataiku.dip.sql.PostgreSQLDialect;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.SelectQueryBuilder;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class PivotRecipeStatusComputer
extends VisualSQLRecipeStatusComputer {
    @Autowired
    private PivotRecipeService service;
    private static final Logger logger = Logger.getLogger((String)"dip.recipe.pivot.status.computer");

    public PivotRecipeStatusComputer(SerializedRecipe recipe, String payload) {
        super(recipe, payload);
    }

    @Override
    public PivotRecipeStatus fastStatusIgnorePartitions(AuthCtx authCtx) throws Exception {
        return this.fastStatusIgnorePartitions(authCtx, new StatusInitializer(), true);
    }

    @Override
    public VisualSQLRecipeStatus getStatusForConversion_NT(AuthCtx authCtx) throws Exception {
        PivotRecipeStatus status;
        StatusInitializer init = new StatusInitializer();
        try (Transaction t = this.transactionService.beginRead();){
            status = this.fastStatusIgnorePartitions(authCtx, init, true);
            if (status.isInvalid()) {
                logger.warn((Object)"Recipe status is invalid. Attempting to generate query anyway");
            }
            PivotRecipePayloadParams params = (PivotRecipePayloadParams)JSON.deepCopy((Object)status.params);
            Dataset inputDS = init.inputDS;
            Dataset outputDS = init.outputDS;
            SQLDialect dialect = init.dialect;
            PivotElementsModalitiesSnapshot pivotElementsModalities = PivotRecipeSchemaComputer.retrievePivotElementsModalities(params, init.outputDS.getSchema());
            if (pivotElementsModalities == null) {
                throw new Exception("Cannot generate query if no modalities have been computed");
            }
            List<String> identifiers = params.buildIdentifierList(inputDS.getSchema());
            SQLUtils.SQLTable sqlTable = DatasetUtils.getResolvedTableWithSparkSQLFallback(inputDS, dialect, params.engineParams);
            PivotSQLGenerator sqlGenerator = new PivotSQLGenerator(params, inputDS, sqlTable, outputDS);
            SelectQueryBuilder pivotQuery = sqlGenerator.generateQuery(identifiers, pivotElementsModalities.pivotElementsModalities, dialect, true);
            status.sql = pivotQuery.toSQL(dialect);
        }
        return status;
    }

    @Override
    public RecipeStatus getFullStatus_NT(AuthCtx authCtx, String requestData) throws Exception {
        PivotRecipeStatus status;
        StatusInitializer init = new StatusInitializer();
        try (Transaction t = this.transactionService.beginRead();){
            status = this.fastStatusIgnorePartitions(authCtx, init, false);
        }
        if (status.isInvalid()) {
            status.computedColumnsStageSchema = init.inputDS.getSchema();
            status.pivotStageSchema = new PivotSchemaGenerator(status.params).generateForPivotStage(init.inputDS.getSchema());
            this.fixupStatusOutputInvalid(status);
            return status;
        }
        PivotRecipePayloadParams params = (PivotRecipePayloadParams)JSON.deepCopy((Object)status.params);
        VisualSQLRecipesBaseService.SQLBasedEngineStatus selectedEngine = status.getSelectedSQLBasedEngine();
        Dataset inputDS = init.inputDS;
        Dataset outputDS = init.outputDS;
        SQLDialect dialect = init.dialect;
        status.identifiers = params.buildIdentifierList(inputDS.getSchema());
        status.computedColumnsStageSchema = inputDS.getSchema();
        VisualSQLRecipeStatus.VisualSQLRecipeStatusRequest request = (VisualSQLRecipeStatus.VisualSQLRecipeStatusRequest)JSON.parse((String)requestData, VisualSQLRecipeStatus.VisualSQLRecipeStatusRequest.class);
        if (request != null && !request.exactPlan) {
            this.visualRecipesService.enableSimplifiedExplainPlan(selectedEngine, status.params);
        }
        if (dialect != null && this.needToComputeExecutionPlan(status.getSelectedSQLBasedEngine(), status, request)) {
            this.checkSQL(authCtx, status, params, inputDS, outputDS, dialect);
        }
        status.pivotStageSchema = new PivotSchemaGenerator(params).generateForPivotStage(init.inputDS.getSchema());
        try {
            PivotElementsModalitiesSnapshot pivotElementsModalities = PivotRecipeSchemaComputer.retrievePivotElementsModalities(params, init.outputDS.getSchema());
            if (pivotElementsModalities != null) {
                status.pivotModalities = Lists.newArrayList();
                for (PivotElementsModalitiesSnapshot.PivotElementsModalities modalities : pivotElementsModalities.pivotElementsModalities) {
                    status.pivotModalities.add(modalities.pivotedModalities);
                }
                if (StringUtils.isNotBlank((String)selectedEngine.type)) {
                    status.modalitiesComputedOnDifferentEngine = selectedEngine.type.equals(pivotElementsModalities.engineType);
                }
            }
            PivotElementsModalitiesSnapshot pivotElementsModalitiesStrict = PivotRecipeSchemaComputer.getPivotElementsModalitiesIfUptodate(params, init.outputDS.getSchema());
            if (params.schemaComputation == PivotRecipePayloadParams.SchemaComputation.ONLY_IF_NO_METADATA && pivotElementsModalitiesStrict != null) {
                boolean lowercaseColumns = this.visualRecipesService.mustLowerCaseColumnsNames((VisualSQLRecipePayloadParams)params, selectedEngine);
                status.outputSchema = new PivotSchemaGenerator(params).generate(init.inputDS.getSchema(), status.identifiers, pivotElementsModalitiesStrict.pivotElementsModalities, params.getModalityMaxLength(dialect), lowercaseColumns);
                status.outputSchema.metadata = JSON.toJsonObject((Object)pivotElementsModalitiesStrict);
            }
            if (pivotElementsModalitiesStrict != null && !status.isInvalid() && status.getSelectedSQLBasedEngine().queryBased && dialect != null) {
                SchemaUtils.SchemalessSafeColumnIdentifierSuffixer safeColumnIdentifierSuffixer = new SchemaUtils.SchemalessSafeColumnIdentifierSuffixer(params.getModalityMaxLength(dialect));
                for (PivotElementsModalitiesSnapshot.PivotElementsModalities pivotElementsModality : pivotElementsModalitiesStrict.pivotElementsModalities) {
                    pivotElementsModality.applySafeSuffixing(safeColumnIdentifierSuffixer);
                }
                this.generateSQL(authCtx, status, params, inputDS, outputDS, dialect, status.identifiers, pivotElementsModalitiesStrict, false, request);
            } else if (pivotElementsModalitiesStrict == null) {
                status.sqlWarning = "Could not get modalities from a previous run that match the current settings";
            }
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)"Failed to validate", (Throwable)e);
            status.output.withFatal(RecipeCodes.ERR_RECIPE_INCONSISTENT_RECIPE, ExceptionUtils.getMessageWithCauses((Throwable)e));
        }
        catch (Exception e) {
            logger.error((Object)"Failed to validate", (Throwable)e);
            status.output.withFatal(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "Unknown error:" + ExceptionUtils.getMessageWithCauses((Throwable)e));
        }
        if (init.error != null && !status.isInvalid()) {
            status.output.withFatalV(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "Unknown error: %s", new Object[]{init.error});
        }
        this.fixupStatusOutputInvalid(status);
        return status;
    }

    private void generateSQL(AuthCtx authCtx, PivotRecipeStatus status, PivotRecipePayloadParams params, Dataset inputDS, Dataset outputDS, SQLDialect dialect, List<String> identifiers, PivotElementsModalitiesSnapshot pivotElementsModalitiesStrict, boolean forceOutputColumnNameOverride, VisualSQLRecipeStatus.VisualSQLRecipeStatusRequest request) throws IOException {
        SQLUtils.SQLTable sqlTable = DatasetUtils.getResolvedTableWithSparkSQLFallback(inputDS, dialect, params.engineParams);
        try {
            PivotSQLGenerator sqlGenerator = new PivotSQLGenerator(params, inputDS, sqlTable, outputDS);
            SelectQueryBuilder pivotQuery = sqlGenerator.generateQuery(identifiers, pivotElementsModalitiesStrict.pivotElementsModalities, dialect, forceOutputColumnNameOverride);
            status.sql = pivotQuery.toSQL(dialect);
            if (this.needToComputeExecutionPlan(status.getSelectedSQLBasedEngine(), status, request)) {
                status.executionPlan = this.getExecutionPlan(authCtx, Lists.newArrayList((Object[])new Dataset[]{inputDS}), status.getSelectedSQLBasedEngine(), status.sql, status.params.engineParams);
            }
        }
        catch (ExecutionPlanService.HiveTableNotFound e) {
            logger.error((Object)"Failed to compute full execution plan", (Throwable)e);
            status.output.withWarning(RecipeCodes.ERR_RECIPE_EXECUTION_PLAN_COMPUTATION_FAILED, "Table not found in Hive global metastore:" + ExceptionUtils.getMessageWithCauses((Throwable)e));
        }
        catch (Exception e) {
            logger.error((Object)"Failed to compute full execution plan", (Throwable)e);
            status.output.withWarning(RecipeCodes.ERR_RECIPE_EXECUTION_PLAN_COMPUTATION_FAILED, ExceptionUtils.getMessageWithCauses((Throwable)e));
        }
    }

    private void checkSQL(AuthCtx authCtx, final PivotRecipeStatus status, PivotRecipePayloadParams params, Dataset inputDS, Dataset outputDS, SQLDialect dialect) throws IOException {
        SQLUtils.SQLTable sqlTable = DatasetUtils.getResolvedTableWithSparkSQLFallback(inputDS, dialect, params.engineParams);
        boolean executionPlanFailed = false;
        String executionPlanErrMsg = null;
        try {
            PivotSQLGenerator sqlGenerator = new PivotSQLGenerator(params, inputDS, sqlTable, outputDS);
            SelectQueryBuilder pivotStageQuery = sqlGenerator.generateQueryForPivot((SQLDialect)dialect).selectQueryBuilder;
            String sql = pivotStageQuery.toSQL(dialect);
            this.getExecutionPlan(authCtx, Lists.newArrayList((Object[])new Dataset[]{inputDS}), status.getSelectedSQLBasedEngine(), sql, status.params.engineParams);
        }
        catch (ExecutionPlanService.HiveTableNotFound e) {
            logger.error((Object)"Failed to compute execution plan", (Throwable)e);
            status.output.withWarning(RecipeCodes.ERR_RECIPE_EXECUTION_PLAN_COMPUTATION_FAILED, "Table not found in Hive global metastore:" + ExceptionUtils.getMessageWithCauses((Throwable)e));
        }
        catch (Exception e) {
            logger.error((Object)"Failed to compute execution plan", (Throwable)e);
            executionPlanFailed = true;
            executionPlanErrMsg = ExceptionUtils.getMessageWithCauses((Throwable)e);
            status.output.withWarning(RecipeCodes.ERR_RECIPE_EXECUTION_PLAN_COMPUTATION_FAILED, ExceptionUtils.getMessageWithCauses((Throwable)e));
        }
        if (executionPlanFailed && status.selectedEngine.type.equals("HIVE")) {
            status.output.withFatal(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, executionPlanErrMsg);
            executionPlanFailed = false;
        }
        PivotRecipePayloadParams params2 = (PivotRecipePayloadParams)JSON.deepCopy((Object)params);
        if (executionPlanFailed) {
            params2.preFilter = new FilterDesc();
            params2.computedColumns = Lists.newArrayList();
            if (this.executionPlanFails(params2, inputDS, outputDS, sqlTable, dialect, status.getSelectedSQLBasedEngine(), authCtx, new ReportExecutionPlanFailure(){

                @Override
                public void handle(Exception e) {
                    status.output.withFatal(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "Cannot select from input dataset : " + ExceptionUtils.getMessageWithCauses((Throwable)e));
                }
            })) {
                executionPlanFailed = false;
            }
        }
        if (executionPlanFailed && (params.preFilter.enabled || params.preFilter.distinct)) {
            params2.preFilter = (FilterDesc)JSON.deepCopy((Object)params.preFilter);
            if (this.executionPlanFails(params2, inputDS, outputDS, sqlTable, dialect, status.getSelectedSQLBasedEngine(), authCtx, new ReportExecutionPlanFailure(){

                @Override
                public void handle(Exception e) {
                    status.preFilter.withFatal(RecipeCodes.ERR_RECIPE_PIVOT_INVALID_FILTER, ExceptionUtils.getMessageWithCauses((Throwable)e));
                }
            })) {
                executionPlanFailed = false;
            }
        }
        if (params.computedColumns != null && !params.computedColumns.isEmpty()) {
            int computedColumnIndex = 0;
            for (ComputedColumn computedColumn : params.computedColumns) {
                if (executionPlanFailed) {
                    params2.computedColumns = Lists.newArrayList((Object[])new ComputedColumn[]{computedColumn});
                    final int currentComputedColumnIndex = computedColumnIndex;
                    if (this.executionPlanFails(params2, inputDS, outputDS, sqlTable, dialect, status.getSelectedSQLBasedEngine(), authCtx, new ReportExecutionPlanFailure(){

                        @Override
                        public void handle(Exception e) {
                            status.computedColumns.addMessage(InfoMessage.fatal((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_PIVOT_INVALID_COMPUTED, (String)ExceptionUtils.getMessageWithCauses((Throwable)e)).withPos(currentComputedColumnIndex, 0));
                        }
                    })) {
                        executionPlanFailed = false;
                    }
                }
                ++computedColumnIndex;
            }
        }
    }

    private boolean executionPlanFails(PivotRecipePayloadParams params, Dataset inputDS, Dataset outputDS, SQLUtils.SQLTable sqlTable, SQLDialect dialect, VisualSQLRecipesBaseService.SQLBasedEngineStatus engineStatus, AuthCtx authCtx, ReportExecutionPlanFailure report) {
        PivotSQLGenerator sqlGenerator = new PivotSQLGenerator(params, inputDS, sqlTable, outputDS);
        SelectQueryBuilder pivotStageQuery = sqlGenerator.generateQueryForPivot((SQLDialect)dialect).selectQueryBuilder;
        String sql = pivotStageQuery.toSQL(dialect);
        try {
            this.getExecutionPlan(authCtx, Lists.newArrayList((Object[])new Dataset[]{inputDS}), engineStatus, sql, params.engineParams);
            return false;
        }
        catch (Exception e) {
            logger.error((Object)("Failed to compute execution plan for :\n" + sql), (Throwable)e);
            report.handle(e);
            return true;
        }
    }

    private void fixupStatusOutputInvalid(VisualSQLRecipeStatus status) {
        if (status.isInvalid() && !status.output.anyFatal()) {
            status.output.withFatal(RecipeCodes.ERR_RECIPE_GENERIC_ERROR, "Failed to validate all recipe steps");
        }
    }

    private PivotRecipeStatus getEngineIndependentBaseStatus(AuthCtx authCtx, StatusInitializer init) throws IOException {
        PivotRecipePayloadParams params;
        PivotRecipeStatus status = new PivotRecipeStatus();
        try {
            FlowRecipe flowRecipe = new FlowRecipe(this.recipe);
            init.activity = new JobActivity(this.recipesValidationService.getSampleSubgraph(flowRecipe));
            params = this.service.loadParams(this.payload, this.recipe);
            assert (params != null);
            status.params = params;
            status.engineParams = params.engineParams;
            init.inputDS = init.activity.getSubgraph().getSingleSourceDataset().getMandatoryUnsafe(this.datasetsDAO);
            init.outputDS = init.activity.getSubgraph().getSingleTargetDataset().getMandatoryUnsafe(this.datasetsDAO);
            this.recipesValidationService.checkComplianceWithRecipeDesc(authCtx, this.recipe);
            this.recipesValidationService.checkTargetsAreWritable(init.activity);
        }
        catch (Exception e) {
            logger.error((Object)"Invalid recipe", (Throwable)e);
            status.output.withFatal(RecipeCodes.ERR_RECIPE_INCONSISTENT_RECIPE, ExceptionUtils.getMessageWithCauses((Throwable)e));
            return status;
        }
        PivotRecipeStatusComputer.checkParamsNoColumns(params, status);
        if (params.preFilter != null && (params.preFilter.enabled || params.preFilter.distinct)) {
            status.preFilter = new RecipeStatus.StepStatus();
            this.visualRecipesService.checkFilter(params.preFilter, init.inputDS, new DummySQLDialect(), status.preFilter, false);
        }
        if (init.inputDS != null) {
            PivotRecipeStatusComputer.checkParamsStageConsistency(params, status, init.inputDS.getSchema());
        }
        return status;
    }

    public static void checkParamsStageConsistency(PivotRecipePayloadParams params, PivotRecipeStatus status, Schema schema) throws IOException {
        HashSet columns = Sets.newHashSet();
        for (SchemaColumn schemaColumn : schema.getColumns()) {
            columns.add(schemaColumn.getName());
        }
        for (ComputedColumn computedColumn : params.computedColumns) {
            columns.add(computedColumn.name);
        }
        for (String string : params.explicitIdentifiers) {
            if (columns.contains(string)) continue;
            status.pivot.withFatal(RecipeCodes.ERR_RECIPE_PIVOT_UNKNOWN_COLUMN, "Unknown column '" + string + "' in the identifiers");
        }
        int pivotIndex = 0;
        for (PivotElement pivot : params.pivots) {
            for (String key : pivot.keyColumns) {
                if (columns.contains(key)) continue;
                status.pivot.addMessage(InfoMessage.fatal((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_PIVOT_UNKNOWN_COLUMN, (String)("Unknown column '" + key + "' in the keys")).withPos(pivotIndex, 0));
            }
            for (GroupingRecipePayloadParams.GroupingValue valueColumn : pivot.valueColumns) {
                if (columns.contains(valueColumn.column)) continue;
                status.pivot.addMessage(InfoMessage.fatal((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_PIVOT_UNKNOWN_COLUMN, (String)("Unknown column '" + valueColumn.column + "' in the aggregates")).withPos(pivotIndex, 0));
            }
            ++pivotIndex;
        }
        for (GroupingRecipePayloadParams.GroupingValue valueColumn : params.otherColumns) {
            if (columns.contains(valueColumn.column)) continue;
            status.otherColumns.withFatal(RecipeCodes.ERR_RECIPE_PIVOT_UNKNOWN_COLUMN, "Unknown column '" + valueColumn.column + "' in the other columns");
        }
    }

    public static void checkParamsColumns(PivotRecipePayloadParams params, PivotRecipeStatus status, SQLDialect dialect) {
        if (params.computedColumns != null && !params.computedColumns.isEmpty()) {
            status.computedColumns = new RecipeStatus.StepStatus();
            VisualSQLRecipesBaseService.basicCheckComputedColumns(params.computedColumns, status.computedColumns, dialect);
        }
    }

    public static void checkParamsNoColumns(PivotRecipePayloadParams params, PivotRecipeStatus status) {
        status.pivot = new RecipeStatus.StepStatus();
        if (params.customAggregates != null && params.customAggregates.size() > 0) {
            HashSet customAggregatesNames = Sets.newHashSet();
            for (CustomAggregateDefinition customAggregate : params.customAggregates) {
                if (StringUtils.isBlank((String)customAggregate.name)) {
                    status.pivot.withFatal(RecipeCodes.ERR_RECIPE_PIVOT_INVALID_AGGREGATE, "Custom aggregate lacks a name");
                } else {
                    if (customAggregatesNames.contains(customAggregate.name)) {
                        status.pivot.withFatal(RecipeCodes.ERR_RECIPE_PIVOT_INVALID_AGGREGATE, "Duplicate custom aggregate '" + customAggregate.name + "'");
                    }
                    customAggregatesNames.add(customAggregate.name);
                }
                if (!StringUtils.isBlank((String)customAggregate.expression)) continue;
                status.pivot.withFatal(RecipeCodes.ERR_RECIPE_PIVOT_INVALID_AGGREGATE, "Custom aggregate '" + customAggregate.name + "' lacks an expression");
            }
        }
        if (params.pivots == null || params.pivots.isEmpty()) {
            status.pivot.withFatal(RecipeCodes.ERR_RECIPE_PIVOT_NO_PIVOT, "No pivot defined.");
        } else {
            int pivotIndex = 0;
            for (PivotElement pivot : params.pivots) {
                PivotRecipeStatusComputer.checkParamsPivot(status, pivotIndex, pivot, params.customAggregates);
                ++pivotIndex;
            }
        }
        if (params.otherColumns != null && params.otherColumns.size() > 0) {
            status.otherColumns = new RecipeStatus.StepStatus();
        }
    }

    private static void checkParamsPivot(PivotRecipeStatus status, int pivotIndex, PivotElement pivot, List<CustomAggregateDefinition> customAggregates) {
        if (pivot.keyColumns == null || pivot.keyColumns.isEmpty()) {
            status.pivot.addMessage(InfoMessage.fatal((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_PIVOT_NO_KEY, (String)"No key defined for pivot.").withPos(pivotIndex, 0));
        }
        if (!pivot.globalCount && (pivot.valueColumns == null || pivot.valueColumns.isEmpty())) {
            status.pivot.addMessage(InfoMessage.fatal((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_PIVOT_NO_AGG, (String)"No aggregation defined.").withPos(pivotIndex, 0));
        }
        HashSet aggregates = Sets.newHashSet();
        for (GroupingRecipePayloadParams.GroupingValue valueColumn : pivot.valueColumns) {
            if (StringUtils.isNotBlank((String)valueColumn.customAggr)) {
                CustomAggregateDefinition found = null;
                for (CustomAggregateDefinition aggregate : customAggregates) {
                    if (!valueColumn.customAggr.equals(aggregate.name)) continue;
                    found = aggregate;
                }
                if (found == null) {
                    status.pivot.addMessage(InfoMessage.fatal((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_PIVOT_MISSING_CUSTOM_AGGREGATE, (String)("Custom aggregate" + valueColumn.customAggr + " is used on column " + valueColumn.column + " but not defined")).withPos(pivotIndex, 0));
                }
            }
            if ((valueColumn.first || valueColumn.last) && StringUtils.isBlank((String)valueColumn.orderColumn)) {
                status.pivot.addMessage(InfoMessage.fatal((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_GROUPING_MISSING_ORDERING, (String)("First/Last aggregate on " + valueColumn.column + " without ordering column")).withPos(pivotIndex, 0));
            }
            SchemaColumn inputColumn = new SchemaColumn(valueColumn.column, Type.STRING);
            GroupingRecipePayloadParams fakeParams = new GroupingRecipePayloadParams();
            for (SchemaColumn aggregate : valueColumn.getDerivedColumns(fakeParams, inputColumn.getType(), new SchemaUtils.SchemalessSafeColumnIdentifierSuffixer(null))) {
                if (aggregates.contains(aggregate.getName())) {
                    status.pivot.addMessage(InfoMessage.fatal((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_PIVOT_DUPLICATE_AGGREGATE, (String)("Duplicate aggregate " + aggregate.getName())).withPos(pivotIndex, 0));
                }
                aggregates.add(aggregate.getName());
            }
        }
    }

    private void checkPartitionKeyUsedAsGrouping(StatusInitializer init, PivotRecipeStatus status) {
        PartitioningScheme partitionScheme = init.outputDS.getPartitioningSchema();
        if (partitionScheme != null) {
            List partitionKeys = partitionScheme.getDimensionNames();
            for (String groupKey : status.params.explicitIdentifiers) {
                if (!partitionKeys.contains(groupKey)) continue;
                status.pivot.withWarning(RecipeCodes.WARN_RECIPE_PIVOT_PARTITION_USED_AS_ROW_IDENTIFIER, "\"" + groupKey + "\" is a partition column. Be aware that the partitioning mechanism might override the output of this recipe.");
            }
        }
    }

    private PivotRecipeStatus fastStatusIgnorePartitions(AuthCtx authCtx, StatusInitializer init, boolean reportUnknownErrorsToStatus) throws IOException {
        PivotRecipePayloadParams params;
        PivotRecipeStatus status;
        block16: {
            RecipeEnginesPreferenceConfig repc;
            block15: {
                status = this.getEngineIndependentBaseStatus(authCtx, init);
                params = status.params;
                repc = new RecipeConfigUtils().getResolvedPreferenceConfig(this.recipe.projectKey, this.recipe.type, params.enginesPreferences);
                try {
                    this.visualRecipesService.initEngines(authCtx, init.activity, status, this.recipe.projectKey);
                    this.performBasicCDEChecks(status, authCtx);
                    this.visualRecipesService.selectEngine(authCtx, init.activity, params.engineType, status, this.recipe.type, repc);
                    this.visualRecipesService.adjustEngineStatus(authCtx, init.activity, status, "Aggregate in-database then streaming of pivoted data");
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to init engine", (Throwable)e);
                    if (status.isInvalid()) break block15;
                    status.output.withFatalV(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "Failed to init engine: %s", new Object[]{ExceptionUtils.getMessageWithCauses((Throwable)e)});
                }
            }
            if (!status.isInvalid()) {
                try {
                    this.makeRecipeSpecificEngineStatus(authCtx, init, status, params);
                    this.visualRecipesService.selectEngine(authCtx, init.activity, params.engineType, status, this.recipe.type, repc);
                    this.visualRecipesService.adjustEngineStatus(authCtx, init.activity, status, "Aggregate in-database then streaming of pivoted data");
                    if (status.selectedEngine == null && !status.isInvalid()) {
                        status.output.withFatalV(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "No engine selected", new Object[0]);
                        return status;
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to init engine", (Throwable)e);
                    status.output.withFatalV(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "Failed to init engine: %s", new Object[]{ExceptionUtils.getMessageWithCauses((Throwable)e)});
                    return status;
                }
                if (status.getSelectedSQLBasedEngine().queryBased) {
                    try {
                        init.dialect = this.visualRecipesService.getDialect(authCtx, init.activity, status.getSelectedSQLBasedEngine());
                        PivotRecipeStatusComputer.checkParamsColumns(params, status, init.dialect);
                        this.checkPartitionKeyUsedAsGrouping(init, status);
                    }
                    catch (Exception e) {
                        logger.info((Object)"Failed to get SQL dialect", (Throwable)e);
                        init.error = ExceptionUtils.getMessageWithCauses((Throwable)e);
                        if (!reportUnknownErrorsToStatus) break block16;
                        status.output.withFatalV(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "Failed to infer SQL dialect: %s", new Object[]{ExceptionUtils.getMessageWithCauses((Throwable)e)});
                    }
                } else {
                    for (ComputedColumn computedColumn : params.computedColumns) {
                        if (computedColumn.mode != ComputedColumn.Mode.SQL) continue;
                        status.computedColumns.withFatal(RecipeCodes.ERR_RECIPE_PIVOT_INVALID_COMPUTED, "Cannot use SQL expression '" + computedColumn.expr + "' in DSS engine");
                    }
                    int pivotIndex = 0;
                    for (PivotElement pivot : params.pivots) {
                        for (GroupingRecipePayloadParams.GroupingValue valueColumn : pivot.valueColumns) {
                            if (!StringUtils.isNotBlank((String)valueColumn.customAggr)) continue;
                            status.pivot.addMessage(InfoMessage.fatal((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_PIVOT_INVALID_AGGREGATE, (String)"Cannot use custom aggregates in DSS engine").withPos(pivotIndex, 0));
                        }
                        ++pivotIndex;
                    }
                }
            }
        }
        if (params.preFilter != null && params.preFilter.enabled && init.dialect != null) {
            status.preFilter = new RecipeStatus.StepStatus();
            this.visualRecipesService.checkFilter(params.preFilter, init.inputDS, init.dialect, status.preFilter, true);
        }
        this.checkParamOtherColumns(init, status, params);
        if (params.computedColumns != null && !params.computedColumns.isEmpty()) {
            status.computedColumns = new RecipeStatus.StepStatus();
            boolean mustLowercaseColumns = this.visualRecipesService.mustLowerCaseColumnsNames((VisualSQLRecipePayloadParams)params, status.getSelectedSQLBasedEngine());
            this.visualRecipesService.checkComputedColumns(params.computedColumns, init.inputDS.getSchema(), (VisualSQLRecipesBaseService.SQLBasedEngineStatus)status.selectedEngine, init.dialect, mustLowercaseColumns, status.computedColumns);
        }
        return status;
    }

    private void checkParamOtherColumns(StatusInitializer init, PivotRecipeStatus status, PivotRecipePayloadParams params) {
        if (init.dialect instanceof PostgreSQLDialect && params.otherColumns != null && params.otherColumns.size() > 0) {
            HashSet availableColumnsForOrdering = Sets.newHashSet();
            if (params.explicitIdentifiers != null) {
                availableColumnsForOrdering.addAll(params.explicitIdentifiers);
            }
            for (GroupingRecipePayloadParams.GroupingValue other : params.otherColumns) {
                if (other == null) continue;
                availableColumnsForOrdering.add(other.column);
            }
            if (params.pivots != null) {
                for (PivotElement pivotElement : params.pivots) {
                    if (pivotElement == null || pivotElement.keyColumns == null) continue;
                    availableColumnsForOrdering.addAll(pivotElement.keyColumns);
                }
            }
            for (GroupingRecipePayloadParams.GroupingValue other : params.otherColumns) {
                if (other == null || other.orderColumn == null || !other.first && !other.last || availableColumnsForOrdering.contains(other.orderColumn)) continue;
                status.otherColumns.withFatal(RecipeCodes.ERR_RECIPE_PIVOT_UNKNOWN_COLUMN, "Ordering column \"" + other.orderColumn + "\" not included. Add it or choose another ordering column.");
            }
        }
    }

    private void makeRecipeSpecificEngineStatus(AuthCtx authCtx, StatusInitializer init, PivotRecipeStatus status, PivotRecipePayloadParams params) throws Exception {
        logger.info((Object)"Computing engine status for pivot recipe");
        for (VisualSQLRecipesBaseService.SQLBasedEngineStatus engine : status.getEngines()) {
            if (!engine.isSelectable || !engine.queryBased) continue;
            SQLDialect dialect = this.visualRecipesService.getDialect(authCtx, init.activity, engine);
            try {
                FilterDescUtils.getSQLExpression(params.preFilter, dialect, init.inputDS, true);
                if (params.computedColumns == null || params.computedColumns.isEmpty()) continue;
                for (ComputedColumn cc : params.computedColumns) {
                    ExpressionBuilder expr = QueryGenerationUtils.getComputedColumnExpr(cc, dialect, init.inputDS.getSchema());
                    expr.toSQL(dialect);
                }
            }
            catch (Exception e) {
                if (engine.type.equals("DSS")) {
                    RecipeEngineStatus.setErrorStatus("Recipe configuration is not supported: " + ExceptionUtils.getMessageWithCauses((Throwable)e), engine);
                    continue;
                }
                RecipeEngineStatus.setErrorStatus("Recipe cannot be translated to SQL: " + ExceptionUtils.getMessageWithCauses((Throwable)e), engine);
            }
        }
    }

    private static class StatusInitializer {
        public Dataset inputDS;
        public Dataset outputDS;
        public SQLDialect dialect;
        public JobActivity activity;
        public String error;

        private StatusInitializer() {
        }
    }

    public static class PivotRecipeStatus
    extends VisualSQLRecipeStatus {
        RecipeStatus.StepStatus preFilter;
        RecipeStatus.StepStatus computedColumns;
        RecipeStatus.StepStatus otherColumns;
        RecipeStatus.StepStatus pivot;
        PivotRecipePayloadParams params;
        Schema computedColumnsStageSchema;
        Schema pivotStageSchema;
        List<List<PivotedModality>> pivotModalities;
        List<String> identifiers;
        boolean modalitiesComputedOnDifferentEngine;
        String sqlWarning;

        @Override
        public InfoMessage.InfoMessages gatherAllMessages() {
            InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
            ret.mergeFrom(this.topLevelMessages);
            if (this.preFilter != null) {
                ret.mergeFrom((InfoMessage.InfoMessages)this.preFilter);
            }
            if (this.computedColumns != null) {
                ret.mergeFrom((InfoMessage.InfoMessages)this.computedColumns);
            }
            if (this.otherColumns != null) {
                ret.mergeFrom((InfoMessage.InfoMessages)this.otherColumns);
            }
            if (this.pivot != null) {
                ret.mergeFrom((InfoMessage.InfoMessages)this.pivot);
            }
            ret.mergeFrom((InfoMessage.InfoMessages)this.output);
            return ret;
        }

        @Override
        public boolean isInvalid() {
            return this.gatherAllMessages().anyFatal();
        }
    }

    private static interface ReportExecutionPlanFailure {
        public void handle(Exception var1);
    }
}

