/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.split;

import com.dataiku.dip.containers.exec.ContainerExecSelection;
import com.dataiku.dip.dataflow.exec.VisualSQLRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.computedcolumn.ComputedColumn;
import com.dataiku.dip.dataflow.exec.filter.FilterDesc;
import com.dataiku.dip.recipes.BasicRecipeLineageHandler;
import com.dataiku.dip.recipes.ParamsWithContainerizable;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.joda.time.LocalDate;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class SplitRecipePayloadParams
extends VisualSQLRecipePayloadParams
implements ParamsWithContainerizable,
BasicRecipeLineageHandler.Params {
    public Mode mode;
    public int defaultOutputIndex = 1;
    @JSON.FileTransient
    public String defaultOutputDataset;
    public List<FilterSplitDesc> filterSplits = Lists.newArrayList((Object[])new FilterSplitDesc[]{FilterSplitDesc.defaultSplit()});
    public Long seed = 1337L;
    public List<ShareSplitDesc> randomSplits = Lists.newArrayList((Object[])new ShareSplitDesc[]{ShareSplitDesc.defaultSplit()});
    public String randomColumnsSalt = null;
    public List<String> randomColumns = new ArrayList<String>();
    public List<ShareSplitDesc> randomColumnsSplits = Lists.newArrayList((Object[])new ShareSplitDesc[]{ShareSplitDesc.defaultSplit()});
    public boolean centileTDigest = false;
    public boolean centileShuffle = false;
    public List<Order> centileOrders = new ArrayList<Order>();
    public List<ShareSplitDesc> centileSplits = Lists.newArrayList((Object[])new ShareSplitDesc[]{ShareSplitDesc.defaultSplit()});
    public boolean rangeSetTime = false;
    public List<FilterSplitDesc> rangeSplits = Lists.newArrayList((Object[])new FilterSplitDesc[]{FilterSplitDesc.defaultSplit()});
    public String column;
    public List<ValueSplitDesc> valueSplits = Lists.newArrayList((Object[])new ValueSplitDesc[]{ValueSplitDesc.defaultSplit()});
    public boolean writeComputedColumnsInOutput;
    public List<ComputedColumn> computedColumns = new ArrayList<ComputedColumn>();
    public FilterDesc preFilter = new FilterDesc();

    public boolean hasPrefilter() {
        return this.preFilter != null && (this.preFilter.enabled || this.preFilter.distinct);
    }

    public boolean hasComputedColumns() {
        return this.computedColumns != null && !this.computedColumns.isEmpty();
    }

    @Override
    public ContainerExecSelection getContainerSelection() {
        return this.engineParams.containerSelection;
    }

    @Override
    public void setContainerSelection(ContainerExecSelection selection) {
        this.engineParams.containerSelection = selection;
    }

    public void check() {
        if (this.mode != null) {
            if (this.hasComputedColumns()) {
                for (ComputedColumn computedColumn : this.computedColumns) {
                    if (StringUtils.isBlank((String)computedColumn.name)) {
                        throw ErrorContext.iae((String)"Computed column has no name");
                    }
                    if (computedColumn.type == null) {
                        throw ErrorContext.iae((String)("Computed column " + computedColumn.name + " has no type"));
                    }
                    if (!StringUtils.isBlank((String)computedColumn.expr)) continue;
                    throw ErrorContext.iae((String)("Computed column " + computedColumn.name + " has no definition"));
                }
            }
            switch (this.mode) {
                case VALUES: {
                    if (StringUtils.isBlank((String)this.column)) {
                        throw ErrorContext.iae((String)"No specified column to split on values");
                    }
                    if (this.valueSplits != null && !this.valueSplits.isEmpty()) break;
                    throw ErrorContext.iae((String)"No value split defined");
                }
                case FILTERS: {
                    if (this.filterSplits != null && !this.filterSplits.isEmpty()) break;
                    throw ErrorContext.iae((String)"No filter splits defined");
                }
                case RANDOM: {
                    this.checkShareSplit(this.randomSplits);
                    break;
                }
                case RANDOM_COLUMNS: {
                    if (this.randomColumns == null || this.randomColumns.isEmpty()) {
                        throw ErrorContext.iae((String)"No column selected");
                    }
                    this.checkShareSplit(this.randomColumnsSplits);
                    break;
                }
                case CENTILE: {
                    if (this.centileOrders != null && !this.centileOrders.isEmpty()) break;
                    throw ErrorContext.iae((String)"No column selected to build order");
                }
                case RANGE: {
                    if (StringUtils.isBlank((String)this.column)) {
                        throw ErrorContext.iae((String)"No specified column to split on values");
                    }
                    if (this.rangeSplits != null && !this.rangeSplits.isEmpty()) break;
                    throw ErrorContext.iae((String)"No filter splits defined");
                }
                default: {
                    throw ErrorContext.iae((String)"Split mode is not specified");
                }
            }
        }
    }

    private void checkShareSplit(List<ShareSplitDesc> splits) {
        if (splits == null || splits.isEmpty()) {
            throw ErrorContext.iae((String)"No random splits defined");
        }
        float totalShare = 0.0f;
        for (ShareSplitDesc rs2 : splits) {
            if (rs2.share == null) {
                throw ErrorContext.iae((String)"Share must be defined");
            }
            totalShare += rs2.share.floatValue();
            if (!(rs2.share.floatValue() > 100.0f) && !(rs2.share.floatValue() < 0.0f)) continue;
            throw ErrorContext.iae((String)"Shares must be between 0 and 100");
        }
        if (totalShare > 100.0f) {
            throw ErrorContext.iae((String)("Sum of shares is " + totalShare + " %. It must be inferior to 100%"));
        }
    }

    public void preprocessDateRanges() {
        if (this.mode == Mode.RANGE && !this.rangeSetTime) {
            for (FilterSplitDesc split : this.rangeSplits) {
                if (split.filter == null || split.filter.uiData == null || split.filter.uiData.conditions == null) continue;
                for (FilterDesc.FilterUiCondition condition : split.filter.uiData.conditions) {
                    LocalDate ld;
                    if (condition == null) continue;
                    if ("<= [date]".equals(condition.operator) && StringUtils.isNotBlank((String)condition.date)) {
                        condition.operator = "<  [date]";
                        ld = new LocalDate((Object)condition.date);
                        condition.date = ld.plusDays(1).toString();
                    }
                    if (!">  [date]".equals(condition.operator) || !StringUtils.isNotBlank((String)condition.date)) continue;
                    condition.operator = ">= [date]";
                    ld = new LocalDate((Object)condition.date);
                    condition.date = ld.plusDays(1).toString();
                }
            }
        }
    }

    @Override
    public List<ComputedColumn> getComputedColumns() {
        return this.computedColumns;
    }

    public static class FilterSplitDesc
    extends GenericSplitDesc {
        public FilterDesc filter;

        public static FilterSplitDesc defaultSplit() {
            FilterSplitDesc split = new FilterSplitDesc();
            split.outputIndex = 0;
            split.filter = new FilterDesc();
            split.filter.enabled = true;
            split.filter.uiData = new FilterDesc.FilterUiData();
            return split;
        }
    }

    public static class ShareSplitDesc
    extends GenericSplitDesc {
        public Float share;

        public static ShareSplitDesc defaultSplit() {
            ShareSplitDesc split = new ShareSplitDesc();
            split.outputIndex = 0;
            split.share = Float.valueOf(50.0f);
            return split;
        }
    }

    public static class ValueSplitDesc
    extends GenericSplitDesc {
        public String value;
        public boolean caseSensitive;

        public static ValueSplitDesc defaultSplit() {
            ValueSplitDesc split = new ValueSplitDesc();
            split.outputIndex = 0;
            return split;
        }
    }

    public static enum Mode {
        FILTERS("Specific filter for each output dataset"),
        RANDOM("Randomly split to the output datasets with exact ratio"),
        RANDOM_COLUMNS("Randomly split to the output datasets based on values of multiple columns"),
        CENTILE("Sort-based / centile split"),
        RANGE("Split on range of values for a column"),
        VALUES("Map values of a single column to the outputs datasets");

        public final String uiDescription;

        private Mode(String uiDescription) {
            this.uiDescription = uiDescription;
        }
    }

    public static class Order {
        public String column;
        public boolean desc;
    }

    public static class GenericSplitDesc {
        public int outputIndex = -1;
        @JSON.FileTransient
        public String outputDatasetFullName;
    }
}

