/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.split;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.filter.FilterDesc;
import com.dataiku.dip.dataflow.exec.filter.FilterDescUtils;
import com.dataiku.dip.dataflow.exec.filter.GrelExpression;
import com.dataiku.dip.dataflow.exec.split.AbstractSplitRecipeExecutor;
import com.dataiku.dip.dataflow.exec.split.ColumnBasedSplitProcessorOutput;
import com.dataiku.dip.dataflow.exec.split.FilterBasedSplitProcessorOutput;
import com.dataiku.dip.dataflow.exec.split.RandomBasedSplitProcessorOutput;
import com.dataiku.dip.dataflow.exec.split.RandomColumnBasedSplitProcessorOutput;
import com.dataiku.dip.dataflow.exec.split.SplitRecipeCentileBuiltinRunner;
import com.dataiku.dip.dataflow.exec.split.SplitRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.stream.ToDatasetStreamer;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamColumn;
import com.dataiku.dip.datalayer.streamimpl.StreamColumnFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamRowFactory;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.StreamableDatasetSelection;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.UniversalSingleThreadPusher;
import com.dataiku.dip.expressions.Expression;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.recipes.SplitRecipeService;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.NotImplementedException;
import com.dataiku.dip.variables.VariablesContext;
import com.google.common.collect.Lists;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class SplitRecipeStreamExecutor
extends AbstractSplitRecipeExecutor {
    @Autowired
    protected SplitRecipeService service;

    public SplitRecipeStreamExecutor(JobActivity activity, SplitRecipePayloadParams params, boolean lowerCaseColumns) {
        super(activity, params, lowerCaseColumns);
    }

    @Override
    public void run() throws Exception {
        if (this.params.mode == SplitRecipePayloadParams.Mode.CENTILE) {
            SplitRecipeCentileBuiltinRunner centileRunner = new SplitRecipeCentileBuiltinRunner(this.activity, this.params);
            SpringUtils.getInstance().autowire((Object)centileRunner);
            centileRunner.init();
            centileRunner.run();
        } else {
            ProcessorOutput wrappedOutput;
            StreamColumnFactory cf = new StreamColumnFactory();
            StreamRowFactory rf = new StreamRowFactory();
            HashMap<String, ProcessorOutput> processorOutputs = new HashMap<String, ProcessorOutput>();
            List<FlowDataset> flowOutputs = this.activity.getSubgraph().getTargetsDatasets();
            for (FlowDataset outputFD : flowOutputs) {
                Dataset outputDS = outputFD.getMandatory(this.datasetsDAO);
                Partition targetPartition = this.activity.getSubgraph().getTargetPartition(outputFD);
                SerializedRecipe.RecipeOutput recipeOutput = this.recipe.getModel().getOutput("main", outputDS.getName());
                Output.WriteMode writeMode = recipeOutput.getWriteMode();
                try (DatasetHandler outputDatasetHandler = DatasetHandlerFactory.build(this.authCtxService.getAuthCtx(), outputDS);){
                    if (writeMode == Output.WriteMode.OVERWRITE && !outputDatasetHandler.outputHandlesClear()) {
                        if (outputDatasetHandler.getMeta().isFSLike()) {
                            outputDatasetHandler.clearPartitions(Lists.newArrayList((Object[])new Partition[]{targetPartition}));
                        }
                        writeMode = Output.WriteMode.APPEND;
                    }
                }
                ToDatasetStreamer streamer = ToDatasetStreamer.newWithAutoBucketing(this.authCtxService.getAuthCtx(), outputDS, targetPartition, (ColumnFactory)cf, this.activity.warnContext, writeMode);
                processorOutputs.put(outputDS.getFullName(), streamer.getAsOutput());
            }
            StreamableDatasetSelection dataSelection = StreamableDatasetSelection.full();
            if (this.inputDS.getPartitioningSchema().isPartitioned()) {
                dataSelection.withSelectedPartitions(this.sourcePartitions);
            }
            if (this.params.hasPrefilter()) {
                dataSelection.filter = this.params.preFilter;
                logger.info((Object)("Add global prefilter on " + FilterDescUtils.getGrelExpression(dataSelection.filter)));
            }
            if (this.params.mode == SplitRecipePayloadParams.Mode.FILTERS) {
                wrappedOutput = this.buildFilterProcessorOutput(this.params.filterSplits, (ColumnFactory)cf, (RowFactory)rf, processorOutputs, dataSelection);
            } else if (this.params.mode == SplitRecipePayloadParams.Mode.RANGE) {
                this.params.preprocessDateRanges();
                wrappedOutput = this.buildFilterProcessorOutput(this.params.rangeSplits, (ColumnFactory)cf, (RowFactory)rf, processorOutputs, dataSelection);
            } else if (this.params.mode == SplitRecipePayloadParams.Mode.RANDOM) {
                RandomBasedSplitProcessorOutput randomSplitOutput = new RandomBasedSplitProcessorOutput(this.getTotalRecordsWithFilters(), this.params);
                randomSplitOutput.setFactories((ColumnFactory)cf, (RowFactory)rf);
                for (SplitRecipePayloadParams.ShareSplitDesc rsd : this.params.randomSplits) {
                    logger.info((Object)("add random split " + rsd.share + " -> " + rsd.outputDatasetFullName));
                    randomSplitOutput.addOutput(rsd.share.floatValue(), (ProcessorOutput)processorOutputs.get(rsd.outputDatasetFullName));
                }
                defaultOutput = this.params.defaultOutputDataset == null ? null : (ProcessorOutput)processorOutputs.get(this.params.defaultOutputDataset);
                randomSplitOutput.setDefaultOutput((ProcessorOutput)defaultOutput);
                randomSplitOutput.setTargetRecords();
                wrappedOutput = randomSplitOutput;
            } else if (this.params.mode == SplitRecipePayloadParams.Mode.RANDOM_COLUMNS) {
                RandomColumnBasedSplitProcessorOutput randomColumnSplitOutput = new RandomColumnBasedSplitProcessorOutput(this.params);
                randomColumnSplitOutput.setFactories((ColumnFactory)cf, (RowFactory)rf);
                for (SplitRecipePayloadParams.ShareSplitDesc rcsd : this.params.randomColumnsSplits) {
                    logger.info((Object)("add random column split " + rcsd.share + " -> " + rcsd.outputDatasetFullName));
                    randomColumnSplitOutput.addOutput(rcsd.share.floatValue(), (ProcessorOutput)processorOutputs.get(rcsd.outputDatasetFullName));
                }
                for (String colName : this.params.randomColumns) {
                    StreamColumn column = cf.column(colName);
                    logger.info((Object)("add selected column to base the split on " + String.valueOf(column)));
                    randomColumnSplitOutput.addColumn((Column)column);
                }
                defaultOutput = this.params.defaultOutputDataset == null ? null : (ProcessorOutput)processorOutputs.get(this.params.defaultOutputDataset);
                randomColumnSplitOutput.setDefaultOutput((ProcessorOutput)defaultOutput);
                wrappedOutput = randomColumnSplitOutput;
            } else if (this.params.mode == SplitRecipePayloadParams.Mode.VALUES) {
                Schema inputAndComputedColumnsSchema = this.service.getInputAndComputedColumnsBaseSchema(this.inputDS, this.params, true);
                if (inputAndComputedColumnsSchema == null || inputAndComputedColumnsSchema.getColumn(this.params.column) == null) {
                    throw ErrorContext.iaef((String)"Dataset %s does not contain column '%s'", (Object)this.inputDS.getName(), (Object[])new Object[]{this.params.column});
                }
                StreamColumn col = cf.column(this.params.column);
                ColumnBasedSplitProcessorOutput valueSplitOutput = new ColumnBasedSplitProcessorOutput((Column)col, this.params);
                valueSplitOutput.setFactories((ColumnFactory)cf, (RowFactory)rf);
                for (SplitRecipePayloadParams.ValueSplitDesc vsd : this.params.valueSplits) {
                    logger.info((Object)("add split " + vsd.value + " -> " + vsd.outputDatasetFullName));
                    Type inputType = inputAndComputedColumnsSchema.getColumn(this.params.column).getType();
                    if (inputType == Type.BOOLEAN) {
                        valueSplitOutput.addBooleanOutput(vsd.value, vsd.caseSensitive, (ProcessorOutput)processorOutputs.get(vsd.outputDatasetFullName));
                        continue;
                    }
                    if (inputType.isFloatingPoint()) {
                        valueSplitOutput.addFloatingPointOutput(vsd.value, vsd.caseSensitive, (ProcessorOutput)processorOutputs.get(vsd.outputDatasetFullName));
                        continue;
                    }
                    valueSplitOutput.addOutput(vsd.value, vsd.caseSensitive, (ProcessorOutput)processorOutputs.get(vsd.outputDatasetFullName));
                }
                if (this.params.defaultOutputDataset != null) {
                    valueSplitOutput.setDefaultOutput((ProcessorOutput)processorOutputs.get(this.params.defaultOutputDataset));
                }
                wrappedOutput = valueSplitOutput;
            } else {
                throw new NotImplementedException("Splitting mode is not implemented");
            }
            UniversalSingleThreadPusher pusher = new UniversalSingleThreadPusher(this.authCtxService.getAuthCtx(), this.inputDS, wrappedOutput, (ColumnFactory)cf, (RowFactory)rf);
            pusher.setWarningsContext(this.activity.warnContext);
            pusher.setDatasetSelection(dataSelection);
            pusher.push();
            for (ProcessorOutput po : processorOutputs.values()) {
                po.lastRowEmitted();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public ProcessorOutput buildFilterProcessorOutput(List<SplitRecipePayloadParams.FilterSplitDesc> filterSplits, ColumnFactory cf, RowFactory rf, Map<String, ProcessorOutput> processorOutputs, StreamableDatasetSelection dataSelection) throws Exception {
        FilterBasedSplitProcessorOutput filterSplitOutput = new FilterBasedSplitProcessorOutput(this.params);
        filterSplitOutput.setFactories(cf, rf);
        for (SplitRecipePayloadParams.FilterSplitDesc filterSplitDesc : filterSplits) {
            GrelExpression grelExpr = FilterDescUtils.getGrelFilterExpression(filterSplitDesc.filter);
            logger.info((Object)("Add filter split: " + String.valueOf(grelExpr) + "=> " + (StringUtils.isNotBlank((String)filterSplitDesc.outputDatasetFullName) ? filterSplitDesc.outputDatasetFullName : "drop")));
            Expression expr = GrelExpression.build(grelExpr);
            expr.setColumnFactory(cf);
            filterSplitOutput.addOutput(expr, processorOutputs.get(filterSplitDesc.outputDatasetFullName));
        }
        if (this.params.defaultOutputDataset != null) {
            filterSplitOutput.setDefaultOutput(processorOutputs.get(this.params.defaultOutputDataset));
        } else if (!this.params.hasComputedColumns()) {
            void var8_12;
            ArrayList<CallSite> expressions = new ArrayList<CallSite>(filterSplits.size());
            for (SplitRecipePayloadParams.FilterSplitDesc fsd : filterSplits) {
                String grelExpr = FilterDescUtils.getGrelExpression(fsd.filter);
                expressions.add((CallSite)((Object)("(" + grelExpr + ")")));
            }
            String string = StringUtils.join(expressions, (String)" || ");
            logger.info((Object)("Add global prefilter on " + string));
            if (this.params.hasPrefilter()) {
                String prefilterGrelExpression = FilterDescUtils.getGrelExpression(dataSelection.filter);
                String string2 = "(" + string + ") && (" + prefilterGrelExpression + ")";
            }
            VariablesContext vc = SplitRecipeStreamExecutor.findVariablesContext(filterSplits, dataSelection.filter);
            dataSelection.filter = FilterDesc.grelFilter((String)var8_12);
            dataSelection.filter.expressionVariablesContext = vc;
        }
        return filterSplitOutput;
    }

    private static VariablesContext findVariablesContext(List<SplitRecipePayloadParams.FilterSplitDesc> filterSplits, FilterDesc filter) {
        for (SplitRecipePayloadParams.FilterSplitDesc fs : filterSplits) {
            if (fs.filter == null || fs.filter.expressionVariablesContext == null) continue;
            return fs.filter.expressionVariablesContext;
        }
        return filter == null ? null : filter.expressionVariablesContext;
    }
}

