/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.sync;

import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.exec.FSSubgraphHelper;
import com.dataiku.dip.dataflow.exec.FlowRunnable;
import com.dataiku.dip.dataflow.exec.SISORecipeExecutor;
import com.dataiku.dip.dataflow.exec.sync.AutoFastPathConnector;
import com.dataiku.dip.dataflow.exec.sync.FastPathDatasetTypeStraightener;
import com.dataiku.dip.dataflow.exec.sync.FastpathUtils;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.fs.GCSDatasetHandler;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.datasets.sql.AbstractSQLTableDatasetHandler;
import com.dataiku.dip.datasets.sql.BuiltinSQLDatasets;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.fs.FSPath;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.input.formats.csv.CSVFormatConfig;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.partitioning.DimensionValue;
import com.dataiku.dip.partitioning.FilePartitioner;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.recipes.common.RecipeEngineStatus;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.sql.BigQuerySQLDialect;
import com.dataiku.dip.sql.BigQueryUtils;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.bigquery.BigQueryClient;
import com.dataiku.dip.sql.bigquery.BigQueryException;
import com.dataiku.dip.sql.bigquery.BigQuerySchemaHandler;
import com.dataiku.dip.sql.bigquery.CreateTemporaryTableInfo;
import com.dataiku.dip.sql.bigquery.LoadAvroFromCloudStorageOptions;
import com.dataiku.dip.sql.bigquery.LoadCsvFromCloudStorageOptions;
import com.dataiku.dip.sql.bigquery.LoadFromCloudStorageOptions;
import com.dataiku.dip.sql.bigquery.LoadORCFromCloudStorageOptions;
import com.dataiku.dip.sql.bigquery.LoadParquetFromCloudStorageOptions;
import com.dataiku.dip.sql.bigquery.TableResource;
import com.dataiku.dip.sql.bigquery.WriteDisposition;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.ExpressionUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.StringUtils;
import com.dataiku.dip.warnings.WarningsContext;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class GCSToBigQuery
extends SISORecipeExecutor
implements AutoFastPathConnector {
    public static final Pattern DATE_ERROR = Pattern.compile("^(?=.*\\bUnable to parse\\b)(?=.*\"([0-9]+\\/[0-9]+\\/[0-9]+)\").*$", 40);
    private static DKULogger logger = DKULogger.getLogger((String)"dku.recipes.sync.gcstobigquery");

    public static void setCompatible(Dataset inputDS, Dataset outputDS, RecipeEngineStatus status, SerializedRecipe.RecipeOutput recipeOutput) {
        CompatibilityCheck compatibilityCheck = GCSToBigQuery.isCompatible(inputDS, outputDS, recipeOutput);
        if (compatibilityCheck.isOk()) {
            status.isSelectable = true;
        } else {
            status.markAsNonSelectable(compatibilityCheck.errorMessage, RecipeEngineStatus.WarningLevel.ERROR);
        }
    }

    @Override
    public List<FlowRunnable> getRunnables() {
        return Lists.newArrayList();
    }

    @Override
    public void run() throws Exception {
        AbstractSQLDatasetHandler.AbstractSQLConfig outputConfig = this.outputDS.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class).getResolved(this.outputDS.getProjectKey());
        BigQueryClient.TableRef outputTable = new BigQueryClient.TableRef(outputConfig.catalog, outputConfig.schema, outputConfig.table);
        try (AbstractSQLTableDatasetHandler vti = (AbstractSQLTableDatasetHandler)DatasetHandlerFactory.build(this.authCtx, this.outputDS);
             GCSDatasetHandler gcsdh = (GCSDatasetHandler)new FastPathDatasetTypeStraightener().getDatasetHandler(this.authCtx, this.inputDS);){
            SQLConnectionProvider.SQLConnectionData connData = vti.getConnectionData();
            FilePartitioner.ResolvedFilesFilterResult filterResult = FSSubgraphHelper.getInputFiles(this.inputPartitions, gcsdh);
            List<String> sourceUris = this.buildSourceUris(gcsdh, filterResult);
            SQLConnectionProvider.SQLConnectionWrapper conn = vti.newConnection();
            try {
                boolean partitioned;
                boolean bl = partitioned = this.outputDS.getPartitioningSchema().isPartitioned() && this.outputPartition != null && !this.outputPartition.isAll() && !this.outputPartition.isNP();
                if (partitioned) {
                    this.loadPartitionedData(connData, conn, sourceUris, outputTable, this.outputPartition, this.authCtx);
                } else {
                    this.loadNonPartitionedData(connData, conn, sourceUris, outputTable, this.authCtx);
                }
                conn.close();
            }
            catch (Exception e) {
                logger.error((Object)"BigQuery load failed", (Throwable)e);
                SQLUtils.unsafeRollbackAndClose(conn);
                throw e;
            }
        }
    }

    private void loadNonPartitionedData(SQLConnectionProvider.SQLConnectionData connData, SQLConnectionProvider.SQLConnectionWrapper conn, List<String> sourceUris, BigQueryClient.TableRef outputTable, AuthCtx authCtx) throws Exception {
        boolean needsTempTable = false;
        if ("parquet".equals(this.inputDS.getFormatType()) && !this.inputDS.isManaged()) {
            for (SchemaColumn sc : this.inputDS.getSchema().getColumns()) {
                SchemaColumn outputSc = this.outputDS.getSchema().getColumn(sc.getName());
                if (outputSc == null || !this.parquetTypeNeedsTempTable(sc, outputSc.getType())) continue;
                needsTempTable = true;
                break;
            }
        }
        if (needsTempTable) {
            this.loadWithTempTable(connData, conn, sourceUris, outputTable, Partition.newNP(), authCtx);
        } else {
            this.loadNonPartitionedDirectly(connData, conn, sourceUris, outputTable, authCtx);
        }
    }

    private boolean parquetTypeNeedsTempTable(SchemaColumn sc, Type outputType) {
        if ("date_day".equalsIgnoreCase(sc.originalType) && outputType != Type.DATEONLY) {
            return true;
        }
        if ("date_milli".equalsIgnoreCase(sc.originalType) && outputType != Type.DATE) {
            return true;
        }
        return "date_micro".equalsIgnoreCase(sc.originalType) && outputType != Type.DATE;
    }

    private void loadNonPartitionedDirectly(SQLConnectionProvider.SQLConnectionData connData, SQLConnectionProvider.SQLConnectionWrapper conn, List<String> sourceUris, BigQueryClient.TableRef outputTable, AuthCtx authCtx) throws Exception {
        BigQuerySQLDialect dialect = (BigQuerySQLDialect)connData.getDialect();
        BigQueryClient restClient = ((SQLConnectionProvider.BigQuerySQLConnectionData)connData).getRestClient(authCtx);
        LoadFromCloudStorageOptions options = this.buildLoadOptions(this.inputDS);
        if (this.writeMode == Output.WriteMode.APPEND) {
            InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
            dialect.createTableIfNeeded(authCtx, connData, conn, this.outputDS, false, messages);
            if (!messages.isEmpty()) {
                this.warnContext.addWarning(WarningsContext.WarningType.SQL_CREATE_QUERY_WARNING, messages.report("\n"), logger);
            }
            options.writeDisposition = WriteDisposition.WRITE_APPEND;
        } else {
            logger.info((Object)String.format("Clearing BigQuery output partition %s", this.outputPartition));
            InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
            dialect.dropAndRecreateTableOrPartition(authCtx, connData, conn, this.outputDS, Partition.newNP(), true, messages);
            if (!messages.isEmpty()) {
                this.warnContext.addWarning(WarningsContext.WarningType.SQL_CREATE_QUERY_WARNING, messages.report("\n"), logger);
            }
        }
        SQLUtils.executePreWriteStatements(connData, conn, this.outputDS);
        logger.info((Object)String.format("Loading GCS files into BigQuery with writeDisposition=%s", new Object[]{options.writeDisposition}));
        this.loadBigQuery(restClient, outputTable, sourceUris, options);
        SQLUtils.executePostWriteStatements(connData, conn, this.outputDS);
    }

    private void loadBigQuery(BigQueryClient restClient, BigQueryClient.TableRef outputTable, List<String> sourceUris, LoadFromCloudStorageOptions options) throws Exception {
        try {
            restClient.loadFromCloudStorageSync(outputTable, sourceUris, options);
        }
        catch (BigQueryException exc) {
            SQLException sqlExc = FastpathUtils.checkDateFormatError(exc, DATE_ERROR, "BigQuery");
            throw sqlExc != null ? sqlExc : exc;
        }
    }

    private void loadPartitionedData(SQLConnectionProvider.SQLConnectionData connData, SQLConnectionProvider.SQLConnectionWrapper conn, List<String> sourceUris, BigQueryClient.TableRef outputTable, Partition outputPartition, AuthCtx authCtx) throws Exception {
        this.loadWithTempTable(connData, conn, sourceUris, outputTable, outputPartition, authCtx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadWithTempTable(SQLConnectionProvider.SQLConnectionData connData, SQLConnectionProvider.SQLConnectionWrapper conn, List<String> sourceUris, BigQueryClient.TableRef outputTable, Partition outputPartition, AuthCtx authCtx) throws Exception {
        BigQuerySQLDialect dialect = (BigQuerySQLDialect)connData.getDialect();
        BigQueryClient restClient = ((SQLConnectionProvider.BigQuerySQLConnectionData)connData).getRestClient(authCtx);
        LoadFromCloudStorageOptions options = this.buildLoadOptions(this.inputDS);
        CreateTemporaryTableInfo temporaryTableInfo = new CreateTemporaryTableInfo();
        temporaryTableInfo.schema = BigQuerySchemaHandler.createBigQuerySchema(this.inputDS.getSchema());
        temporaryTableInfo.expirationTime = DateTime.now().plusHours(48).getMillis();
        TableResource temporaryTable = restClient.createTemporaryTable(outputTable.getDatasetRef(), temporaryTableInfo);
        String temporaryTableId = temporaryTable.tableReference.tableId;
        BigQueryClient.TableRef temporaryTableRef = new BigQueryClient.TableRef(outputTable.projectId, outputTable.datasetId, temporaryTableId);
        try {
            logger.info((Object)String.format("Loading GCS files into temporary BigQuery table %s", temporaryTableId));
            this.loadBigQuery(restClient, temporaryTableRef, sourceUris, options);
            logger.info((Object)String.format("Creating BigQuery table %s if needed.", outputTable));
            InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
            dialect.dropIfNeededAndCreateTableOrPartition(authCtx, connData, conn, this.outputDS, outputPartition, this.writeMode, messages);
            if (!messages.isEmpty()) {
                this.warnContext.addWarning(WarningsContext.WarningType.SQL_CREATE_QUERY_WARNING, messages.report("\n"), logger);
            }
            SQLUtils.executePreWriteStatements(connData, conn, this.outputDS);
            AbstractSQLDatasetHandler.AbstractSQLConfig outputConfig = this.outputDS.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class).getResolved(this.outputDS.getProjectKey());
            BigQueryUtils.checkPartitioningConsistency(authCtx, connData.getConnection(), outputConfig, this.outputDS.getPartitioningSchema());
            logger.info((Object)"Loading target BigQuery table from INSERT SELECT");
            String sql = this.executeInsertSelectSql(dialect, outputTable.projectId, outputTable.datasetId, temporaryTableId, outputTable.tableId, outputPartition);
            SQLUtils.safeExec(conn, sql, true);
            SQLUtils.executePostWriteStatements(connData, conn, this.outputDS);
        }
        catch (Throwable throwable) {
            try {
                restClient.deleteTableIfExist(temporaryTableRef);
            }
            catch (BigQueryException e) {
                logger.warn((Object)String.format("Unable to delete temporary BigQuery table %s", temporaryTableRef), (Throwable)e);
            }
            throw throwable;
        }
        try {
            restClient.deleteTableIfExist(temporaryTableRef);
        }
        catch (BigQueryException e) {
            logger.warn((Object)String.format("Unable to delete temporary BigQuery table %s", temporaryTableRef), (Throwable)e);
        }
    }

    @Override
    public void initForAutoFastPath(AuthCtx authCtx, WarningsContext warnContext, Dataset cloudDataset, Partition cloudPartition, Dataset bigqueryDataset, Output.WriteMode writeMode) throws Exception {
        this.outputDS = bigqueryDataset;
        this.inputDS = cloudDataset;
        this.contextProjectKey = bigqueryDataset.getProjectKey();
        this.inputPartitions = Lists.newArrayList((Object[])new Partition[]{cloudPartition});
        this.outputPartition = cloudPartition;
        this.writeMode = writeMode;
        this.authCtx = authCtx;
        this.warnContext = warnContext;
        this.clearOutputPartitionsIfNeeded();
    }

    private String castConstant(Type t, String constant, BigQuerySQLDialect dialect) {
        return new ExpressionBuilder.ExpressionBuilderFactory().cst(constant).cast(t).toSQL(dialect);
    }

    private String castColumn(Type t, String column, BigQuerySQLDialect dialect) {
        return new ExpressionBuilder.ExpressionBuilderFactory().col(column).cast(t).toSQL(dialect);
    }

    private static List<String> quoteColumnNames(List<String> columnNames, BigQuerySQLDialect dialect) {
        return columnNames.stream().map(c2 -> dialect.quoteIdentifier((String)c2)).collect(Collectors.toList());
    }

    private String executeInsertSelectSql(BigQuerySQLDialect dialect, String projectId, String datasetId, String temporaryTableId, String targetTableId, Partition partition) {
        ImmutableList<String> inputColumnNames = GCSToBigQuery.getColumnNames(this.inputDS);
        ImmutableList<String> outputColumnNames = GCSToBigQuery.getColumnNames(this.outputDS);
        ArrayList<Object> selectColumnNames = new ArrayList<Object>();
        for (String columnName : outputColumnNames) {
            Type outputType = this.outputDS.getSchema().getColumn(columnName).getType();
            if (this.outputPartition != null && this.outputPartition.getDimensionValues().containsKey(columnName)) {
                String constant = ExpressionUtils.getStringForDimensionValue((DimensionValue)partition.getDimensionValues().get(columnName), outputType);
                selectColumnNames.add(this.castConstant(outputType, constant, dialect) + " AS " + dialect.quoteIdentifier(columnName));
                continue;
            }
            if (inputColumnNames.contains(columnName)) {
                SchemaColumn sc = this.inputDS.getSchema().getColumn(columnName);
                boolean castToOutputType = false;
                if ("parquet".equals(this.inputDS.getFormatType()) && !this.inputDS.isManaged() && this.parquetTypeNeedsTempTable(sc, outputType)) {
                    castToOutputType = true;
                }
                if ("parquet".equals(this.inputDS.getFormatType()) && this.inputDS.isManaged()) {
                    boolean bl = castToOutputType = outputType == Type.DATETIMENOTZ;
                }
                if (castToOutputType) {
                    logger.info((Object)("Need to cast " + columnName + " as " + String.valueOf(outputType)));
                    selectColumnNames.add(this.castColumn(outputType, columnName, dialect) + " AS " + dialect.quoteIdentifier(columnName));
                    continue;
                }
                selectColumnNames.add(dialect.quoteIdentifier(columnName));
                continue;
            }
            throw new IllegalStateException("Missing column: " + columnName + " in input dataset");
        }
        return "INSERT " + dialect.getQuotedTableFullName(projectId, datasetId, targetTableId) + " (" + Joiner.on((String)",").join(GCSToBigQuery.quoteColumnNames(outputColumnNames, dialect)) + ")\nSELECT " + Joiner.on((String)",").join(selectColumnNames) + "\nFROM " + dialect.getQuotedTableFullName(projectId, datasetId, temporaryTableId);
    }

    private LoadFromCloudStorageOptions buildLoadOptions(Dataset dataset) {
        switch (dataset.getFormatType()) {
            case "csv": {
                CSVFormatConfig config = dataset.getFormatParamsAs(CSVFormatConfig.class);
                CompatibilityCheck check = GCSToBigQuery.isCsvSupported(config);
                if (!check.isOk()) {
                    throw new IllegalStateException(check.errorMessage);
                }
                LoadCsvFromCloudStorageOptions options = new LoadCsvFromCloudStorageOptions();
                options.autodetect = false;
                options.fieldDelimiter = config.getSeparatorChar();
                options.quote = config.getQuoteChar();
                options.allowQuotedNewlines = config.style != CSVFormatConfig.CSVStyle.NO_ESCAPE_NO_QUOTE;
                options.skipLeadingRows = config.skipRowsAfterHeader + config.skipRowsBeforeHeader + (config.parseHeaderRow ? 1 : 0);
                return options;
            }
            case "avro": {
                return new LoadAvroFromCloudStorageOptions();
            }
            case "orcfile": {
                return new LoadORCFromCloudStorageOptions();
            }
            case "parquet": {
                return new LoadParquetFromCloudStorageOptions();
            }
        }
        throw new IllegalStateException("Unhandled dataset format type: " + dataset.getFormatType());
    }

    private List<String> buildSourceUris(GCSDatasetHandler gcsDatasetHandler, FilePartitioner.ResolvedFilesFilterResult filterResult) throws IOException, DKUSecurityException, CodedException {
        String rootPath = gcsDatasetHandler.getProviderRootPath();
        if (rootPath.endsWith("/")) {
            rootPath = rootPath.substring(0, rootPath.length() - 1);
        }
        ArrayList<String> sourceUris = new ArrayList<String>();
        for (FSPath fsPath : filterResult.getAllPaths()) {
            String uri = rootPath + fsPath.path();
            logger.debug((Object)("Adding file to sourceUris: " + uri));
            sourceUris.add(uri);
        }
        return sourceUris;
    }

    private static ImmutableList<String> getColumnNames(Dataset dataset) {
        return FluentIterable.from((Iterable)dataset.getSchema().getColumns()).transform((Function)new Function<SchemaColumn, String>(){

            public String apply(SchemaColumn input) {
                return input.getName();
            }
        }).toList();
    }

    private static CompatibilityCheck isCompatible(Dataset inputDS, Dataset outputDS, SerializedRecipe.RecipeOutput recipeOutput) {
        if (!new FastPathDatasetTypeStraightener().isEquivalentTo(inputDS, "GCS")) {
            return CompatibilityCheck.unsupported("Input dataset is not in Google Cloud Storage");
        }
        DatasetHandler.DatasetMeta<?, ?> outputMeta = DatasetHandlerFactory.getMeta(outputDS);
        if (outputMeta != BuiltinSQLDatasets.BIGQUERY_META) {
            return CompatibilityCheck.unsupported("Output dataset is not in Google BigQuery");
        }
        switch (inputDS.getFormatType()) {
            case "csv": {
                CSVFormatConfig csvFormatConfig = inputDS.getFormatParamsAs(CSVFormatConfig.class);
                return GCSToBigQuery.isCsvSupported(csvFormatConfig);
            }
            case "avro": {
                return CompatibilityCheck.ok();
            }
            case "orcfile": {
                return CompatibilityCheck.ok();
            }
            case "parquet": {
                return CompatibilityCheck.ok();
            }
        }
        return CompatibilityCheck.unsupported("Input format not supported: " + inputDS.getFormatType());
    }

    private static CompatibilityCheck isCsvSupported(CSVFormatConfig config) {
        char separatorChar;
        if (!StringUtils.isUtf8((String)config.charset)) {
            return CompatibilityCheck.unsupported("Input charset not supported: " + config.charset);
        }
        switch (config.style) {
            case EXCEL: {
                if (config.getQuoteChar() != '\u0000' && config.getQuoteChar() <= '\u007f') break;
                return CompatibilityCheck.unsupported("Input quoting character not supported: '" + config.getQuoteChar() + "'");
            }
            case NO_ESCAPE_NO_QUOTE: {
                break;
            }
            case UNIX: {
                return CompatibilityCheck.unsupported("Unix quoting style not supported by Google BigQuery loader.");
            }
            case ESCAPE_ONLY_NO_QUOTE: {
                return CompatibilityCheck.unsupported("Escape style not supported by Google BigQuery loader.");
            }
            default: {
                return CompatibilityCheck.unsupported("Unexpected CSVStyle: " + String.valueOf((Object)config.style));
            }
        }
        if ((separatorChar = config.getSeparatorChar()) == '\u0000' || separatorChar > '\u007f') {
            return CompatibilityCheck.unsupported("input separator not supported: '" + config.getSeparatorStr() + "'");
        }
        return CompatibilityCheck.ok();
    }

    private static class CompatibilityCheck {
        public String errorMessage;

        private CompatibilityCheck() {
        }

        public static CompatibilityCheck ok() {
            return new CompatibilityCheck();
        }

        public static CompatibilityCheck unsupported(String errorMessage) {
            CompatibilityCheck result = new CompatibilityCheck();
            result.errorMessage = (String)Preconditions.checkNotNull((Object)errorMessage);
            return result;
        }

        public boolean isOk() {
            return this.errorMessage == null;
        }
    }
}

