/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.export;

import com.dataiku.dip.dataflow.export.execution.FlowEnrichedExport;
import com.dataiku.dip.dataflow.export.execution.FlowExportPostProcessor;
import com.dataiku.dip.dataflow.export.execution.FlowExportScriptRunner;
import com.dataiku.dip.dataflow.export.model.FlowExport;
import com.dataiku.dip.dataflow.export.model.FlowExportFormat;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.graphicsexport.BaseExportService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.server.notifications.HrefContext;
import com.dataiku.dip.server.services.InternalAPIKeysService;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang3.Range;
import org.springframework.stereotype.Service;

@Service
public class FlowExportService
extends BaseExportService<FlowExport, FlowExportFormat, FlowEnrichedExport> {
    @Override
    protected BaseExportService.ExportFutureThread newFutureThread(AuthCtx user, FlowExport export) throws IOException, DKUSecurityException {
        return new FlowExportFutureThread(user, (FlowEnrichedExport)this.checkAndEnrichExport(user, export, Privileges.ProjectLevelPrivilegeType.READ_CONF));
    }

    @Override
    protected FlowEnrichedExport checkAndEnrichExport(FlowExport export, HrefContext hrefContext, boolean browserSandBoxing) {
        String flowUrl = hrefContext.flow(export.projectKey);
        FlowExportFormat enrichExportFormat = this.checkAndEnrichExportFormat((FlowExportFormat)export.format, FlowExport.SCREEN_RANGE_W, FlowExport.SCREEN_RANGE_H);
        return new FlowEnrichedExport(export, enrichExportFormat, browserSandBoxing, flowUrl);
    }

    @Override
    public FlowExportFormat checkAndEnrichExportFormat(FlowExportFormat format, Range<Integer> widthRange, Range<Integer> heightRange) {
        Preconditions.checkArgument((format.tileScale >= 0.0 ? 1 : 0) != 0, (Object)"Tile scale factor must be a positive number, or zero to set it to auto");
        FlowExportFormat result = super.checkAndEnrichExportFormat(format, widthRange, heightRange);
        result.tileScale = format.tileScale;
        result.drawZones = format.drawZones;
        result.collapsedZones = format.collapsedZones;
        result.searchQuery = format.searchQuery;
        return result;
    }

    @Override
    protected FlowExportFormat newExportFormat() {
        return new FlowExportFormat();
    }

    private class FlowExportFutureThread
    extends BaseExportService.ExportFutureThread {
        public FlowExportFutureThread(AuthCtx user, FlowEnrichedExport export) {
            super(FlowExportService.this, user, export);
        }

        @Override
        protected String getTitle() {
            return "Exporting Flow graph";
        }

        @Override
        protected int getExportTargetCount() {
            return -1;
        }

        @Override
        protected File postProcessGeneratedFiles(File rawExportDirectory, File postProcessDirectory, File finalExportDirectory) throws Exception {
            return new FlowExportPostProcessor((FlowEnrichedExport)this.export, rawExportDirectory, postProcessDirectory, finalExportDirectory).execute();
        }

        @Override
        protected void executeScript(InternalAPIKeysService.APIKey key, File rawExportDirectory, FutureProgressState progressState) throws IOException, InterruptedException {
            new FlowExportScriptRunner((FlowEnrichedExport)this.export, rawExportDirectory, key).execute();
        }

        @Override
        protected FuturePayload buildExportFuturePayload() {
            return this.buildExportFuturePayload("flow", this.export.format.fileType.toString());
        }
    }
}

