/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.pipeline;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.sql.SQLQueryRecipeMeta;
import com.dataiku.dip.dataflow.pipeline.AbstractSqlQueryRecipePipelineHelper;
import com.dataiku.dip.dataflow.pipeline.RecipePipelineHelper;
import com.dataiku.dip.dataflow.pipeline.SparkPipelineDef;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.recipes.AbstractSparkRecipeParams;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.shaker.resources.ResourcesGatherer;
import com.dataiku.dip.spark.SparkOverrideConfig;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SparkSQLDialect;
import com.dataiku.dip.util.AnyLoc;
import java.io.IOException;
import java.sql.SQLException;
import org.springframework.beans.factory.annotation.Autowired;

public class SqlQueryRecipePipelineHelper
extends AbstractSqlQueryRecipePipelineHelper {
    @Autowired
    private DatasetsDAO datasetsDAO;
    private SQLQueryRecipeMeta.SQLQueryRecipeParams params;

    public SqlQueryRecipePipelineHelper(AuthCtx authCtx, SerializedRecipe recipe, String payload, RecipePipelineHelper.PipelineType pipelineType, JobActivity jobActivity) {
        super(authCtx, recipe, payload, pipelineType, jobActivity);
    }

    @Override
    protected void initializeForSpark() {
        this.isValidConfiguration = false;
    }

    @Override
    protected void initializeForSql() {
        SpringUtils.getInstance().autowire((Object)this);
        this.isValidConfiguration = false;
        String outRef = this.recipe.getSingleOutput((String)"main").ref;
        AnyLoc loc = AnyLoc.resolveSmart(this.recipe.projectKey, outRef);
        try {
            Dataset dataset = Dataset.fromSerialized((SerializedDataset)this.datasetsDAO.getMandatory(loc));
            this.dialect = DatasetInspector.getDSSConnectionForSQLOrHiveDataset(this.authCtx, dataset).getDialect();
            this.params = this.recipe.getParamsAs(SQLQueryRecipeMeta.SQLQueryRecipeParams.class);
            if (this.params != null) {
                this.allowPipelineStart = this.params.sqlPipelineParams.pipelineAllowStart;
                this.allowPipelineMerge = this.params.sqlPipelineParams.pipelineAllowMerge;
                this.isValidConfiguration = true;
                if (this.params.variablesExpansionLoopConfig.isEnabled()) {
                    logger.infoV("Recipe %s is repeating, setting as not pipelineable", new Object[]{this.recipe.getDisplayName()});
                    this.isValidConfiguration = false;
                }
            }
        }
        catch (DKUSecurityException | IOException | SQLException e) {
            logger.warnV(e, "Unable to get dialect of SQL query recipe: %s, setting recipe as not pipelineable", new Object[]{this.recipe.getDisplayName()});
        }
    }

    @Override
    protected String generateSqlQuery(JobActivity activity, SQLDialect dialect) {
        return this.payload;
    }

    @Override
    boolean canSetSparkPipelineability() {
        return false;
    }

    @Override
    String setSparkPipelineability(boolean allowStart, boolean allowMerge) {
        throw new IllegalStateException("Should not come here");
    }

    @Override
    String setSqlPipelineability(boolean allowStart, boolean allowMerge) {
        throw new IllegalStateException("Should not come here");
    }

    @Override
    public String setPipelineability(boolean allowStart, boolean allowMerge) {
        this.params.sqlPipelineParams.pipelineAllowStart = allowStart;
        this.params.sqlPipelineParams.pipelineAllowMerge = allowMerge;
        return this.payload;
    }

    @Override
    protected String getEngineType() {
        return "SQL";
    }

    @Override
    protected boolean useGlobalMetastore() {
        throw new IllegalStateException("SqlQueryRecipe has no metastore.");
    }

    @Override
    protected void finalizeElt(SparkPipelineDef.SparkPipelineElt elt, JobActivity activity, SparkSQLDialect dialect, ResourcesGatherer gatherer) {
        throw new IllegalStateException("SqlQueryRecipe has no element to build.");
    }

    @Override
    protected SparkOverrideConfig sparkConfig() {
        throw new IllegalStateException("SqlQueryRecipe has no spark config.");
    }

    @Override
    protected AbstractSparkRecipeParams.SparkExecutionEngine sparkExecutionEngine() {
        throw new IllegalStateException("SqlQueryRecipe has no execution engine.");
    }
}

