/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataquality;

import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.metrics.checks.AbstractCheckContext;
import com.dataiku.dip.server.services.ReadOnlyJobsInternalDB;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public abstract class ReadMetricValueHelper {
    private static void checkMetricHasValue(ReadOnlyJobsInternalDB.MetricDataPoint metricValue) throws ReadMetricError {
        if (metricValue == null) {
            throw new ReadMetricError(AbstractCheckContext.CheckOutcome.EMPTY, "Cannot check: no value");
        }
        if (metricValue.value == null) {
            throw new ReadMetricError(AbstractCheckContext.CheckOutcome.EMPTY, "Cannot check: empty value");
        }
    }

    private static void checkMetricValueNotEmpty(ReadOnlyJobsInternalDB.MetricDataPoint metricValue) throws ReadMetricError {
        if (StringUtils.isEmpty((String)metricValue.value)) {
            throw new ReadMetricError(AbstractCheckContext.CheckOutcome.EMPTY, "Cannot check: empty value");
        }
    }

    public static void checkMetricIsNumeric(ReadOnlyJobsInternalDB.MetricDataPoint metricValue) throws ReadMetricError {
        ReadMetricValueHelper.checkMetricHasValue(metricValue);
        if (!metricValue.type.isNumeric()) {
            throw new ReadMetricError(AbstractCheckContext.CheckOutcome.WARNING, "Cannot check: " + String.valueOf(metricValue.type) + " is not numeric");
        }
        ReadMetricValueHelper.checkMetricValueNotEmpty(metricValue);
    }

    public static void checkMetricIsInteger(ReadOnlyJobsInternalDB.MetricDataPoint metricValue) throws ReadMetricError {
        ReadMetricValueHelper.checkMetricHasValue(metricValue);
        if (!metricValue.type.isInteger()) {
            throw new ReadMetricError(AbstractCheckContext.CheckOutcome.WARNING, "Cannot check: " + String.valueOf(metricValue.type) + " is not integer");
        }
        ReadMetricValueHelper.checkMetricValueNotEmpty(metricValue);
    }

    public static void checkMetricIsArray(ReadOnlyJobsInternalDB.MetricDataPoint metricValue) throws ReadMetricError {
        ReadMetricValueHelper.checkMetricHasValue(metricValue);
        if (!metricValue.type.isCompatibleWith(Type.ARRAY)) {
            throw new ReadMetricError(AbstractCheckContext.CheckOutcome.WARNING, "Cannot check: " + String.valueOf(metricValue.type) + " is not an array");
        }
        ReadMetricValueHelper.checkMetricValueNotEmpty(metricValue);
    }

    public static double readDoubleMetricsValue(AbstractCheckContext context, String metricId) throws Exception {
        ReadOnlyJobsInternalDB.MetricDataPoint metricValue = context.getCurrentValue(metricId);
        ReadMetricValueHelper.checkMetricIsNumeric(metricValue);
        return Double.parseDouble(metricValue.value);
    }

    public static long readLongMetricsValue(AbstractCheckContext context, String metricId) throws Exception {
        ReadOnlyJobsInternalDB.MetricDataPoint metricValue = context.getCurrentValue(metricId);
        ReadMetricValueHelper.checkMetricIsInteger(metricValue);
        return Long.parseLong(metricValue.value);
    }

    public static List<String> readStringArrayMetricsValue(AbstractCheckContext context, String metricId) throws Exception {
        ReadOnlyJobsInternalDB.MetricDataPoint metricValue = context.getCurrentValue(metricId);
        ReadMetricValueHelper.checkMetricIsArray(metricValue);
        try {
            return (List)JSON.parse((String)metricValue.value, (TypeToken)new TypeToken<List<String>>(){});
        }
        catch (JsonSyntaxException e) {
            throw new ReadMetricError(AbstractCheckContext.CheckOutcome.WARNING, "Cannot read metric value: it is not valid json array");
        }
    }

    public static Map<String, Long> readLongMapMetricsValue(AbstractCheckContext context, String metricId) throws Exception {
        ReadOnlyJobsInternalDB.MetricDataPoint metricValue = context.getCurrentValue(metricId);
        ReadMetricValueHelper.checkMetricIsArray(metricValue);
        try {
            return (Map)JSON.parse((String)metricValue.value, (TypeToken)new TypeToken<Map<String, Long>>(){});
        }
        catch (JsonSyntaxException e) {
            throw new ReadMetricError(AbstractCheckContext.CheckOutcome.WARNING, "Cannot read metric value: it is not a valid JSON object");
        }
    }

    public static class ReadMetricError
    extends Exception {
        public final AbstractCheckContext.CheckOutcome outcome;
        public final String message;

        ReadMetricError(AbstractCheckContext.CheckOutcome outcome, String message) {
            this.outcome = outcome;
            this.message = message;
        }
    }
}

