/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataquality.rules;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dataquality.RuleValidationError;
import com.dataiku.dip.dataquality.rules.AbstractNewDataQualityRule;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.metrics.MetricsComputationService;
import com.dataiku.dip.metrics.checks.AbstractCheckContext;
import com.dataiku.dip.metrics.checks.DatasetCheckContext;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dss.shadelib.com.google.gson.Gson;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractDatasetSchemaRule
extends AbstractNewDataQualityRule {
    protected Schema expectedSchema;

    public Schema getExpectedSchema() {
        return this.expectedSchema;
    }

    @Override
    public AbstractCheckContext.CheckResult run(AuthCtx authCtx, AbstractCheckContext context, MetricsComputationService.MetricsCheckRunReport runReport) throws Exception {
        Dataset dataset = ((DatasetCheckContext)context).getDataset();
        Schema actualSchema = dataset.getSchema();
        Map<String, Map<String, Object>> results = this.computeSchemaResults(this.getExpectedSchema(), actualSchema);
        boolean hasErrors = results.values().stream().anyMatch(r -> "ERROR".equals(r.get("outcome")));
        return new AbstractCheckContext.CheckResult(hasErrors ? AbstractCheckContext.CheckOutcome.ERROR : AbstractCheckContext.CheckOutcome.OK, new Gson().toJson(results));
    }

    protected Map<String, Map<String, Object>> computeSchemaResults(Schema expected, Schema actual) {
        return new SchemaComparisonRunner(expected, actual, this).run();
    }

    protected abstract boolean shouldCheckExtraColumns();

    protected abstract boolean shouldCheckColumnOrder();

    protected abstract boolean shouldFailOnMissingColumns();

    @Override
    public RuleValidationError verifyConfig(Dataset dataset) {
        if (this.getExpectedSchema() == null || this.getExpectedSchema().columns.isEmpty()) {
            return new RuleValidationError("Expected schema cannot be empty");
        }
        List<String> duplicateColumns = this.getExpectedSchema().columns.stream().collect(Collectors.groupingBy(SchemaColumn::getName, Collectors.counting())).entrySet().stream().filter(e -> (Long)e.getValue() > 1L).map(Map.Entry::getKey).toList();
        if (!duplicateColumns.isEmpty()) {
            boolean isPlural = duplicateColumns.size() > 1;
            return new RuleValidationError("The following column" + (isPlural ? "s are" : " is") + " duplicated in the expected schema: " + String.join((CharSequence)",", duplicateColumns));
        }
        return null;
    }

    @Override
    public RuleValidationError verifyPreConditions(Dataset dataset, List<MetricsComputationService.ValuedMetric> computedMetrics) {
        return null;
    }

    private static class SchemaComparisonRunner {
        private final Schema expected;
        private final Schema actual;
        private final AbstractDatasetSchemaRule rule;
        private final Map<String, Map<String, Object>> results = new HashMap<String, Map<String, Object>>();
        private final Map<String, SchemaColumn> actualColsByName;
        private final List<String> expectedCommonOrder = new ArrayList<String>();
        private final List<String> expectedNames = new ArrayList<String>();

        public SchemaComparisonRunner(Schema expected, Schema actual, AbstractDatasetSchemaRule rule) {
            this.expected = expected;
            this.actual = actual;
            this.rule = rule;
            this.actualColsByName = actual.columns.stream().collect(Collectors.toMap(SchemaColumn::getName, Function.identity()));
        }

        public Map<String, Map<String, Object>> run() {
            this.handleExpectedColumns();
            if (this.rule.shouldCheckExtraColumns()) {
                this.handleExtraColumns();
            }
            if (this.rule.shouldCheckColumnOrder()) {
                this.checkColumnOrder();
            }
            return this.results;
        }

        private void handleExpectedColumns() {
            for (int i = 0; i < this.expected.columns.size(); ++i) {
                SchemaColumn expectedCol = (SchemaColumn)this.expected.columns.get(i);
                this.expectedNames.add(expectedCol.getName());
                SchemaColumn actualCol = this.actualColsByName.get(expectedCol.getName());
                if (actualCol == null) {
                    if (!this.rule.shouldFailOnMissingColumns()) continue;
                    this.appendResult(expectedCol.getName(), AbstractCheckContext.CheckOutcome.ERROR, "Missing column", i + 1);
                    continue;
                }
                this.expectedCommonOrder.add(expectedCol.getName());
                List<String> issues = this.compareSchemaColumn(expectedCol, actualCol, i + 1, new NestedPathContext(), true);
                if (issues.isEmpty()) {
                    this.appendResult(expectedCol.getName(), AbstractCheckContext.CheckOutcome.OK, "", i + 1);
                    continue;
                }
                this.appendResult(expectedCol.getName(), AbstractCheckContext.CheckOutcome.ERROR, String.join((CharSequence)"\n", issues.size() > 1 ? issues.stream().map(issue -> "- " + issue).toList() : issues), i + 1);
            }
        }

        private void handleExtraColumns() {
            for (SchemaColumn actualCol : this.actual.columns) {
                if (this.expected.getColumn(actualCol.getName()) != null) continue;
                this.appendResult(actualCol.getName(), AbstractCheckContext.CheckOutcome.ERROR, "Unexpected column", null);
            }
        }

        private void checkColumnOrder() {
            HashSet<String> expectedSet = new HashSet<String>(this.expectedCommonOrder);
            List<String> actualOrder = this.actual.columns.stream().map(SchemaColumn::getName).filter(expectedSet::contains).toList();
            Map expectedPos = IntStream.range(0, this.expectedCommonOrder.size()).boxed().collect(Collectors.toMap(this.expectedCommonOrder::get, Function.identity()));
            if (this.expectedCommonOrder.equals(actualOrder)) {
                return;
            }
            HashSet<String> columnsWithOrderErrors = new HashSet<String>();
            int maxSeenExpectedPos = -1;
            String lastCorrectColumn = null;
            for (String currentCol : actualOrder) {
                int currentExpectedPos = (Integer)expectedPos.get(currentCol);
                if (currentExpectedPos < maxSeenExpectedPos) {
                    if (columnsWithOrderErrors.contains(currentCol)) continue;
                    this.appendResult(currentCol, AbstractCheckContext.CheckOutcome.ERROR, String.format("Wrong order: should be before column %s", lastCorrectColumn), this.expectedNames.indexOf(currentCol) + 1);
                    columnsWithOrderErrors.add(currentCol);
                    columnsWithOrderErrors.add(lastCorrectColumn);
                    continue;
                }
                maxSeenExpectedPos = currentExpectedPos;
                lastCorrectColumn = currentCol;
            }
        }

        private void appendResult(String col, AbstractCheckContext.CheckOutcome outcome, String msg, Integer expectedIndex) {
            HashMap<String, Object> enrichedResult = new HashMap<String, Object>();
            enrichedResult.put("outcome", outcome.name());
            enrichedResult.put("message", msg);
            if (expectedIndex != null) {
                enrichedResult.put("index", expectedIndex);
            }
            if (this.results.containsKey(col)) {
                Map<String, Object> existing = this.results.get(col);
                String existingMsg = (String)existing.get("message");
                String newMsg = existingMsg.isBlank() ? msg : existingMsg + "\n" + msg;
                enrichedResult.put("message", newMsg);
            }
            this.results.put(col, enrichedResult);
        }

        private List<String> compareSchemaColumn(SchemaColumn expected, SchemaColumn actual, int order, NestedPathContext context, boolean isRoot) {
            return this.compareSchemaColumn(expected, actual, null, order, context, isRoot);
        }

        private List<String> compareSchemaColumn(SchemaColumn expected, SchemaColumn actual, String fieldLabel, int order, NestedPathContext context, boolean isRoot) {
            if (expected == null && actual == null) {
                return List.of();
            }
            ArrayList<String> issues = new ArrayList<String>();
            if (expected == null || actual == null) {
                String contextFormatted;
                String label = fieldLabel != null ? fieldLabel : "schema element";
                String string = contextFormatted = context.isEmpty() ? "" : String.format("for %s ", context.formatErrorPath(null));
                if (expected == null && !Type.STRING.equals((Object)actual.getType())) {
                    issues.add(String.format("Expected %s is null %s(actual: %s)", label, contextFormatted, actual.getType()));
                }
                if (actual == null && !Type.STRING.equals((Object)expected.getType())) {
                    issues.add(String.format("Actual %s is null %s(expected: %s)", label, contextFormatted, expected.getType()));
                }
                return issues;
            }
            if (expected.getType().equals((Object)actual.getType())) {
                if (this.isComplexType(expected.getType())) {
                    issues.addAll(this.compareComplexType(expected, actual, order, context));
                } else {
                    issues.addAll(this.compareBasicType(expected, actual, context));
                }
            } else {
                String contextFormatted = context.isEmpty() ? "" : String.format("for %s ", context.formatErrorPath(expected.getName()));
                issues.add(String.format("Type mismatch %s(expected: %s, actual: %s)", contextFormatted, expected.getType(), actual.getType()));
            }
            if (isRoot && expected.getMeaning() != null && !expected.getMeaning().equals(actual.getMeaning())) {
                issues.add(String.format("Meaning mismatch (expected: %s, actual: %s)", expected.getMeaning(), StringUtils.firstNonBlank((CharSequence[])new String[]{actual.getMeaning(), "Auto-detect"})));
            }
            return issues;
        }

        private List<String> compareComplexType(SchemaColumn expected, SchemaColumn actual, int order, NestedPathContext context) {
            ArrayList<String> issues = new ArrayList<String>();
            switch (expected.getType()) {
                case ARRAY: {
                    issues.addAll(this.compareSchemaColumn(expected.arrayContent, actual.arrayContent, "array content", order, context.extendFor("array", expected.getName()), false));
                    break;
                }
                case MAP: {
                    SchemaColumn expectedValues;
                    SchemaColumn expectedKeys = expected.mapKeys != null ? new SchemaColumn(expected.mapKeys) : null;
                    SchemaColumn schemaColumn = expectedValues = expected.mapValues != null ? new SchemaColumn(expected.mapValues) : null;
                    if (expectedKeys != null) {
                        expectedKeys.setName("keys");
                    }
                    if (expectedValues != null) {
                        expectedValues.setName("values");
                    }
                    issues.addAll(this.compareSchemaColumn(expectedKeys, actual.mapKeys, "map keys", order, context.extendFor("map", expected.getName()), false));
                    issues.addAll(this.compareSchemaColumn(expectedValues, actual.mapValues, "map values", order, context.extendFor("map", expected.getName()), false));
                    break;
                }
                case OBJECT: {
                    issues.addAll(this.compareObjectFields(expected, actual, order, context.extendFor("object", expected.getName())));
                    break;
                }
            }
            return issues;
        }

        private List<String> compareBasicType(SchemaColumn expected, SchemaColumn actual, NestedPathContext context) {
            if (Type.STRING.equals((Object)expected.getType()) && expected.getMaxLength() != actual.getMaxLength()) {
                String contextFormatted = context.isEmpty() ? "" : String.format("for %s ", context.formatErrorPath(expected.getName()));
                return List.of(String.format("Max string length mismatch %s(expected: %d, actual: %d)", contextFormatted, expected.getMaxLength(), actual.getMaxLength()));
            }
            return List.of();
        }

        private List<String> compareObjectFields(SchemaColumn expected, SchemaColumn actual, int order, NestedPathContext context) {
            ArrayList<String> issues = new ArrayList<String>();
            List expectedFields = expected.objectFields != null ? expected.objectFields : new ArrayList();
            List actualFields = actual.objectFields != null ? actual.objectFields : new ArrayList();
            Map expectedFieldMap = expectedFields.stream().collect(Collectors.toMap(SchemaColumn::getName, Function.identity()));
            Map actualFieldMap = actualFields.stream().collect(Collectors.toMap(SchemaColumn::getName, Function.identity()));
            for (SchemaColumn expectedField : expectedFields) {
                SchemaColumn actualField = (SchemaColumn)actualFieldMap.get(expectedField.getName());
                if (actualField == null) {
                    issues.add(String.format("Missing field %s in %s", expectedField.getName(), context.formatErrorPath(null)));
                    continue;
                }
                issues.addAll(this.compareSchemaColumn(expectedField, actualField, order, context, false));
            }
            for (SchemaColumn actualField : actualFields) {
                if (expectedFieldMap.containsKey(actualField.getName())) continue;
                issues.add(String.format("Unexpected object %s in %s", actualField.getName(), context.formatErrorPath(null)));
            }
            return issues;
        }

        private boolean isComplexType(Type type) {
            return Type.ARRAY.equals((Object)type) || Type.MAP.equals((Object)type) || Type.OBJECT.equals((Object)type);
        }
    }

    protected static class NestedPathContext {
        private final String pathPrefix;
        private final String pathSuffix;

        public NestedPathContext() {
            this("", "");
        }

        private NestedPathContext(String pathPrefix, String pathSuffix) {
            this.pathPrefix = pathPrefix;
            this.pathSuffix = pathSuffix;
        }

        public NestedPathContext extendFor(String type, String fieldName) {
            String prefix = type + "<";
            String suffix = ">";
            if (this.isEmpty()) {
                return new NestedPathContext(prefix, suffix);
            }
            return new NestedPathContext(this.pathPrefix + (String)(fieldName != null ? fieldName + ": " : "") + prefix, suffix + this.pathSuffix);
        }

        public String formatErrorPath(String fieldName) {
            if (this.isEmpty()) {
                return "";
            }
            return this.pathPrefix + (fieldName != null ? fieldName : "...") + this.pathSuffix;
        }

        public boolean isEmpty() {
            return this.pathPrefix.isEmpty();
        }
    }
}

