/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.dynamodb;

import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DynamoDBConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datasets.dynamodb.DynamoDBConnectionWrapper;
import com.dataiku.dip.datasets.dynamodb.DynamoDBDatasetHandler;
import com.dataiku.dip.datasets.dynamodb.DynamoDBTypeConverter;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.output.OutputWriter;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.warnings.WarningsContext;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.dynamodb.model.AttributeDefinition;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.dynamodb.model.BatchWriteItemRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.dynamodb.model.BillingMode;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.dynamodb.model.CreateGlobalSecondaryIndexAction;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.dynamodb.model.CreateTableRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.dynamodb.model.DescribeTableResponse;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.dynamodb.model.DynamoDbException;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexDescription;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexUpdate;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.dynamodb.model.IndexStatus;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.dynamodb.model.KeySchemaElement;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.dynamodb.model.KeyType;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.dynamodb.model.ProjectionType;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.dynamodb.model.ResourceInUseException;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.dynamodb.model.ScalarAttributeType;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.dynamodb.model.ScanRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.dynamodb.model.ScanResponse;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.dynamodb.model.TableDescription;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.dynamodb.model.UpdateTableRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.dynamodb.model.WriteRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.dynamodb.waiters.DynamoDbWaiter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class DynamoDBOutput
implements Output {
    private final Dataset dataset;
    private final Partition targetPartition;
    private final WarningsContext warnContext;
    private final AuthCtx authCtx;
    protected static DKULogger logger = DKULogger.getLogger((String)"dku.dynamodb");

    public DynamoDBOutput(AuthCtx authCtx, Dataset dataset, Partition targetPartition, WarningsContext wc) {
        assert (dataset.getType().equals("DynamoDB"));
        this.dataset = dataset;
        this.targetPartition = targetPartition;
        this.warnContext = wc;
        this.authCtx = authCtx;
    }

    public OutputWriter getWriter(Output.WriteMode writeMode) throws IOException, CodedException {
        try {
            return new DynamoDBOutputWriter(ConnectionsDAO.get(), writeMode);
        }
        catch (DKUSecurityException e) {
            throw new IOException("Failed to create writer", e);
        }
    }

    public class DynamoDBOutputWriter
    extends OutputWriter {
        private final DynamoDBConnectionWrapper dynamoConn;
        private final String tableName;
        private TableDescription tableDescription;
        private int count = 0;
        protected static final String __DKU_DYNAMODB_INTERNAL_ID__ = "__dku_id__";
        private ColumnFactory cf;
        private List<SchemaColumn> schemaColumns;
        private SchemaColumn partitioningColumn;
        private final List<WriteRequest> writeRequests = new ArrayList<WriteRequest>();
        protected static final long MAX_BATCH_SIZE = 25L;
        private final Output.WriteMode writeMode;
        private final DynamoDBTypeConverter typeConverter = new DynamoDBTypeConverter();
        private final DynamoDBDatasetHandler.Config datasetConfig;

        public DynamoDBOutputWriter(ConnectionsDAO connectionsDAO, Output.WriteMode writeMode) throws IOException, DKUSecurityException, CodedException {
            String connectionName = DynamoDBOutput.this.dataset.getParamsAs(DynamoDBDatasetHandler.Config.class).connection;
            this.tableName = DynamoDBOutput.this.dataset.getParamsAs(DynamoDBDatasetHandler.Config.class).table;
            logger.info((Object)("Connecting to database, connection=" + connectionName + " table : " + this.tableName));
            this.dynamoConn = DynamoDBConnectionWrapper.get(DynamoDBOutput.this.authCtx, connectionName);
            this.datasetConfig = DynamoDBOutput.this.dataset.getParamsAs(DynamoDBDatasetHandler.Config.class);
            this.writeMode = writeMode;
        }

        public void init(ColumnFactory cf) throws Exception {
            this.cf = cf;
            this.schemaColumns = DynamoDBOutput.this.dataset.getSchema().getColumns();
            String partitioningColumnName = DynamoDBOutput.this.dataset.getParamsAs(DynamoDBDatasetHandler.Config.class).partitioningColumn;
            for (SchemaColumn sc : this.schemaColumns) {
                String colName = sc.getName();
                if (colName.equals(__DKU_DYNAMODB_INTERNAL_ID__) || !colName.equals(partitioningColumnName)) continue;
                this.partitioningColumn = sc;
            }
            if (DynamoDBOutput.this.dataset.isManaged()) {
                boolean created = this.createTableNoFail();
                if (created && partitioningColumnName != null) {
                    this.createIndexForPartitioning(partitioningColumnName);
                }
                if (this.writeMode == Output.WriteMode.OVERWRITE) {
                    if (partitioningColumnName == null) {
                        if (!created) {
                            this.deleteTable();
                            this.createTable();
                        }
                    } else {
                        this.removeRowsForPartitionId(partitioningColumnName);
                    }
                }
            } else if (this.writeMode == Output.WriteMode.OVERWRITE) {
                if (partitioningColumnName == null) {
                    this.removeAllRowsFromTable();
                } else {
                    this.removeRowsForPartitionId(partitioningColumnName);
                }
            }
            this.tableDescription = this.describeTable();
        }

        private TableDescription describeTable() {
            DescribeTableResponse describeResponse = this.dynamoConn.client.describeTable(builder -> builder.tableName(this.tableName));
            return describeResponse.table();
        }

        public long writtenBytes() throws IOException {
            return 0L;
        }

        public void emitRow(Row row) throws Exception {
            HashMap<String, AttributeValue> itemAttributes = new HashMap<String, AttributeValue>();
            if (((KeySchemaElement)this.tableDescription.keySchema().get(0)).attributeName().equals(__DKU_DYNAMODB_INTERNAL_ID__)) {
                String dkuIdValue = SecretKeyGenerator.generate();
                itemAttributes.put(__DKU_DYNAMODB_INTERNAL_ID__, AttributeValue.fromS((String)dkuIdValue));
            }
            for (SchemaColumn sc : this.schemaColumns) {
                String colName = sc.getName();
                if (sc == this.partitioningColumn) {
                    this.typeConverter.addValueToDynamoDBItemAttributes(itemAttributes, colName, DynamoDBOutput.this.targetPartition.id(), sc, this.datasetConfig.writeDataTypeMismatchBehavior, DynamoDBOutput.this.warnContext);
                    continue;
                }
                String colValue = row.get(this.cf.column(colName));
                if (!StringUtils.isNotBlank((String)colValue)) continue;
                this.typeConverter.addValueToDynamoDBItemAttributes(itemAttributes, colName, colValue, sc, this.datasetConfig.writeDataTypeMismatchBehavior, DynamoDBOutput.this.warnContext);
            }
            try {
                this.writeRequests.add((WriteRequest)WriteRequest.builder().putRequest(builder -> builder.item(itemAttributes)).build());
                if ((long)this.writeRequests.size() >= 25L) {
                    this.executeBatchWrite(this.writeRequests);
                    this.count += this.writeRequests.size();
                    if (this.count > 0 && this.count % 5000 == 0) {
                        logger.infoV("Sent rows to DynamoDB : %d", new Object[]{this.count});
                    }
                    this.writeRequests.clear();
                }
            }
            catch (DynamoDbException e) {
                logger.warn((Object)"Failed to batch write items : ", (Throwable)e);
            }
        }

        public void lastRowEmitted() throws Exception {
            try {
                if (!this.writeRequests.isEmpty()) {
                    this.executeBatchWrite(this.writeRequests);
                }
            }
            catch (DynamoDbException e) {
                logger.info((Object)("Failed to push last rows : " + String.valueOf((Object)e)));
            }
            finally {
                this.dynamoConn.close();
            }
        }

        public void cancel() throws Exception {
            this.dynamoConn.close();
        }

        private void executeBatchWrite(List<WriteRequest> requests) {
            BatchWriteItemRequest batchWriteItemRequest = (BatchWriteItemRequest)BatchWriteItemRequest.builder().requestItems(Map.of(this.tableName, requests)).build();
            this.dynamoConn.client.batchWriteItem(batchWriteItemRequest);
        }

        private void removeRowsForPartitionId(String partitioningColumnName) {
            logger.info((Object)("Dropping rows for table : " + this.tableName + ", partition : " + DynamoDBOutput.this.targetPartition.id()));
            ScanRequest scanRequest = (ScanRequest)ScanRequest.builder().tableName(this.tableName).projectionExpression("#dkuID, #partitioningColumnName").filterExpression("#column = :targetPartition").expressionAttributeNames(Map.of("#column", partitioningColumnName, "#dkuID", __DKU_DYNAMODB_INTERNAL_ID__, "#partitioningColumnName", partitioningColumnName)).expressionAttributeValues(Map.of(":targetPartition", AttributeValue.fromS((String)DynamoDBOutput.this.targetPartition.id()))).build();
            this.scanAndDelete(scanRequest);
        }

        private void removeAllRowsFromTable() {
            logger.info((Object)("Dropping rows for table : " + this.tableName));
            ScanRequest scanRequest = (ScanRequest)ScanRequest.builder().tableName(this.tableName).projectionExpression("#dkuID").expressionAttributeNames(Map.of("#dkuID", __DKU_DYNAMODB_INTERNAL_ID__)).build();
            this.scanAndDelete(scanRequest);
        }

        private void scanAndDelete(ScanRequest scanRequest) {
            String partitionKey = ((KeySchemaElement)this.describeTable().keySchema().get(0)).attributeName();
            ArrayList<WriteRequest> deleteRequests = new ArrayList<WriteRequest>();
            for (ScanResponse scanResponse : this.dynamoConn.client.scanPaginator(scanRequest)) {
                for (Map item : scanResponse.items()) {
                    Map<String, AttributeValue> keyToDelete = Map.of(partitionKey, (AttributeValue)item.get(partitionKey));
                    deleteRequests.add((WriteRequest)WriteRequest.builder().deleteRequest(builder -> builder.key(keyToDelete)).build());
                    if ((long)deleteRequests.size() < 25L) continue;
                    this.executeBatchWrite(deleteRequests);
                    deleteRequests.clear();
                }
            }
            if (!deleteRequests.isEmpty()) {
                this.executeBatchWrite(deleteRequests);
            }
        }

        private void createIndexForPartitioning(String partitioningColumnName) throws InterruptedException {
            String attributeType = new DynamoDBTypeConverter().toDynamoType(DynamoDBOutput.this.dataset.getSchema().getColumn(partitioningColumnName).getType());
            DynamoDBOutputWriter.createIndexForPartitioning(this.dynamoConn, partitioningColumnName, this.tableName, attributeType);
        }

        public static void createIndexForPartitioning(DynamoDBConnectionWrapper dynamoConn, String partitioningColumnName, String tableName, String attributeType) throws InterruptedException {
            KeySchemaElement keySchemaElement = (KeySchemaElement)KeySchemaElement.builder().attributeName(partitioningColumnName).keyType(KeyType.HASH).build();
            AttributeDefinition attributeDefinition = (AttributeDefinition)AttributeDefinition.builder().attributeName(partitioningColumnName).attributeType(attributeType).build();
            String indexName = partitioningColumnName + "Index";
            CreateGlobalSecondaryIndexAction.Builder createGSIActionBuilder = CreateGlobalSecondaryIndexAction.builder().indexName(indexName).keySchema(new KeySchemaElement[]{keySchemaElement}).projection(builder -> builder.projectionType(ProjectionType.ALL));
            if (dynamoConn.connection.params.rwCapacityMode == DynamoDBConnection.Params.CapacityMode.PROVISIONED) {
                long readCapacity = dynamoConn.connection.params.readCapacity;
                long writeCapacity = dynamoConn.connection.params.writeCapacity;
                createGSIActionBuilder.provisionedThroughput(builder -> builder.readCapacityUnits(Long.valueOf(readCapacity)).writeCapacityUnits(Long.valueOf(writeCapacity)));
            }
            logger.info((Object)("Creating global secondary index " + partitioningColumnName + "Index for table : " + tableName));
            GlobalSecondaryIndexUpdate gsiUpdate = (GlobalSecondaryIndexUpdate)GlobalSecondaryIndexUpdate.builder().create((CreateGlobalSecondaryIndexAction)createGSIActionBuilder.build()).build();
            UpdateTableRequest updateRequest = (UpdateTableRequest)UpdateTableRequest.builder().tableName(tableName).attributeDefinitions(new AttributeDefinition[]{attributeDefinition}).globalSecondaryIndexUpdates(new GlobalSecondaryIndexUpdate[]{gsiUpdate}).build();
            dynamoConn.client.updateTable(updateRequest);
            DynamoDBOutputWriter.waitForActiveIndex(dynamoConn, tableName, indexName);
        }

        private static void waitForActiveIndex(DynamoDBConnectionWrapper dynamoConn, String tableName, String indexName) throws InterruptedException {
            TableDescription table;
            List list;
            block4: while ((list = (table = dynamoConn.client.describeTable(builder -> builder.tableName(tableName)).table()).globalSecondaryIndexes()) != null) {
                for (GlobalSecondaryIndexDescription d : list) {
                    if (!d.indexName().equals(indexName)) continue;
                    IndexStatus status = d.indexStatus();
                    switch (status) {
                        case ACTIVE: {
                            return;
                        }
                        case CREATING: 
                        case UPDATING: {
                            Thread.sleep(5000L);
                            continue block4;
                        }
                    }
                    throw new IllegalArgumentException("Global Secondary Index " + indexName + " is not being created or updated (with status=" + String.valueOf(status) + ")");
                }
            }
            throw new IllegalArgumentException("Global Secondary Index " + indexName + " does not exist in Table " + tableName + ")");
        }

        private void deleteTable() {
            logger.info((Object)("Dropping table : " + this.tableName));
            this.dynamoConn.client.deleteTable(builder -> builder.tableName(this.tableName));
            DynamoDBOutputWriter.waitForTableState(this.dynamoConn, this.tableName, false);
        }

        private void createTable() {
            DynamoDBOutputWriter.createTable(this.dynamoConn, this.tableName);
        }

        public static void createTable(DynamoDBConnectionWrapper dynamoConn, String tableName) {
            logger.info((Object)("Creating table: " + tableName));
            KeySchemaElement keySchemaElement = (KeySchemaElement)KeySchemaElement.builder().attributeName(__DKU_DYNAMODB_INTERNAL_ID__).keyType(KeyType.HASH).build();
            AttributeDefinition attributeDefinition = (AttributeDefinition)AttributeDefinition.builder().attributeName(__DKU_DYNAMODB_INTERNAL_ID__).attributeType(ScalarAttributeType.S).build();
            CreateTableRequest.Builder createTableRequestBuilder = CreateTableRequest.builder().tableName(tableName).keySchema(new KeySchemaElement[]{keySchemaElement}).attributeDefinitions(new AttributeDefinition[]{attributeDefinition});
            DynamoDBConnection.Params.CapacityMode rwCapacityMode = dynamoConn.connection.params.rwCapacityMode;
            if (rwCapacityMode == DynamoDBConnection.Params.CapacityMode.ON_DEMAND) {
                createTableRequestBuilder.billingMode(BillingMode.PAY_PER_REQUEST);
            } else {
                long readCapacity = dynamoConn.connection.params.readCapacity;
                long writeCapacity = dynamoConn.connection.params.writeCapacity;
                createTableRequestBuilder.billingMode(BillingMode.PROVISIONED).provisionedThroughput(builder -> builder.readCapacityUnits(Long.valueOf(readCapacity)).writeCapacityUnits(Long.valueOf(writeCapacity)));
            }
            dynamoConn.client.createTable((CreateTableRequest)createTableRequestBuilder.build());
            DynamoDBOutputWriter.waitForTableState(dynamoConn, tableName, true);
        }

        private boolean createTableNoFail() {
            try {
                this.createTable();
                return true;
            }
            catch (ResourceInUseException e) {
                logger.info((Object)("Table already exists : " + this.tableName), (Throwable)e);
                return false;
            }
        }

        private static void waitForTableState(DynamoDBConnectionWrapper dynamoConn, String tableName, boolean waitForExists) {
            DynamoDbWaiter dbWaiter = dynamoConn.client.waiter();
            if (waitForExists) {
                dbWaiter.waitUntilTableExists(builder -> builder.tableName(tableName));
            } else {
                dbWaiter.waitUntilTableNotExists(builder -> builder.tableName(tableName));
            }
        }
    }
}

