/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.elasticsearch;

import com.dataiku.dip.datasets.elasticsearch.ElasticSearchIndex;
import com.dataiku.dip.partitioning.DimensionValue;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitionFactory;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.partitioning.PartitioningUtils;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.warnings.WarningsContext;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

public class ElasticSearchManagedPartitionUtils {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.datasets.elasticsearch");

    static Partition getIndexPartition(ElasticSearchIndex esIndex, String index) {
        if (index.equals(esIndex.rootIndex)) {
            return new Partition(esIndex.partitioningScheme);
        }
        if (!index.startsWith(esIndex.rootIndex + ".")) {
            return null;
        }
        return ElasticSearchManagedPartitionUtils.decodePartitionDimensions(esIndex.partitioningScheme, index.substring(esIndex.rootIndex.length()));
    }

    static List<Partition> listPartitionsManaged(ElasticSearchIndex esIndex) throws Exception {
        ArrayList partitions = Lists.newArrayList();
        List<String> names = esIndex.getIndicesForAlias(esIndex.rootIndex);
        for (String name : names) {
            Partition p = ElasticSearchManagedPartitionUtils.getIndexPartition(esIndex, name);
            if (p == null) continue;
            partitions.add(p);
        }
        return partitions;
    }

    static String encodePartitionDimensions(Partition p) {
        assert (p.isComplete());
        StringBuilder buf = new StringBuilder();
        for (String name : p.getScheme().getDimensionNames()) {
            buf.append('.');
            buf.append(PartitioningUtils.encode(((DimensionValue)p.getDimensionValues().get(name)).id(), true).toLowerCase());
        }
        return buf.toString();
    }

    static Partition decodePartitionDimensions(PartitioningScheme scheme, String suffix) {
        suffix = suffix.substring(suffix.indexOf(46) + 1);
        Partition partition = new Partition(scheme);
        List dimensionNames = scheme.getDimensionNames();
        String[] split = suffix.split("\\.", -1);
        if (split.length != dimensionNames.size()) {
            throw new IllegalArgumentException("Can't decode " + dimensionNames.size() + "-part partition from suffix: " + suffix);
        }
        for (int i = 0; i < split.length; ++i) {
            String name = (String)dimensionNames.get(i);
            String partitionName = PartitioningUtils.decode(split[i]);
            partition.setDimensionValue(name, scheme.getDimension(name).getValueFromId(partitionName));
        }
        return partition;
    }

    static String buildSearchPartitionIndex(ElasticSearchIndex esIndex, DSSAuthCtx user, ElasticSearchIndex.ESQueryBuilder.PaginatedInteractiveSearchQuery query, ElasticSearchIndex.InteractiveSearchResults results) throws Exception {
        List<String> partitionsStrs = query.datasetSelection.getPartitionIds(user, esIndex.dataset);
        ArrayList<String> indices = new ArrayList<String>();
        for (String partitionStr : partitionsStrs) {
            try {
                List<Partition> partitions = PartitionFactory.fromPartitionSpec(esIndex.dataset.getPartitioningSchema(), partitionStr);
                for (Partition partition : partitions) {
                    try {
                        indices.add(esIndex.getPartitionIndex(partition));
                    }
                    catch (Exception e) {
                        results.warningsContext.addWarning(WarningsContext.WarningType.INPUT_ELASTICSEARCH_INDEX_NOT_FOUND, "Elasticsearch index or type not found: " + partition.toString(), logger);
                    }
                }
            }
            catch (Exception e) {
                results.warningsContext.addWarning(WarningsContext.WarningType.INPUT_ELASTICSEARCH_INDEX_NOT_FOUND, "Could not find Elasticsearch index for partition input: " + partitionStr, logger);
            }
        }
        return String.join((CharSequence)",", indices);
    }
}

