/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.fs;

import com.dataiku.dip.coremodel.FormatParams;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.datasets.fs.BlobLikeFSProvider;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.output.ResplittableExtensibleFileOutputWriter;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.warnings.WarningsContext;
import java.io.IOException;

public class BlobLikeResplitOutputWriter
extends ResplittableExtensibleFileOutputWriter<BlobLikeFSProvider> {
    private String firstChunkPath;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.output.file");

    public BlobLikeResplitOutputWriter(AuthCtx authCtx, String projectKey, BlobLikeFSProvider provider, String basePath, int splitId, int nbChunks, String formatType, FormatParams formatParams, Schema schema, WarningsContext warningsContext, Output.WriteMode writeMode, String compress, SerializedDataset.ReadWriteOptions readWriteOptions) {
        super(authCtx, projectKey, provider, basePath, splitId, nbChunks, formatType, formatParams, schema, warningsContext, writeMode, compress, readWriteOptions);
    }

    @Override
    protected boolean fileExists(String path) throws IOException, CodedException, DKUSecurityException {
        return ((BlobLikeFSProvider)this.provider).fileExists(path);
    }

    @Override
    protected void onChunkInitDone(int chunkId, String filePath) {
        if (chunkId == 0) {
            this.firstChunkPath = filePath;
        }
    }

    @Override
    public void lastRowEmitted() throws Exception {
        super.lastRowEmitted();
        if (!this.chunks.isEmpty()) {
            ((BlobLikeFSProvider)this.provider).waitUntilReadable(this.firstChunkPath);
        }
    }
}

