/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.mongodb;

import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.mongodb.MongoDBDatasetHandler;
import com.dataiku.dip.recipes.ManagedDatasetsCreationService;
import com.dataiku.dip.security.AuthCtx;
import com.google.gson.JsonObject;
import org.apache.commons.lang.StringUtils;

public class MongoDBDatasetMeta
extends DatasetHandler.NonFSMeta<MongoDBDatasetHandler, MongoDBDatasetHandler.Config> {
    @Override
    public String getType() {
        return "MongoDB";
    }

    @Override
    public Class<? extends DatasetHandler.DatasetParams> paramsClass() {
        return MongoDBDatasetHandler.Config.class;
    }

    @Override
    public DatasetHandler build(AuthCtx authCtx, Dataset dataset) {
        return new MongoDBDatasetHandler(authCtx, dataset);
    }

    @Override
    public boolean isFSLike() {
        return false;
    }

    @Override
    public boolean isFS() {
        return false;
    }

    @Override
    public boolean isReadable() {
        return true;
    }

    @Override
    public boolean isWritable() {
        return true;
    }

    @Override
    public boolean isParallelWritable() {
        return false;
    }

    @Override
    public void fillManagedDatasetParams(Dataset dataset, DSSConnection targetConnection, ManagedDatasetsCreationService.ManagedDatasetCreationSpecificSettings unused, boolean useExistingParams) {
        dataset.setType(this.getType());
        dataset.setManaged(true);
        MongoDBDatasetHandler.Config config = new MongoDBDatasetHandler.Config();
        config.collection = dataset.getName();
        config.connection = targetConnection.name;
        dataset.setParams(config);
    }

    @Override
    protected void selfReport(MongoDBDatasetHandler.Config param, JsonObject ret) throws Exception {
        ret.addProperty("mgo.hasQuery", Boolean.valueOf(!StringUtils.isBlank((String)param.query)));
    }
}

