/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.compute.caching;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.eda.compute.engine.ComputationRunner;
import com.dataiku.dip.eda.compute.engine.LazyRunner;
import com.dataiku.dip.eda.compute.engine.SmoothlyClosableComputationRunner;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.GuavaCacheMetrics;
import com.dataiku.dip.utils.Params;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheStats;
import com.google.common.collect.ImmutableMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.springframework.stereotype.Service;

@Service
public class KernelCachingService {
    public static final String CACHE_NAME = "eda.kernels";
    private static final int KERNEL_CACHE_DEFAULT_EXPIRATION_TIME_IN_MINUTES = 10;
    public static final String KERNEL_CACHE_EXPIRATION_MINUTES_CONFIG_KEY = "dku.caches.eda.kernels.expirationMn";
    private final Cache<String, SmoothlyClosableComputationRunner> kernelCache;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.eda.compute.cache");

    public KernelCachingService() {
        Params p = ApplicationConfigurator.getParams();
        long kernelCacheExpirationTimeMn = p.getLongParam(KERNEL_CACHE_EXPIRATION_MINUTES_CONFIG_KEY, 10L);
        logger.infoV("Init kernel cache with expirationMn %d", new Object[]{kernelCacheExpirationTimeMn});
        this.kernelCache = CacheBuilder.newBuilder().expireAfterAccess(kernelCacheExpirationTimeMn, TimeUnit.MINUTES).removalListener(notification -> {
            try {
                ((ComputationRunner)notification.getValue()).close();
            }
            catch (Exception e) {
                logger.error((Object)"Failed to remove kernel", (Throwable)e);
            }
        }).build();
        DSSMetrics.registry().registerAll(GuavaCacheMetrics.cacheMetricsSet((String)CACHE_NAME, this.kernelCache));
    }

    public synchronized SmoothlyClosableComputationRunner get(String s, Callable<ComputationRunner> runnerBuilder) {
        SmoothlyClosableComputationRunner runner = (SmoothlyClosableComputationRunner)this.kernelCache.getIfPresent((Object)s);
        if (runner == null || !runner.isAlive()) {
            logger.infoV("No existing computation runner found in cache for sample id %s, creating one and caching it", new Object[]{s});
            LazyRunner lazyRunner = new LazyRunner(runnerBuilder);
            runner = new SmoothlyClosableComputationRunner(lazyRunner);
            this.kernelCache.put((Object)s, (Object)runner);
        } else {
            logger.infoV("Reusing runner cached for sample id %s", new Object[]{s});
        }
        return runner;
    }

    public ImmutableMap<String, SmoothlyClosableComputationRunner> getAllPresent(Iterable<?> iterable) {
        return this.kernelCache.getAllPresent(iterable);
    }

    public void invalidate(Object o) {
        this.kernelCache.invalidate(o);
    }

    public void invalidateAll(Iterable<?> iterable) {
        this.kernelCache.invalidateAll(iterable);
    }

    public void invalidateAll() {
        this.kernelCache.invalidateAll();
    }

    public long size() {
        return this.kernelCache.size();
    }

    public CacheStats stats() {
        return this.kernelCache.stats();
    }

    public ConcurrentMap<String, SmoothlyClosableComputationRunner> asMap() {
        return this.kernelCache.asMap();
    }

    public void cleanUp() {
        this.kernelCache.cleanUp();
    }
}

