/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.worksheets;

import com.dataiku.dip.dao.AbstractStandardDAO;
import com.dataiku.dip.eda.worksheets.models.Worksheet;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.utils.FileFilter;
import com.dataiku.dip.transactions.fs.utils.RelFileFilter;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.utils.ExceptionUtils;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class WorksheetsDAO
extends AbstractStandardDAO<Worksheet> {
    @Override
    protected Worksheet getOrNull_noTag(String projectKey, String id, boolean unsafe) throws IOException {
        RelFile file;
        TransactionRef t = TransactionContext.retrieveRead();
        if (!t.isFile(file = this.getDAOFile(projectKey, id))) {
            return null;
        }
        Worksheet worksheet = unsafe ? (Worksheet)t.readObjectUnsafe(file, Worksheet.class) : (Worksheet)t.readObject(file, Worksheet.class);
        worksheet.projectKey = projectKey;
        worksheet.id = id;
        return worksheet;
    }

    @Override
    protected List<Worksheet> list_noTag(String projectKey, boolean unsafe) throws IOException {
        TransactionRef t = TransactionContext.retrieveRead();
        ArrayList<Worksheet> ret = new ArrayList<Worksheet>();
        RelFile worksheetsFolder = this.getWorksheetsFolder(projectKey);
        if (!t.exists(worksheetsFolder)) {
            return ret;
        }
        for (RelFile file : t.listFiles(worksheetsFolder, (RelFileFilter)FileFilter.json())) {
            try {
                String id = StringUtils.removeEnd((String)file.getLeafName(), (String)".json");
                ret.add(this.getOrNull_noTag(projectKey, id, unsafe));
            }
            catch (Exception e) {
                this.logger.error((Object)("Failed to read worksheet file " + String.valueOf(file) + ": " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
            }
        }
        return ret;
    }

    public RelFile getWorksheetsFolder(String projectKey) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Project key is not specified");
        return new RelFile(new String[]{"projects", projectKey, "statistics_worksheets"});
    }

    @Override
    protected RelFile getDAOFile(String projectKey, String worksheetId) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)worksheetId), (Object)"Worksheet ID is not specified");
        return new RelFile(this.getWorksheetsFolder(projectKey), new String[]{worksheetId + ".json"});
    }

    @Override
    protected String getHumanReadableType() {
        return ITaggingService.TaggableType.STATISTICS_WORKSHEET.toHumanReadableString();
    }

    @Override
    public void delete(String projectKey, String id) throws IOException {
        RelFile file;
        RWTransactionRef t = TransactionContext.retrieveWrite();
        if (!t.isFile(file = this.getDAOFile(projectKey, id))) {
            throw new NotFoundException("Worksheet does not exist: " + projectKey + "." + id);
        }
        t.deleteFile(file);
    }

    @Override
    public int approximateCount(String projectKey) throws IOException {
        RelFile worksheetsFolder;
        TransactionRef t = TransactionContext.retrieveRead();
        if (!t.exists(worksheetsFolder = this.getWorksheetsFolder(projectKey))) {
            return 0;
        }
        return t.listFiles(worksheetsFolder, (RelFileFilter)FileFilter.json()).size();
    }
}

