/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.worksheets;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.cuspol.CustomPolicyHooksRegistry;
import com.dataiku.dip.eda.compute.sampling.SamplesService;
import com.dataiku.dip.eda.worksheets.WorksheetsDAO;
import com.dataiku.dip.eda.worksheets.models.Worksheet;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.notifications.backend.TaggableObjectChangedEvent;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.NullChecker;
import com.dataiku.j2ts.annotations.UIModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WorksheetsService {
    @Autowired
    DatasetAccessService datasetAccessService;
    @Autowired
    WorksheetsDAO worksheetsDAO;
    @Autowired
    SamplesService samplesService;
    @Autowired
    CustomPolicyHooksRegistry customPolicyHooksRegistry;
    @Autowired
    PubSubService pubSub;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.eda.worksheets.service");

    public Worksheet saveWorksheet(AuthCtx authCtx, Worksheet worksheet) throws Exception {
        TaggableObjectChangedEvent.ActionType action;
        Worksheet copiedWorksheet = (Worksheet)JSON.deepCopy((Object)worksheet);
        copiedWorksheet.refreshCardTree();
        NullChecker.checkObject((Object)copiedWorksheet);
        if (StringUtils.isBlank((CharSequence)worksheet.id)) {
            copiedWorksheet.versionTag = copiedWorksheet.creationTag = new VersionTag(authCtx.getIdentifier());
            copiedWorksheet.id = SecretKeyGenerator.generate((int)10);
            logger.infoV("Saving new worksheet %s", new Object[]{worksheet.id});
            this.customPolicyHooksRegistry.onPreObjectSave(authCtx, null, copiedWorksheet);
            action = TaggableObjectChangedEvent.ActionType.STATISTICS_WORKSHEET_CREATE;
        } else {
            Worksheet existingWorksheet = (Worksheet)this.worksheetsDAO.getMandatory(worksheet.projectKey, worksheet.id);
            copiedWorksheet.versionTag = VersionTag.increment(existingWorksheet.versionTag, authCtx.getIdentifier());
            logger.infoV("Updating existing worksheet %s", new Object[]{worksheet.id});
            this.customPolicyHooksRegistry.onPreObjectSave(authCtx, existingWorksheet, copiedWorksheet);
            action = StringUtils.equals((CharSequence)existingWorksheet.name, (CharSequence)copiedWorksheet.name) ? TaggableObjectChangedEvent.ActionType.STATISTICS_WORKSHEET_EDIT : TaggableObjectChangedEvent.ActionType.STATISTICS_WORKSHEET_RENAME;
        }
        this.pubSub.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.STATISTICS_WORKSHEET, copiedWorksheet.projectKey, copiedWorksheet.id, authCtx.getIdentifier(), action));
        this.worksheetsDAO.save(copiedWorksheet);
        return copiedWorksheet;
    }

    public Worksheet getWorksheet(String projectKey, String id) throws IOException {
        logger.infoV("Loading worksheet with id %s from project %s", new Object[]{id, projectKey});
        return (Worksheet)this.worksheetsDAO.getMandatory(projectKey, id);
    }

    public Worksheet getWorksheetOrNull(String projectKey, String id) throws IOException {
        return (Worksheet)this.worksheetsDAO.getOrNull(projectKey, id);
    }

    public void delete(TaggableObjectsService.TaggableObjectRef ref) throws IOException, CodedException {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        logger.infoV("Delete worksheet %s from project %s", new Object[]{ref.id, ref.projectKey});
        this.customPolicyHooksRegistry.onPreObjectDelete(t.getUser(), (TaggableObjectsService.TaggableObject)this.worksheetsDAO.getOrNull(ref.projectKey, ref.id));
        this.worksheetsDAO.delete(ref.projectKey, ref.id);
        this.samplesService.removeByRef(ref);
        this.pubSub.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.STATISTICS_WORKSHEET, ref.projectKey, ref.id, t.getUser(), TaggableObjectChangedEvent.ActionType.STATISTICS_WORKSHEET_DELETE));
    }

    public void deleteAllForDataset(String projectKey, String name) throws IOException, CodedException {
        DatasetLocUtils.DatasetLoc deletedDataset = new DatasetLocUtils.DatasetLoc(projectKey, name);
        for (Worksheet worksheet : this.worksheetsDAO.listUnsafe(projectKey)) {
            if (!Objects.equals(deletedDataset, worksheet.getDatasetLoc())) continue;
            this.delete(worksheet.getRef());
        }
    }

    public List<Worksheet> listWorksheets(String projectKey, String datasetSmartName) throws IOException {
        logger.infoV("Listing worksheets for project %s and dataset %s", new Object[]{projectKey, datasetSmartName});
        ArrayList<Worksheet> output = new ArrayList<Worksheet>();
        Dataset dataset = this.getDataset(projectKey, datasetSmartName);
        for (Worksheet worksheet : this.worksheetsDAO.listUnsafe(projectKey)) {
            if (!StringUtils.equals((CharSequence)worksheet.getDatasetLoc().getFullName(), (CharSequence)dataset.getFullName())) continue;
            logger.infoV("Found worksheet %s", new Object[]{worksheet.id});
            output.add(worksheet);
        }
        return output;
    }

    public List<WorksheetHead> listWorksheetHeads(String projectKey, String datasetSmartName) throws IOException {
        logger.infoV("Listing worksheet heads for project %s and dataset %s", new Object[]{projectKey, datasetSmartName});
        ArrayList<WorksheetHead> output = new ArrayList<WorksheetHead>();
        Dataset dataset = this.getDatasetUnsafe(projectKey, datasetSmartName);
        for (Worksheet worksheet : this.worksheetsDAO.listUnsafe(projectKey)) {
            if (!StringUtils.equals((CharSequence)worksheet.getDatasetLoc().getFullName(), (CharSequence)dataset.getFullName())) continue;
            logger.infoV("Found worksheet %s", new Object[]{worksheet.id});
            output.add(new WorksheetHead(worksheet));
        }
        return output;
    }

    public List<Worksheet> listUnsafe(String projectKey) throws IOException {
        return this.worksheetsDAO.listUnsafe(projectKey);
    }

    public int approximateCount(String projectKey) throws IOException {
        return this.worksheetsDAO.approximateCount(projectKey);
    }

    protected Dataset getDataset(String projectKey, String datasetSmartName) throws IOException {
        if (datasetSmartName.contains(".")) {
            return this.datasetAccessService.getMandatoryFromRef(projectKey, datasetSmartName);
        }
        return this.datasetAccessService.getMandatory(projectKey, datasetSmartName);
    }

    protected Dataset getDatasetUnsafe(String projectKey, String datasetSmartName) throws IOException {
        if (datasetSmartName.contains(".")) {
            return this.datasetAccessService.getMandatoryUnsafeFromRef(projectKey, datasetSmartName);
        }
        return this.datasetAccessService.getMandatoryUnsafe(projectKey, datasetSmartName);
    }

    @UIModel
    public static class WorksheetHead
    extends TaggableObjectsService.TaggableListItem {
        public WorksheetHead(TaggableObjectsService.TaggableObject object) {
            super(object);
        }

        @Override
        public ITaggingService.TaggableType getTaggableType() {
            return ITaggingService.TaggableType.STATISTICS_WORKSHEET;
        }
    }
}

