/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.worksheets.cards;

import com.dataiku.dip.eda.compute.computations.AvailableResult;
import com.dataiku.dip.eda.compute.computations.timeseries.ACF;
import com.dataiku.dip.eda.compute.computations.timeseries.CorrelationFunction;
import com.dataiku.dip.eda.compute.computations.timeseries.PACF;
import com.dataiku.dip.eda.compute.computations.timeseries.TimeSeriesComputation;
import com.dataiku.dip.eda.worksheets.cards.TimeSeriesCard;
import com.dataiku.dip.eda.worksheets.cards.common.CardWithConfidenceLevel;
import com.dataiku.dip.eda.worksheets.cards.fragments.BoxPlotFragment;
import com.dataiku.dip.eda.worksheets.cards.fragments.TimeInfoFragment;
import com.dataiku.dip.eda.worksheets.models.Variable;
import javax.annotation.Nullable;

public class ACFPlotCard
extends TimeSeriesCard
implements CardWithConfidenceLevel {
    public static final String TYPE = "acf_plot";
    public double confidenceLevel;
    public boolean showSummary;
    public boolean isPartial;
    public boolean adjusted;
    public PACF.Method pacfMethod = PACF.Method.LEVINSON_DURBIN;
    @Nullable
    public Integer nLags;

    public ACFPlotCard(Variable seriesColumn, Variable timeColumn, boolean adjusted) {
        super(seriesColumn, timeColumn);
        this.isPartial = false;
        this.adjusted = adjusted;
    }

    public ACFPlotCard(Variable seriesColumn, Variable timeColumn, PACF.Method pacfMethod) {
        super(seriesColumn, timeColumn);
        this.isPartial = true;
        this.pacfMethod = pacfMethod;
    }

    private ACFPlotCard() {
    }

    @Override
    protected TimeSeriesComputation getMainComputation() {
        double alpha = 1.0 - this.confidenceLevel;
        if (this.isPartial) {
            return new PACF(this.seriesColumn.name, this.timeColumn.name, alpha, this.pacfMethod, this.nLags);
        }
        return new ACF(this.seriesColumn.name, this.timeColumn.name, alpha, this.adjusted, this.nLags);
    }

    @Override
    protected TimeSeriesCard.TimeSeriesCardResult buildCardResult(AvailableResult mainComputationResult, BoxPlotFragment boxPlot, TimeInfoFragment timeInfo) {
        CorrelationFunction.CorrelationFunctionResult result = mainComputationResult.as(CorrelationFunction.CorrelationFunctionResult.class);
        return new ACFPlotCardResult(result, boxPlot, timeInfo);
    }

    @Override
    public void setConfidenceLevel(double confidenceLevel) {
        this.confidenceLevel = confidenceLevel;
    }

    public static class ACFPlotCardResult
    extends TimeSeriesCard.TimeSeriesCardResult {
        public double[] coefficients;
        public double[][] confidenceIntervals;

        public ACFPlotCardResult(CorrelationFunction.CorrelationFunctionResult result, BoxPlotFragment boxPlot, TimeInfoFragment timeInfo) {
            super(boxPlot, timeInfo);
            this.coefficients = result.coefficients;
            this.confidenceIntervals = result.confidenceIntervals;
        }

        protected ACFPlotCardResult() {
        }
    }
}

