/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.worksheets.cards;

import com.dataiku.dip.eda.compute.computations.Computation;
import com.dataiku.dip.eda.compute.computations.ComputationResult;
import com.dataiku.dip.eda.compute.computations.univariate.PairwiseMoodTest;
import com.dataiku.dip.eda.compute.grouping.Grouping;
import com.dataiku.dip.eda.compute.stats.PValueAdjustmentMethod;
import com.dataiku.dip.eda.worksheets.cards.bivariate_header.BivariateHistogramCard;
import com.dataiku.dip.eda.worksheets.cards.common.AbstractNSampTestCard;
import com.dataiku.dip.eda.worksheets.cards.common.AbstractPairwiseTestCard;
import com.dataiku.dip.eda.worksheets.cards.common.CompiledCard;
import com.dataiku.dip.eda.worksheets.cards.common.RecipeCompatibleCard;
import com.dataiku.dip.eda.worksheets.models.Variable;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;

public class PairwiseMoodTestCard
extends AbstractPairwiseTestCard
implements RecipeCompatibleCard {
    public static final String TYPE = "pairwise_mood";

    public PairwiseMoodTestCard(Variable xColumn, Variable yColumn, List<String> yValues, int maxGroups, @Nullable String referenceGroup, PValueAdjustmentMethod adjustmentMethod) {
        this.xColumn = xColumn;
        this.yColumn = yColumn;
        this.yValues = yValues;
        this.maxGroups = maxGroups;
        this.referenceGroup = referenceGroup;
        this.adjustmentMethod = adjustmentMethod;
    }

    private PairwiseMoodTestCard() {
    }

    @Override
    protected CompiledCard compileNoSplitNoFilter() {
        return new AbstractPairwiseTestCard.AbstractCompiledPairwiseTestCard(){

            @Override
            protected Computation getTestComputation(Grouping grouping) {
                return new PairwiseMoodTest(PairwiseMoodTestCard.this.xColumn.name, grouping, PairwiseMoodTestCard.this.referenceGroup != null, PairwiseMoodTestCard.this.adjustmentMethod);
            }

            @Override
            protected PairwiseMoodTestCardResult buildTestCardResult(ComputationResult result, List<String> warnings, List<AbstractNSampTestCard.GroupInfo> groups, AbstractNSampTestCard.GroupInfo allGroups, BivariateHistogramCard.BivariateHistogramData histogramData) {
                PairwiseMoodTest.PairwiseMoodTestResult ttest = result.as(PairwiseMoodTest.PairwiseMoodTestResult.class);
                ImmutableList allWarnings = ImmutableList.builder().addAll(result.collectWarnings()).addAll(warnings).build();
                return new PairwiseMoodTestCardResult((List<String>)allWarnings, groups, allGroups, histogramData, ttest.pvalues, ttest.adjustedPvalues, ttest.statistics);
            }
        };
    }

    public static class PairwiseMoodTestCardResult
    extends AbstractNSampTestCard.AbstractNSampleTestCardResult {
        public double[] pvalues;
        public double[] adjustedPvalues;
        public double[] statistics;

        public PairwiseMoodTestCardResult(List<String> warnings, List<AbstractNSampTestCard.GroupInfo> groups, AbstractNSampTestCard.GroupInfo allGroups, BivariateHistogramCard.BivariateHistogramData histogramData, double[] pvalues, double[] adjustedPvalues, double[] statistics) {
            this.warnings = warnings;
            this.groups = groups;
            this.allGroups = allGroups;
            this.histogramData = histogramData;
            this.pvalues = pvalues;
            this.adjustedPvalues = adjustedPvalues;
            this.statistics = statistics;
        }

        private PairwiseMoodTestCardResult() {
        }
    }
}

