/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eventserver;

import com.google.common.net.InetAddresses;
import jakarta.servlet.http.HttpServletRequest;
import java.net.InetAddress;

public class Utils {
    public static boolean isPublicAddress(String a) {
        if (!InetAddresses.isInetAddress((String)a)) {
            return false;
        }
        InetAddress addr = InetAddresses.forString((String)a);
        return !addr.isSiteLocalAddress() && !addr.isLinkLocalAddress() && !addr.isLoopbackAddress() && !addr.isAnyLocalAddress() && !addr.isMulticastAddress();
    }

    public static String computeRealRemoteAddress(HttpServletRequest req) {
        String val = req.getHeader("X-Forwarded-For");
        if (val != null) {
            for (String chunk : val.split(",")) {
                String a = chunk.trim();
                if (!Utils.isPublicAddress(a)) continue;
                return a;
            }
        }
        if ((val = req.getHeader("X-Real-IP")) != null && Utils.isPublicAddress(val)) {
            return val;
        }
        return req.getRemoteAddr();
    }
}

