/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.formats.custom;

import com.dataiku.dip.coremodel.FormatParams;
import com.dataiku.dip.custom.CustomJavaRuntimeDataProvider;
import com.dataiku.dip.custom.IPluginifiedMeta;
import com.dataiku.dip.datasets.SchemaDetection;
import com.dataiku.dip.formats.FormatFactory;
import com.dataiku.dip.formats.FormatMeta;
import com.dataiku.dip.formats.custom.CustomJavaFormatDesc;
import com.dataiku.dip.formats.custom.CustomJavaFormatExtractor;
import com.dataiku.dip.formats.custom.CustomJavaFormatParams;
import com.dataiku.dip.formats.custom.CustomJavaFormatWithSchemaExtractor;
import com.dataiku.dip.formats.custom.CustomJavaOutputFormatter;
import com.dataiku.dip.formats.custom.LoadedJavaFormat;
import com.dataiku.dip.input.formats.FormatExtractor;
import com.dataiku.dip.output.OutputFormatter;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.util.ParamDesc;
import org.apache.commons.lang.StringUtils;

public class CustomJavaFormatMeta
extends FormatMeta<CustomJavaFormatExtractor, CustomJavaFormatParams>
implements IPluginifiedMeta {
    private final LoadedJavaFormat loaded;
    private final CustomJavaRuntimeDataProvider service;

    public CustomJavaFormatMeta(LoadedJavaFormat loaded, CustomJavaRuntimeDataProvider service) {
        this.loaded = loaded;
        this.service = service;
    }

    public boolean canBeDatasetFormat() {
        return ((CustomJavaFormatDesc)this.loaded.getDesc()).canBeDatasetFormat;
    }

    @Override
    public LoadedJavaFormat getLoadedDesc() {
        return this.loaded;
    }

    public CustomJavaRuntimeDataProvider getService() {
        return this.service;
    }

    @Override
    public String getType() {
        return this.loaded.getType();
    }

    @Override
    public String getLabel() {
        if (((CustomJavaFormatDesc)this.loaded.desc).meta != null && StringUtils.isNotBlank((String)((CustomJavaFormatDesc)this.loaded.desc).meta.label)) {
            return ((CustomJavaFormatDesc)this.loaded.desc).meta.label;
        }
        return "Custom format " + this.loaded.getId() + " (" + this.loaded.getOwnerPluginId() + ")";
    }

    @Override
    public SchemaDetection.SchemaHandlingType getSchemaHandlingType() {
        return SchemaDetection.SchemaHandlingType.NAME_BASED_VARIABLE_COLUMNS;
    }

    @Override
    public ParamDesc[] getParams() {
        ParamDesc param = new ParamDesc("config", "autoconfig");
        param.params = ((CustomJavaFormatDesc)this.loaded.desc).params;
        return new ParamDesc[]{param, FormatFactory.getStandardCompressionMethods()};
    }

    @Override
    public Class<? extends FormatParams> paramsClass() {
        return CustomJavaFormatParams.class;
    }

    @Override
    public FormatExtractor build(AuthCtx authCtx, String projectKey, FormatParams params) {
        CustomJavaFormatParams javaParams = (CustomJavaFormatParams)params;
        if (((CustomJavaFormatDesc)this.loaded.desc).canExtractSchema) {
            return new CustomJavaFormatWithSchemaExtractor(authCtx, projectKey, javaParams.config, this.loaded, this.service);
        }
        return new CustomJavaFormatExtractor(authCtx, projectKey, javaParams.config, this.loaded, this.service);
    }

    @Override
    public OutputFormatter buildFormatter(AuthCtx authCtx, String projectKey, FormatParams params) {
        CustomJavaFormatParams pyParams = (CustomJavaFormatParams)params;
        return new CustomJavaOutputFormatter(authCtx, projectKey, pyParams.config, this.loaded, this.service);
    }
}

