/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.graphicsexport.wikis.execution;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.graphicsexport.execution.ExportScriptRunner;
import com.dataiku.dip.graphicsexport.model.EnrichedExport;
import com.dataiku.dip.graphicsexport.model.ExportFormat;
import com.dataiku.dip.graphicsexport.wikis.model.WikiEnrichedExport;
import com.dataiku.dip.graphicsexport.wikis.model.WikiExportTarget;
import com.dataiku.dip.server.services.InternalAPIKeysService;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class WikiExportScriptRunner
extends ExportScriptRunner {
    public WikiExportScriptRunner(EnrichedExport export, File exportDirectory, InternalAPIKeysService.APIKey apiKey, final FutureProgressState progressState) {
        super(export, exportDirectory, apiKey);
        ExportScriptRunner.ExportProgressObserver progressObserver = new ExportScriptRunner.ExportProgressObserver(){

            @Override
            public void update(int exportedCount) throws InterruptedException {
                progressState.set((double)exportedCount);
            }
        };
        ExportScriptRunner.ProgressSubscription progressSubscription = new ExportScriptRunner.ProgressSubscription(progressObserver, this.getLogProgressMarker());
        this.outputSubscriptions.add(progressSubscription);
    }

    @Override
    protected String getScriptFileName() {
        return "export-wiki.js";
    }

    @Override
    protected String getLogProgressMarker() {
        return "Successfully exported wiki article";
    }

    @Override
    protected ExportScriptRunner.ScriptConfig getScriptConfig() {
        WikiEnrichedExport wikiExport = (WikiEnrichedExport)this.export;
        Config result = new Config();
        result.browserSandBoxing = this.export.browserSandBoxing;
        result.pageDefaultTimeout = ApplicationConfigurator.getProperty((String)"dku.exports.puppeteer.pageDefaultTimeout", (int)0);
        result.outputDirectory = this.exportDirectory.getAbsolutePath();
        result.wikiHomeURL = wikiExport.wikiHomeURL;
        result.format = this.getFormatString(this.export.format.paperSize);
        result.articles = new ArrayList<Article>();
        for (WikiExportTarget article : wikiExport.articles) {
            result.articles.add(new Article(article.article.id, this.getChildrenRecursively(article)));
        }
        return result;
    }

    private String getFormatString(ExportFormat.PaperSize paperSize) {
        switch (paperSize) {
            case US_LETTER: {
                return "Letter";
            }
            case LEDGER: {
                return "Ledger";
            }
            case A4: {
                return "A4";
            }
            case A3: {
                return "A3";
            }
        }
        throw new IllegalArgumentException("Paper size " + paperSize.toString() + " is not supported for Wiki Export");
    }

    private List<Article> getChildrenRecursively(WikiExportTarget target) {
        ArrayList<Article> children = new ArrayList<Article>();
        for (WikiExportTarget child : target.children) {
            children.add(new Article(child.article.id, this.getChildrenRecursively(child)));
        }
        return children;
    }

    private static class Config
    implements ExportScriptRunner.ScriptConfig {
        public boolean browserSandBoxing;
        public int pageDefaultTimeout;
        public String outputDirectory;
        public String wikiHomeURL;
        public String format;
        public List<Article> articles;

        private Config() {
        }
    }

    private static class Article {
        public String id;
        public String url;
        public List<Article> children;

        Article(String id, List<Article> children) {
            this.id = id;
            this.children = children;
        }
    }
}

