/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.hadoop;

import com.dataiku.dip.license.LicenseRestrictionException;
import com.dataiku.dip.license.LicenseStatusService;
import org.apache.hadoop.mapred.ClusterStatus;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.log4j.Logger;

public class HadoopLicensingUtils {
    public static final int COMMUNITY_EDITION_MAX_HADOOP_NODES = 3;
    private static Logger logger = Logger.getLogger((String)"dku.licensing");

    public static void checkHadoopLicensing(LicenseStatusService.LicensingStatus ls) {
        if (!ls.community) {
            return;
        }
        try {
            ClusterStatus cs2 = new JobClient(new JobConf()).getClusterStatus();
            if (cs2.getTaskTrackers() > 3) {
                throw new LicenseRestrictionException("This DSS does not support Hadoop clusters with more than 3 nodes");
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Could not check Hadoop cluster size", (Throwable)e);
        }
    }
}

