/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.input.formats;

import com.dataiku.dip.coremodel.FormatParams;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datasets.SchemaDetection;
import com.dataiku.dip.formats.FormatFactory;
import com.dataiku.dip.formats.FormatMeta;
import com.dataiku.dip.formats.TextCompatibleFormatExtractor;
import com.dataiku.dip.input.formats.ArchiveCapableFormatExtractor;
import com.dataiku.dip.input.formats.FormatExtractor;
import com.dataiku.dip.input.formats.RowFactoryWithContextInfo;
import com.dataiku.dip.output.OutputFormatter;
import com.dataiku.dip.plugin.InputStreamWithContextInfo;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.util.ParamDesc;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.NotImplementedException;
import com.dataiku.dip.utils.Params;
import com.dataiku.dip.warnings.WarningsContext;
import com.dataiku.dss.shadelib.org.apache.commons.io.input.BOMInputStream;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class FixedWidthFormatExtractor
extends ArchiveCapableFormatExtractor
implements TextCompatibleFormatExtractor {
    public static final FormatMeta<FixedWidthFormatExtractor, Config> META = new FormatMeta<FixedWidthFormatExtractor, Config>(){

        @Override
        public String getType() {
            return "fixed";
        }

        @Override
        public String getLabel() {
            return "Fixed-width";
        }

        @Override
        public SchemaDetection.SchemaHandlingType getSchemaHandlingType() {
            return SchemaDetection.SchemaHandlingType.TEXT_POSITION_BASED_VARIABLE_COLUMNS;
        }

        @Override
        public ParamDesc[] getParams() {
            return new ParamDesc[]{new ParamDesc("offsets", "intarray").withDefaultValue("0").withLabel("Column offsets").withTooltip("Comma-separated list of column starting offsets (integers)"), ParamDesc.intP("skipRowsBeforeHeader", "Skip first lines", null), ParamDesc.booleanP("parseHeaderRow", "Parse next line as column headers", null), ParamDesc.intP("skipRowsAfterHeader", "Skip next lines", null), new ParamDesc("charset", "charset").withMandatory(false).withLabel("Charset").withTooltip("Ex: utf-8, utf-16, windows-1252"), FormatFactory.getStandardCompressionMethods()};
        }

        @Override
        public Class<? extends FormatParams> paramsClass() {
            return Config.class;
        }

        @Override
        public FormatExtractor build(AuthCtx authCtx, String projectKey, FormatParams params) {
            return new FixedWidthFormatExtractor((Config)params);
        }

        @Override
        public OutputFormatter buildFormatter(AuthCtx authCtx, String projectKey, FormatParams params) {
            throw new NotImplementedException();
        }
    };
    private Config config;
    private int[] columnOffsets;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.format.fixed");

    public FixedWidthFormatExtractor(Config config) {
        this.config = config;
        List co2 = Params.getFromCSVIntList((String)config.offsets, (String)"", (String)",");
        this.columnOffsets = new int[co2.size()];
        for (int i = 0; i < co2.size(); ++i) {
            this.columnOffsets[i] = (Integer)co2.get(i);
        }
    }

    @Override
    public void initPerLineExtraction(ColumnFactory cf, RowFactory rf) {
    }

    @Override
    public Row extractRow(ColumnFactory cf, RowFactory rf, String data) {
        assert (this.schema != null);
        Row r = rf.row();
        for (int colIdx = 0; colIdx < this.columnOffsets.length; ++colIdx) {
            Column c2 = cf.column(((SchemaColumn)this.schema.getColumns().get(colIdx)).getName());
            int begin = this.columnOffsets[colIdx];
            int end = colIdx < this.columnOffsets.length - 1 ? this.columnOffsets[colIdx + 1] : data.length();
            if (begin >= (end = Math.min(end, data.length()))) {
                this.warnContext.addWarning(WarningsContext.WarningType.INPUT_DATA_LINE_DOES_NOT_PARSE, String.format("file=%s line=%s: line is too short", "unk", data), logger);
                break;
            }
            String s = data.substring(begin, end).trim();
            r.put(c2, s);
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean doExtractStream(InputStreamWithContextInfo isn, ProcessorOutput out, ColumnFactory cf, RowFactory rowFactory, ArchiveCapableFormatExtractor.ArchiveCapableObserver observer) throws Exception {
        InputStream is = isn.getInputStream();
        RowFactoryWithContextInfo rf = new RowFactoryWithContextInfo(rowFactory, isn);
        if (this.config.charset.equalsIgnoreCase("utf8")) {
            is = new BOMInputStream(is);
        }
        try (BufferedReader br = new BufferedReader(new InputStreamReader(is, this.config.charset));){
            String line;
            ArrayList<Column> headerColumns = null;
            if (this.getSchema() != null) {
                headerColumns = new ArrayList<Column>();
                for (SchemaColumn col : this.getSchema().getColumns()) {
                    headerColumns.add(cf.column(col.getName()));
                }
            }
            long fileLines = 0L;
            long emittedLines = 0L;
            while ((line = br.readLine()) != null) {
                if (!observer.checkLimit(emittedLines)) {
                    boolean bl = false;
                    return bl;
                }
                if (fileLines >= (long)this.config.skipRowsBeforeHeader) {
                    if (fileLines == (long)this.config.skipRowsBeforeHeader && this.config.parseHeaderRow) {
                        if (this.getSchema() == null) {
                            headerColumns = new ArrayList();
                            for (int colIdx = 0; colIdx < this.columnOffsets.length; ++colIdx) {
                                int begin = this.columnOffsets[colIdx];
                                int end = colIdx < this.columnOffsets.length - 1 ? this.columnOffsets[colIdx + 1] : line.length();
                                if (begin < (end = Math.min(end, line.length()))) {
                                    Object s = line.substring(begin, end).trim();
                                    if (((String)s).isEmpty()) {
                                        s = "col_" + colIdx;
                                    }
                                    headerColumns.add(cf.column((String)s));
                                    continue;
                                }
                                break;
                            }
                        }
                    } else {
                        Row r = rf.row();
                        for (int colIdx = 0; colIdx < this.columnOffsets.length; ++colIdx) {
                            Column c2 = null;
                            c2 = headerColumns == null ? cf.column("col_" + colIdx) : (colIdx < headerColumns.size() ? (Column)headerColumns.get(colIdx) : cf.column("col_" + colIdx));
                            int begin = this.columnOffsets[colIdx];
                            int end = colIdx < this.columnOffsets.length - 1 ? this.columnOffsets[colIdx + 1] : line.length();
                            if (begin >= (end = Math.min(end, line.length()))) {
                                this.warnContext.addWarning(WarningsContext.WarningType.INPUT_DATA_LINE_DOES_NOT_PARSE, String.format("file=%s line=%d: line is too short", "unk", fileLines), logger);
                                break;
                            }
                            String s = line.substring(begin, end).trim();
                            r.put(c2, s);
                        }
                        if (fileLines >= (long)(this.config.skipRowsBeforeHeader + this.config.skipRowsAfterHeader + (this.config.parseHeaderRow ? 1 : 0))) {
                            ++emittedLines;
                            out.emitRow(r);
                        }
                    }
                }
                ++fileLines;
                if (emittedLines % 500L != 0L) continue;
                observer.onInterval(emittedLines);
            }
            observer.onEnd(emittedLines);
        }
        return true;
    }

    public static class Config
    implements FormatParams {
        public String offsets = "0";
        public int skipRowsBeforeHeader;
        public boolean parseHeaderRow;
        public int skipRowsAfterHeader;
        public String charset = "utf8";
    }
}

