/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.input.remote;

import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.fs.FSEnumerationSettings;
import com.dataiku.dip.fs.Globbing;
import com.dataiku.dip.input.remote.RemoteFileUtils;
import com.dataiku.dip.io.OutputStreamWrapper;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.PathUtils;
import com.google.common.collect.Lists;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPHTTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.log4j.Logger;

public class FTPRemote
implements AutoCloseable {
    FTPClient ftp;
    protected boolean binTypeSet = false;
    private String user;
    private String password;
    private static Logger logger = Logger.getLogger((String)"dku.remotefiles.ftp");

    public static boolean skip(String name) {
        return StringUtils.isBlank((String)name) || ".".equals(name) || "..".equals(name);
    }

    public List<RemoteFileUtils.RemoteFile> list(String path) throws IOException {
        ArrayList<RemoteFileUtils.RemoteFile> result = new ArrayList<RemoteFileUtils.RemoteFile>();
        logger.debug((Object)("Listing: " + path));
        for (FTPFile f : this.ftp.listFiles(path)) {
            if (FTPRemote.skip(f.getName())) continue;
            String name = path.isEmpty() || "/".equals(path) ? path + f.getName() : path + "/" + f.getName();
            if (f.isFile()) {
                result.add(new RemoteFileUtils.RemoteFile(name, f.getSize(), f.getTimestamp().getTimeInMillis()));
                continue;
            }
            if (f.isDirectory()) {
                result.add(new RemoteFileUtils.RemoteFile(name));
                continue;
            }
            if (!f.isSymbolicLink()) continue;
        }
        return result;
    }

    List<RemoteFileUtils.RemoteFile> resolveGlob(String glob) throws IOException {
        logger.info((Object)("FTP remote: expanding glob : " + glob));
        boolean isAbsolute = glob.length() > 0 && glob.charAt(0) == '/';
        Object[] segments = (isAbsolute ? glob.substring(1) : glob).split("/", -1);
        String prefix = null;
        ArrayList<String> dirs = new ArrayList<String>();
        dirs.add(isAbsolute ? "/" : "");
        logger.info((Object)("Glob segments : " + StringUtils.join((Object[])segments, (String)"--")));
        logger.info((Object)("Glob prefix=" + prefix + " isAbs=" + isAbsolute));
        ArrayList<RemoteFileUtils.RemoteFile> remoteFiles = new ArrayList<RemoteFileUtils.RemoteFile>();
        ArrayList<RemoteFileUtils.RemoteFile> result = new ArrayList<RemoteFileUtils.RemoteFile>();
        for (Object s : segments) {
            prefix = prefix == null ? (isAbsolute ? "/" : "") + (String)s : prefix + "/" + (String)s;
            result.clear();
            if (dirs.isEmpty()) {
                logger.info((Object)"End");
                return result;
            }
            logger.info((Object)("Segment " + (String)s + " prefix " + prefix));
            logger.info((Object)("-> Dirs " + StringUtils.join(dirs, (String)"--")));
            remoteFiles.clear();
            for (String d : dirs) {
                remoteFiles.addAll(this.list(d));
            }
            dirs.clear();
            for (RemoteFileUtils.RemoteFile rf : remoteFiles) {
                if (!Globbing.matchPath((String)prefix, (String)rf.name, (String)"/")) continue;
                if (rf.type == 'f') {
                    result.add(rf);
                    continue;
                }
                result.add(rf);
                dirs.add(rf.name);
            }
        }
        return result;
    }

    List<RemoteFileUtils.RemoteFile> enumerate(RemoteFileUtils.RemoteFile dir) throws IOException {
        assert (dir.type == 'd');
        ArrayList<RemoteFileUtils.RemoteFile> result = new ArrayList<RemoteFileUtils.RemoteFile>();
        ArrayList<RemoteFileUtils.RemoteFile> dirs = new ArrayList<RemoteFileUtils.RemoteFile>();
        dirs.add(dir);
        while (!dirs.isEmpty()) {
            ArrayList<RemoteFileUtils.RemoteFile> newDirs = new ArrayList<RemoteFileUtils.RemoteFile>();
            for (RemoteFileUtils.RemoteFile d : dirs) {
                for (RemoteFileUtils.RemoteFile rf : this.list(d.name)) {
                    if (rf.type == 'f') {
                        result.add(rf);
                        continue;
                    }
                    newDirs.add(rf);
                }
            }
            dirs = newDirs;
        }
        return result;
    }

    private static String rtrim(String path) {
        while (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public RemoteFileUtils.RemoteFile get(String path) throws IOException {
        if ((path = FTPRemote.rtrim(path)).isEmpty()) {
            return new RemoteFileUtils.RemoteFile("");
        }
        return new ParentInfo(path).asRemoteFile();
    }

    public boolean exists(String path) throws IOException {
        return this.get(path) != null;
    }

    public boolean isDirectory(String path) throws IOException {
        if ((path = FTPRemote.rtrim(path)).isEmpty()) {
            return true;
        }
        ParentInfo pi = new ParentInfo(path);
        return pi.child != null && pi.child.isDirectory();
    }

    public boolean isFile(String path) throws IOException {
        if ((path = FTPRemote.rtrim(path)).isEmpty()) {
            return false;
        }
        ParentInfo pi = new ParentInfo(path);
        return pi.child != null && pi.child.isFile();
    }

    public void setLastModified(String path, long lastModified) throws IOException {
        ParentInfo pi = new ParentInfo(path);
        if (pi.child != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(lastModified);
            pi.child.setTimestamp(cal);
        }
    }

    public boolean mkdirs(String path) throws IOException {
        if ((path = FTPRemote.rtrim(path)).isEmpty()) {
            return true;
        }
        ParentInfo pi = new ParentInfo(path);
        if (pi.child != null) {
            return pi.child.isDirectory();
        }
        return this.mkdirs(pi.parent) && this.ftp.makeDirectory(path);
    }

    public boolean forceRemove(String path, boolean inclusive) throws IOException {
        if ((path = FTPRemote.rtrim(path)).isEmpty()) {
            return true;
        }
        ParentInfo pi = new ParentInfo(path);
        if (pi.child == null || pi.child.isFile() && !inclusive) {
            return true;
        }
        return pi.child.isDirectory() ? this.rmdirs(path, inclusive) : this.ftp.deleteFile(path);
    }

    public boolean rmdirs(String path, boolean inclusive) throws IOException {
        FTPFile[] subs;
        if (!this.isDirectory(path = FTPRemote.rtrim(path))) {
            return true;
        }
        for (FTPFile sub : subs = this.ftp.listDirectories(path)) {
            if (FTPRemote.skip(sub.getName()) || this.rmdirs(path + "/" + sub.getName(), true)) continue;
            return false;
        }
        for (FTPFile sub : subs = this.ftp.listFiles(path)) {
            if (FTPRemote.skip(sub.getName()) || this.ftp.deleteFile(path + "/" + sub.getName())) continue;
            return false;
        }
        return !inclusive || this.ftp.removeDirectory(path);
    }

    public boolean rename(String fromPath, String toPath) throws IOException {
        String from = FTPRemote.rtrim(fromPath);
        String to = FTPRemote.rtrim(toPath);
        if (from.isEmpty()) {
            return false;
        }
        if (to.isEmpty()) {
            return false;
        }
        return this.ftp.rename(from, to);
    }

    public List<RemoteFileUtils.RemoteFile> enumerate(String prefix, int maxDepth, FSEnumerationSettings settings, int prefixLength) throws IOException {
        if (settings.firstNonEmpty) {
            return this.getFirstNonEmpty(prefix, maxDepth, 0, settings, prefixLength);
        }
        return this.enumerate(prefix, maxDepth, 0, settings.totalSizeLimit);
    }

    private List<RemoteFileUtils.RemoteFile> enumerate(String prefix, int maxDepth, int depth, long totalSizeLimit) throws IOException {
        RemoteFileUtils.RemoteFile rf = this.get(prefix);
        if (rf == null) {
            throw new FileNotFoundException("Non-existing prefix: " + prefix);
        }
        if (!rf.isDirectory()) {
            return Lists.newArrayList((Object[])new RemoteFileUtils.RemoteFile[]{rf});
        }
        if (depth > maxDepth) {
            return new ArrayList<RemoteFileUtils.RemoteFile>(0);
        }
        List<RemoteFileUtils.RemoteFile> files = this.list(FTPRemote.rtrim(prefix));
        ArrayList<RemoteFileUtils.RemoteFile> subs = new ArrayList<RemoteFileUtils.RemoteFile>();
        long currentSize = 0L;
        for (RemoteFileUtils.RemoteFile f : files) {
            if (!f.isDirectory()) {
                subs.add(f);
                currentSize += f.size;
            }
            if (totalSizeLimit < 0L || currentSize < totalSizeLimit) continue;
            return subs;
        }
        for (RemoteFileUtils.RemoteFile f : files) {
            if (!f.isDirectory()) continue;
            List<RemoteFileUtils.RemoteFile> subSubs = this.enumerate(f.path(), maxDepth, depth + 1, totalSizeLimit < 0L ? totalSizeLimit : Math.max(0L, totalSizeLimit - currentSize));
            for (RemoteFileUtils.RemoteFile subF : subSubs) {
                currentSize += subF.size;
            }
            subs.addAll(subSubs);
            if (totalSizeLimit < 0L || currentSize < totalSizeLimit) continue;
            return subs;
        }
        return subs;
    }

    private List<RemoteFileUtils.RemoteFile> getFirstNonEmpty(String prefix, int maxDepth, int depth, FSEnumerationSettings settings, int prefixLength) throws IOException {
        RemoteFileUtils.RemoteFile rf = this.get(prefix);
        if (rf == null) {
            throw new FileNotFoundException("Non-existing prefix: " + prefix);
        }
        if (!rf.isDirectory()) {
            return Lists.newArrayList((Object[])new RemoteFileUtils.RemoteFile[]{rf});
        }
        if (depth > maxDepth) {
            return new ArrayList<RemoteFileUtils.RemoteFile>(0);
        }
        List<RemoteFileUtils.RemoteFile> files = this.list(FTPRemote.rtrim(prefix));
        for (RemoteFileUtils.RemoteFile f : files) {
            if (f.isDirectory() || f.size() <= 0L || !settings.isValidPath(PathUtils.makeLeadingNoTrailing((String)f.path()).substring(prefixLength))) continue;
            return Collections.singletonList(f);
        }
        for (RemoteFileUtils.RemoteFile f : files) {
            List<RemoteFileUtils.RemoteFile> subs;
            if (!f.isDirectory() || (subs = this.getFirstNonEmpty(f.path(), maxDepth, depth + 1, settings, prefixLength)).isEmpty()) continue;
            return subs;
        }
        return new ArrayList<RemoteFileUtils.RemoteFile>(0);
    }

    protected void setBinaryFileType() throws IOException {
        if (!this.binTypeSet) {
            this.binTypeSet = this.ftp.setFileType(2);
            if (!this.binTypeSet) {
                logger.warn((Object)"Cannot set binary file type");
            }
        }
    }

    public InputStream getInputStream(String path) throws IOException {
        this.setBinaryFileType();
        InputStream inputStream = this.ftp.retrieveFileStream(path);
        if (inputStream == null) {
            throw ErrorContext.ioef((String)"Cannot get input stream for `%s`.\nServer replied %d - `%s`", (Object)path, (Object[])new Object[]{this.ftp.getReplyCode(), this.ftp.getReplyString()});
        }
        return new FTPRemoteInputStream(inputStream);
    }

    public OutputStream getOutputStream(String path) throws IOException {
        this.setBinaryFileType();
        OutputStream outputStream = this.ftp.storeFileStream(path);
        if (outputStream == null) {
            throw ErrorContext.ioef((String)"Cannot get output stream for `%s`.\nServer replied %d - `%s`", (Object)path, (Object[])new Object[]{this.ftp.getReplyCode(), this.ftp.getReplyString()});
        }
        return new FTPRemoteOutputStream(outputStream);
    }

    public FTPRemote(String host, int port, String user, String password, boolean passive, @Nullable ProxySettings proxy, int timeout) throws IOException {
        if (proxy != null && proxy.hasProxy()) {
            if (proxy.isHTTP()) {
                this.ftp = proxy.hasAuthentication() ? new EnhancedFTPHTTPClient(host, proxy.host, proxy.port, proxy.username, proxy.password) : new EnhancedFTPHTTPClient(host, proxy.host, proxy.port);
            } else {
                this.ftp = new FTPClient();
                this.ftp.setProxy(proxy.getProxy());
            }
        } else {
            this.ftp = new FTPClient();
        }
        try {
            logger.info((Object)("Connecting to " + host));
            this.ftp.setConnectTimeout(timeout);
            this.ftp.connect(host, port);
            int reply = this.ftp.getReplyCode();
            if (FTPReply.isPositiveCompletion((int)reply)) {
                for (String s : this.ftp.getReplyStrings()) {
                    logger.info((Object)s);
                }
            } else {
                throw new IOException("FTP connection failed : " + this.ftp.getReplyString());
            }
            if (user == null || user.isEmpty()) {
                this.user = "anonymous";
                this.password = "anonymous";
            } else if (password == null) {
                this.password = "";
            } else {
                this.user = user;
                this.password = password;
            }
            if (this.ftp.login(this.user, this.password)) {
                for (String s : this.ftp.getReplyStrings()) {
                    logger.info((Object)s);
                }
            } else {
                throw new IOException("FTP login failed : " + this.ftp.getReplyString());
            }
            if (!this.ftp.setFileType(2)) {
                logger.warn((Object)("Error setting FTP binary mode : " + this.ftp.getReplyString()));
            }
            if (passive) {
                logger.info((Object)"Using passive mode");
                this.ftp.enterLocalPassiveMode();
            }
            this.ftp.setControlKeepAliveTimeout(30000L);
            this.ftp.setDataTimeout(30000);
        }
        catch (Exception e) {
            this.close();
            throw new IOException("error connecting to FTP server " + host, e);
        }
    }

    @Override
    public void close() {
        if (this.ftp != null && this.ftp.isConnected()) {
            try {
                this.ftp.disconnect();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.ftp = null;
    }

    public boolean isClosed() {
        return this.ftp == null || !this.ftp.isConnected();
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    private class ParentInfo {
        final String path;
        final String parent;
        final String childName;
        final FTPFile child;

        ParentInfo(String path) throws IOException {
            this.path = path = FTPRemote.rtrim(path);
            int sep = path.lastIndexOf(47);
            this.parent = sep < 0 ? "" : path.substring(0, sep + 1);
            this.childName = sep < 0 ? path : path.substring(sep + 1);
            for (FTPFile file : FTPRemote.this.ftp.listFiles(this.parent)) {
                if (!file.getName().equals(this.childName)) continue;
                this.child = file;
                return;
            }
            this.child = null;
        }

        RemoteFileUtils.RemoteFile asRemoteFile() {
            if (this.child != null) {
                if (this.child.isFile()) {
                    return new RemoteFileUtils.RemoteFile(this.path, this.child.getSize(), this.child.getTimestamp().getTimeInMillis());
                }
                if (this.child.isDirectory()) {
                    return new RemoteFileUtils.RemoteFile(this.path);
                }
            }
            return null;
        }
    }

    class FTPRemoteInputStream
    extends FilterInputStream {
        protected boolean closed;

        FTPRemoteInputStream(InputStream in) {
            super(in);
            this.closed = false;
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            super.close();
            this.in.close();
            FTPRemote.this.ftp.completePendingCommand();
        }
    }

    class FTPRemoteOutputStream
    extends OutputStreamWrapper {
        protected boolean closed;

        FTPRemoteOutputStream(OutputStream out) {
            super(out);
            this.closed = false;
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            super.close();
            if (!FTPRemote.this.ftp.completePendingCommand()) {
                throw ErrorContext.ioef((String)"Write failed. Server replied %d - `%s`", (Object)FTPRemote.this.ftp.getReplyCode(), (Object[])new Object[]{FTPRemote.this.ftp.getReplyString()});
            }
        }
    }

    protected static class EnhancedFTPHTTPClient
    extends FTPHTTPClient {
        final String passiveHost;

        public EnhancedFTPHTTPClient(String host, String proxyHost, int proxyPort, String proxyUser, String proxyPass) {
            super(proxyHost, proxyPort, proxyUser, proxyPass);
            this.passiveHost = host;
        }

        public EnhancedFTPHTTPClient(String host, String proxyHost, int proxyPort) {
            super(proxyHost, proxyPort);
            this.passiveHost = host;
        }

        public String getPassiveHost() {
            String host = super.getPassiveHost();
            if ("0.0.0.0".equals(host)) {
                return this.passiveHost;
            }
            return host;
        }
    }
}

