/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.integrations;

import com.dataiku.dip.integrations.IntegrationHooksRegistry;
import com.dataiku.dip.integrations.IntegrationParams;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import java.util.Objects;

public class IntegrationHook {
    public String type;
    public IntegrationParams configuration;

    public String getType() {
        return this.type;
    }

    public IntegrationParams getConfiguration() {
        return this.configuration;
    }

    public <T extends IntegrationParams> T getConfigurationAs(Class<T> clazz) {
        return (T)((IntegrationParams)clazz.cast(this.configuration));
    }

    public IntegrationHook withType(String type) {
        this.type = type;
        return this;
    }

    public IntegrationHook withConfiguration(IntegrationParams configuration) {
        this.configuration = configuration;
        return this;
    }

    public static void registerAdapter() {
        JSON.registerAdapter(IntegrationHook.class, (Object)new JSON.Adapter<IntegrationHook>(){

            public IntegrationHook deserialize(JsonElement json, Type type, JsonDeserializationContext ctx) throws JsonParseException {
                JsonElement jsonParams;
                JsonObject jsonObj = json.getAsJsonObject();
                IntegrationHook messaging = new IntegrationHook();
                JsonElement jsonType = jsonObj.get("type");
                if (jsonType != null) {
                    messaging = messaging.withType(jsonType.getAsString());
                }
                if ((jsonParams = jsonObj.get("configuration")) != null && jsonType != null) {
                    messaging = messaging.withConfiguration((IntegrationParams)ctx.deserialize(jsonParams, IntegrationHooksRegistry.getMeta(messaging).configurationClass()));
                }
                return messaging;
            }

            public JsonElement serialize(IntegrationHook messaging, Type type, JsonSerializationContext ctx) {
                JsonObject jsonObj = new JsonObject();
                jsonObj.addProperty("type", messaging.getType());
                if (messaging.getConfiguration() != null) {
                    jsonObj.add("configuration", ctx.serialize((Object)messaging.getConfiguration(), IntegrationHooksRegistry.getMeta(messaging).configurationClass()));
                }
                return jsonObj;
            }
        });
    }

    public int hashCode() {
        return Objects.hash(this.type, JSON.json((Object)this.configuration));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntegrationHook other = (IntegrationHook)o;
        if (!Objects.equals(this.type, other.type)) {
            return false;
        }
        if (this.configuration == null) {
            return other.configuration == null;
        }
        return other.configuration != null && Objects.equals(this.configuration.getClass(), other.configuration.getClass()) && Objects.equals(JSON.json((Object)this.configuration), JSON.json((Object)other.configuration));
    }
}

