/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.labeling;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.labeling.LabelingService;
import com.dataiku.dip.labeling.LabelingTask;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.shaker.filter.FilterRequest;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.shaker.server.DataService;
import com.dataiku.dip.shaker.server.MemScriptRunner;
import com.dataiku.dip.shaker.server.SerializedMemTableV2;
import com.dataiku.dip.shaker.server.SerializedTableChunk;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LabelingImageService {
    @Autowired
    private DataService dataService;
    @Autowired
    private LabelingService labelingService;

    public SerializedMemTableV2 refreshImagesDataSample_NT(LabelingTask labelingTask, int nbRows, AuthCtx user) throws Exception {
        Dataset metadataDataset = this.labelingService.getMetadataDataset(labelingTask);
        SerializedShakerScript sss = new SerializedShakerScript();
        sss.contextProjectKey = labelingTask.projectKey;
        MemScriptRunner.TableWithReport twr = this.dataService.get_NOTRANSACTION(metadataDataset, sss, null, new FilterRequest(), true, user);
        SerializedMemTableV2 result = new SerializedMemTableV2();
        result.fill(twr, sss, nbRows, Integer.MAX_VALUE);
        return result;
    }

    public SerializedTableChunk getImagesMetadataChunk_NT(LabelingTask labelingTask, AuthCtx user, int nbRows, int offset) throws Exception {
        Dataset metadataDataset = this.labelingService.getMetadataDataset(labelingTask);
        SerializedShakerScript sss = new SerializedShakerScript();
        sss.contextProjectKey = labelingTask.projectKey;
        MemScriptRunner.TableWithReport dataTable = this.dataService.get_NOTRANSACTION(metadataDataset, sss, null, new FilterRequest(), true, user);
        SerializedTableChunk stc = new SerializedTableChunk(offset, nbRows, 0, dataTable.table.columnsList.size());
        stc.fill(dataTable.table, dataTable.filters, sss.coloring, sss.columnsSelection);
        return stc;
    }
}

