/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.kernel.KernelPool;
import com.dataiku.dip.llm.LLMRelatedPoolablePythonServer;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Nonnull;
import org.apache.log4j.Logger;

public abstract class LLMRelatedPoolablePythonServerKernelPool<S extends LLMRelatedPoolablePythonServer, G, D extends G> {
    protected KernelPool<S, G, D> manager;
    protected final ExecutorService executorService;
    private static final Logger logger = Logger.getLogger((String)"dku.llm.poolableserver");

    public LLMRelatedPoolablePythonServerKernelPool(String threadsNamePrefix) {
        this.executorService = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat(threadsNamePrefix + "-%d").build());
    }

    protected void setManager(KernelPool<S, G, D> manager) {
        this.manager = manager;
    }

    public KernelPool.PoolDump dump(boolean full) {
        return this.manager.dump(full);
    }

    public void killAllRequests() {
        this.manager.killAllRequests();
    }

    public void killAllKernels(KernelPool.DeathReason reason) {
        this.manager.killAllKernels(reason);
    }

    public abstract class LLMRelatedPoolablePythonServerKernelController
    implements KernelPool.KernelController<S, G, D> {
        protected final String propertiesPrefix;

        public LLMRelatedPoolablePythonServerKernelController(String propertiesPrefix) {
            this.propertiesPrefix = propertiesPrefix;
        }

        public int getGlobalMaxKernelCount() {
            return ApplicationConfigurator.getParams().getIntParam(this.propertiesPrefix + ".maxKernels", Integer.valueOf(10));
        }

        public int getAutoscaleTimeWindowSeconds() {
            return ApplicationConfigurator.getParams().getIntParam(this.propertiesPrefix + ".autoscaleWindowSeconds", Integer.valueOf(600));
        }

        public boolean isAlive(S kernel) {
            return ((LLMRelatedPoolablePythonServer)kernel).isAlive();
        }

        public String getKernelId(S kernel) {
            return ((LLMRelatedPoolablePythonServer)kernel).getKernelId();
        }

        @Nonnull
        public CompletableFuture<Void> killKernel(S kernel) {
            return CompletableFuture.runAsync(() -> {
                try {
                    kernel.close();
                }
                catch (Exception e) {
                    logger.error((Object)"Error while closing kernel", (Throwable)e);
                }
            }, LLMRelatedPoolablePythonServerKernelPool.this.executorService);
        }
    }
}

