/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.langchain;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.autoconfig.ParamDesc;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.code.CodeEnvSelector;
import com.dataiku.dip.containers.exec.ContainerExecConfigSelector;
import com.dataiku.dip.custom.PluginSettingsResolver;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.io.CustomPythonKernelException;
import com.dataiku.dip.llm.langchain.AbstractAgentLLMClient;
import com.dataiku.dip.llm.langchain.PythonLLMServer;
import com.dataiku.dip.llm.langchain.PythonLLMServerKernelPool;
import com.dataiku.dip.plugins.IPluginsRegistryService;
import com.dataiku.dip.savedmodels.agents.AgentTypesRegistry;
import com.dataiku.dip.savedmodels.agents.CustomAgentMeta;
import com.dataiku.dip.savedmodels.agents.CustomAgentsService;
import com.dataiku.dip.savedmodels.agents.LoadedCustomAgent;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;

public class PluginAgentLLMClient
extends AbstractAgentLLMClient {
    protected final CustomAgentMeta meta;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.llm.python");

    public PluginAgentLLMClient(DSSAuthCtx authCtx, String projectKey, SavedModel sm, SavedModel.SavedModelInlineVersion smiv, boolean devKernel) {
        super(authCtx, projectKey, sm, smiv, devKernel);
        this.meta = AgentTypesRegistry.getMeta(smiv.pluginAgentType);
    }

    @Override
    protected synchronized void initOnce() throws IOException {
        block7: {
            if (this.serverAPI == null) {
                try {
                    LoadedCustomAgent desc = (LoadedCustomAgent)this.meta.getLoadedDesc();
                    CodeEnvSelector envSelector = new CodeEnvSelector();
                    String envName = envSelector.selectForCustomPythonRecipe(desc.ownerPluginId);
                    String containerConfName = new ContainerExecConfigSelector().selectConfName_autoTXN(this.authCtx, this.savedModel.projectKey, this.smiv.pluginAgentSettings.containerExecSelection);
                    String clusterId = new ClusterSelector().selectForProject(this.authCtx, this.savedModel.projectKey).getClusterId();
                    IPluginsRegistryService pluginsService = (IPluginsRegistryService)SpringUtils.getBean(IPluginsRegistryService.class);
                    File pluginFolder = pluginsService.getActualPluginFolder(desc.ownerPluginId);
                    File codeFolder = new File(pluginFolder, desc.folderName);
                    CustomAgentsService customAgentsService = (CustomAgentsService)SpringUtils.getBean(CustomAgentsService.class);
                    String libFolder = customAgentsService.getPythonLibFolder(desc.getType());
                    String code = DKUFileUtils.readFileToStringUTF8((File)new File(codeFolder, "agent.py"));
                    PluginSettingsResolver.ResolvedSettings expandedPluginSettings = customAgentsService.getExpandedPluginSettings(desc.getType(), this.authCtx, this.savedModel.projectKey, this.smiv.pluginAgentConfig);
                    JsonArray passwordParams = desc.getParams().stream().filter(paramDesc -> paramDesc.type == ParamDesc.Type.PASSWORD).map(paramDesc -> paramDesc.name).collect(JsonArray::new, JsonArray::add, JsonArray::addAll);
                    expandedPluginSettings.pluginConfig.add("dkuPasswordParams", (JsonElement)passwordParams);
                    PythonLLMServerKernelPool kernelPool = (PythonLLMServerKernelPool)SpringUtils.getBean(PythonLLMServerKernelPool.class);
                    if (this.isDevMode()) {
                        File logBaseDir = DKUApp.getFile((String[])new String[]{"saved_models", this.savedModel.projectKey, this.savedModel.id, "versions", this.smiv.versionId, "logs"});
                        PythonLLMServer server = new PythonLLMServer(this.authCtx, this.savedModel.projectKey, this.savedModel.id, this.smiv.versionId, null, code, envName, containerConfName, desc.ownerPluginId, libFolder, logBaseDir, expandedPluginSettings.config, expandedPluginSettings.pluginConfig, true, false, false);
                        try {
                            server.start();
                        }
                        catch (Exception e) {
                            logger.warn((Object)"Kernel failed to start, closing it", (Throwable)e);
                            IOUtils.closeQuietly((Closeable)server, null);
                            throw e;
                        }
                        this.serverAPI = server;
                        break block7;
                    }
                    this.serverAPI = kernelPool.getServerAPI(this.authCtx, this.savedModel.projectKey, this.savedModel.id, this.smiv, null, code, expandedPluginSettings.config, expandedPluginSettings.pluginConfig, envName, containerConfName, desc.ownerPluginId, libFolder, false, clusterId, this.smiv.pluginAgentSettings, this.devKernel);
                }
                catch (CustomPythonKernelException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new IOException("Failed to initialize Python LLM", e);
                }
            }
        }
    }

    @Override
    public String getProviderId() {
        LoadedCustomAgent desc = (LoadedCustomAgent)this.meta.getLoadedDesc();
        return "plugin-agent:" + desc.getOwnerPluginId();
    }
}

