/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.online.openai;

import com.dataiku.dip.llm.online.marshall.CoreCompletionSettings;
import com.dataiku.dip.llm.online.marshall.CoreCompletionSettingsValidator;
import com.dataiku.dip.llm.online.openai.OpenAIMode;
import com.dataiku.dip.utils.NotImplementedException;

public class OpenAITextCompletionSettingsValidator {
    private static final CoreCompletionSettingsValidator azureLLMValidator = new CoreCompletionSettingsValidator("Azure LLM").allowMaxTokens().allowTemperature().allowTopP().allowFrequencyPenalty().allowPresencePenalty().allowLogitBias().allowStopSequences();
    private static final CoreCompletionSettingsValidator openAIValidator = new CoreCompletionSettingsValidator("OpenAI", azureLLMValidator).allowLogProbs();
    private static final CoreCompletionSettingsValidator azureOpenAIValidator = new CoreCompletionSettingsValidator("Azure OpenAI", azureLLMValidator).allowLogProbs();

    public void validate(OpenAIMode mode, CoreCompletionSettings ccs) {
        switch (mode) {
            case OPENAI: {
                openAIValidator.validate(ccs);
                break;
            }
            case AZURE_OPENAI: {
                azureOpenAIValidator.validate(ccs);
                break;
            }
            case AZURE_LLM: {
                azureLLMValidator.validate(ccs);
                break;
            }
            case NVIDIA_NIM: {
                throw new NotImplementedException("NVIDIA NIM does not implement legacy completion support.");
            }
            default: {
                throw new IllegalArgumentException(String.format("Unknown mode: %s", mode.name()));
            }
        }
    }
}

