/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.online.sagemakergeneric;

import com.dataiku.dip.connections.AbstractLLMConnection;
import com.dataiku.dip.connections.SageMakerGenericLLMConnection;
import com.dataiku.dip.llm.online.LLMClient;
import com.dataiku.dip.llm.online.anthropic.RawAnthropicClient;
import com.dataiku.dip.llm.online.cohere.RawCohereClient;
import com.dataiku.dip.llm.online.huggingface.RawHuggingFaceInferenceAPIClient;
import com.dataiku.dip.llm.online.marshall.CoreCompletionSettings;
import com.dataiku.dip.llm.online.marshall.CoreCompletionSettingsValidator;
import com.dataiku.dip.llm.online.marshall.FinishReasonResponseAdapter;
import com.dataiku.dip.llm.online.sagemakergeneric.GenericLLMHandling;
import com.dataiku.dip.shaker.processors.expr.TokenizedText;
import com.dataiku.dip.util.JsonUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JF;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.com.google.common.base.MoreObjects;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.jayway.jsonpath.InvalidPathException;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.io.IOException;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.text.StringEscapeUtils;

public interface GenericTextCompletionLLMMarshall {
    public JsonObject prepareTextCompletionQuery(String var1, CoreCompletionSettings var2);

    public LLMClient.SimpleCompletionResponse parseTextCompletionResponse(JsonElement var1, String var2) throws IOException;

    public EnrichedStreamedCompletionResponseChunk parseTextCompletionChunk(JsonObject var1);

    public static GenericTextCompletionLLMMarshall get(GenericLLMHandling family, AbstractLLMConnection.AbstractLLMConnectionParams params) {
        switch (family) {
            case AMAZON_TITAN: {
                return new AmazonTitanCompletionModeMarshall();
            }
            case AI21_J2: {
                return new AI21Jurassic2LLMMarshall();
            }
            case AI21_SUMMARIZE: {
                return new AI21SummarizeLLMMarshall();
            }
            case ANTHROPIC_CLAUDE: {
                return new AnthropicClaudeCompletionLLMMarshall();
            }
            case COHERE_COMMAND: {
                return new CohereCommandLLMMarshall();
            }
            case HUGGING_FACE: {
                return new HuggingFaceLLMMarshall();
            }
            case META_LLAMA_2_BEDROCK: 
            case META_LLAMA_3_BEDROCK: {
                return new MetaLlamaBedrockLLMMarshall();
            }
            case META_LLAMA_2_SAGEMAKER: {
                return new MetaLlama2SageMakerLLMMarshall();
            }
            case MISTRAL_AI: {
                return new MistralAILLMMarshall();
            }
            case FULLY_CUSTOM: {
                if (params instanceof SageMakerGenericLLMConnection.SageMakerGenericLLMConnectionParams) {
                    return new FullyCustomLLMMarshall((SageMakerGenericLLMConnection.SageMakerGenericLLMConnectionParams)params);
                }
                throw new IllegalArgumentException("Fully custom handling mode is only applicable for SageMaker connections. Received " + params.getClass().getName() + " connection params.");
            }
        }
        throw new Error("Unknown GenericLLMHandling family for text completion: " + String.valueOf((Object)family));
    }

    public static class AmazonTitanCompletionModeMarshall
    implements GenericTextCompletionLLMMarshall {
        private static final boolean STOP_SEQUENCES_FORWARDING_ENABLED = false;
        private static final CoreCompletionSettingsValidator validator = new CoreCompletionSettingsValidator("AWS Titan").allowMaxTokens().allowTemperature().allowTopP();

        @Override
        public JsonObject prepareTextCompletionQuery(String prompt, CoreCompletionSettings ccs) {
            validator.validate(ccs);
            JF.ObjectBuilder ob = JF.obj();
            ob.with("inputText", prompt);
            JF.ObjectBuilder textGenerationConfig = JF.obj();
            if (ccs.maxTokens != null) {
                textGenerationConfig.with("maxTokenCount", (Number)ccs.maxTokens);
            } else {
                textGenerationConfig.with("maxTokenCount", (Number)2048);
            }
            if (ccs.temperature != null) {
                textGenerationConfig.with("temperature", (Number)ccs.temperature);
            }
            if (ccs.topP != null) {
                textGenerationConfig.with("topP", (Number)ccs.topP);
            }
            if (ccs.stopSequences == null || !ccs.stopSequences.isEmpty()) {
                // empty if block
            }
            ob.with("textGenerationConfig", (JsonElement)textGenerationConfig.get());
            return ob.get();
        }

        @Override
        public LLMClient.SimpleCompletionResponse parseTextCompletionResponse(JsonElement response, String prompt) throws IOException {
            JsonObject jo = response instanceof JsonArray ? (JsonObject)((JsonArray)response).get(0) : (JsonObject)response;
            JsonObject result = jo.get("results").getAsJsonArray().get(0).getAsJsonObject();
            LLMClient.SimpleCompletionResponse ret = new LLMClient.SimpleCompletionResponse();
            ret.text = result.get("outputText").getAsString();
            String completionReason = result.get("completionReason").getAsString();
            ret.finishReason = FinishReasonResponseAdapter.adapt(completionReason);
            ret.promptTokens = jo.get("inputTextTokenCount").getAsInt();
            ret.completionTokens = result.get("tokenCount").getAsInt();
            return ret;
        }

        @Override
        public EnrichedStreamedCompletionResponseChunk parseTextCompletionChunk(JsonObject jo) {
            EnrichedStreamedCompletionResponseChunk ret = new EnrichedStreamedCompletionResponseChunk();
            ret.chunk.text = jo.get("outputText").getAsString();
            String completionReason = JsonUtils.getStringMemberOrNull(jo, "completionReason");
            if (completionReason != null) {
                ret.finishReason = FinishReasonResponseAdapter.adapt(completionReason);
            }
            if (jo.has("amazon-bedrock-invocationMetrics")) {
                ret.promptTokens = jo.get("amazon-bedrock-invocationMetrics").getAsJsonObject().get("inputTokenCount").getAsInt();
                ret.completionTokens = jo.get("amazon-bedrock-invocationMetrics").getAsJsonObject().get("outputTokenCount").getAsInt();
            }
            return ret;
        }
    }

    public static class AI21Jurassic2LLMMarshall
    implements GenericTextCompletionLLMMarshall {
        private static final CoreCompletionSettingsValidator validator = new CoreCompletionSettingsValidator("AWS AI21 Jurassic-2").allowMaxTokens().allowTemperature().allowTopP().allowFrequencyPenalty().allowPresencePenalty().allowStopSequences();

        @Override
        public JsonObject prepareTextCompletionQuery(String prompt, CoreCompletionSettings ccs) {
            validator.validate(ccs);
            JF.ObjectBuilder ob = JF.obj();
            ob.with("prompt", prompt);
            if (ccs.maxTokens == null) {
                ob.with("maxTokens", (Number)2048);
            } else {
                ob.with("maxTokens", (Number)ccs.maxTokens);
            }
            if (ccs.temperature != null) {
                ob.with("temperature", (Number)ccs.temperature);
            }
            if (ccs.topP != null) {
                ob.with("topP", (Number)ccs.topP);
            }
            if (ccs.frequencyPenalty != null) {
                ob.with("frequencyPenalty", (JsonElement)JF.obj().with("scale", (Number)ccs.frequencyPenalty).get());
            }
            if (ccs.presencePenalty != null) {
                ob.with("presencePenalty", (JsonElement)JF.obj().with("scale", (Number)ccs.presencePenalty).get());
            }
            if (ccs.stopSequences != null && !ccs.stopSequences.isEmpty()) {
                ob.with("stopSequences", ccs.stopSequences);
            }
            return ob.get();
        }

        @Override
        public LLMClient.SimpleCompletionResponse parseTextCompletionResponse(JsonElement response, String prompt) {
            JsonObject jo = response instanceof JsonArray ? (JsonObject)((JsonArray)response).get(0) : (JsonObject)response;
            LLMClient.SimpleCompletionResponse ret = new LLMClient.SimpleCompletionResponse();
            JsonObject firstCompletion = jo.get("completions").getAsJsonArray().get(0).getAsJsonObject();
            ret.text = firstCompletion.get("data").getAsJsonObject().get("text").getAsString();
            String finishReason = firstCompletion.get("finishReason").getAsJsonObject().get("reason").getAsString();
            ret.finishReason = FinishReasonResponseAdapter.adapt(finishReason);
            ret.promptTokens = JsonUtils.getOrEmptyArr(jo, "prompt", "tokens").size();
            ret.completionTokens = JsonUtils.getOrEmptyArr(firstCompletion, "data", "tokens").size();
            return ret;
        }

        @Override
        public EnrichedStreamedCompletionResponseChunk parseTextCompletionChunk(JsonObject jo) {
            throw new IllegalArgumentException("Streaming not supported on AI21");
        }
    }

    public static class AI21SummarizeLLMMarshall
    implements GenericTextCompletionLLMMarshall {
        private static final CoreCompletionSettingsValidator validator = new CoreCompletionSettingsValidator("AWS AI21 Summarize");

        @Override
        public JsonObject prepareTextCompletionQuery(String prompt, CoreCompletionSettings ccs) {
            validator.validate(ccs);
            JF.ObjectBuilder ob = JF.obj();
            ob.with("source", prompt);
            ob.with("sourceType", "TEXT");
            return ob.get();
        }

        @Override
        public LLMClient.SimpleCompletionResponse parseTextCompletionResponse(JsonElement response, String prompt) {
            JsonObject jo = (JsonObject)response;
            LLMClient.SimpleCompletionResponse ret = new LLMClient.SimpleCompletionResponse();
            ret.text = jo.get("summary").getAsString();
            return ret;
        }

        @Override
        public EnrichedStreamedCompletionResponseChunk parseTextCompletionChunk(JsonObject jo) {
            throw new IllegalArgumentException("Streaming not supported on AI21");
        }
    }

    public static class AnthropicClaudeCompletionLLMMarshall
    implements GenericTextCompletionLLMMarshall {
        private static final CoreCompletionSettingsValidator validator = new CoreCompletionSettingsValidator("AWS Anthropic Claude").allowMaxTokens().allowTemperature().allowTopK().allowTopP().allowStopSequences();

        @Override
        public JsonObject prepareTextCompletionQuery(String prompt, CoreCompletionSettings ccs) {
            validator.validate(ccs);
            ccs.maxTokens = (Integer)MoreObjects.firstNonNull((Object)ccs.maxTokens, (Object)2048);
            return RawAnthropicClient.buildCompleteQuery(null, prompt, ccs);
        }

        @Override
        public LLMClient.SimpleCompletionResponse parseTextCompletionResponse(JsonElement response, String prompt) {
            JsonObject jo = (JsonObject)response;
            LLMClient.SimpleCompletionResponse ret = new LLMClient.SimpleCompletionResponse();
            ret.text = jo.get("completion").getAsString();
            String stopReason = jo.get("stop_reason").getAsString();
            ret.finishReason = FinishReasonResponseAdapter.adapt(stopReason);
            ret.promptTokens = (int)(2.5f * (float)new TokenizedText(prompt).size());
            ret.completionTokens = (int)(2.5f * (float)new TokenizedText(ret.text).size());
            ret.tokenCountsAreEstimated = true;
            return ret;
        }

        @Override
        public EnrichedStreamedCompletionResponseChunk parseTextCompletionChunk(JsonObject jo) {
            EnrichedStreamedCompletionResponseChunk ret = new EnrichedStreamedCompletionResponseChunk();
            ret.chunk.text = jo.get("completion").getAsString();
            String stopReason = JsonUtils.getStringMemberOrNull(jo, "stop_reason");
            if (stopReason != null) {
                ret.finishReason = FinishReasonResponseAdapter.adapt(stopReason);
            }
            if (jo.has("amazon-bedrock-invocationMetrics")) {
                ret.promptTokens = jo.get("amazon-bedrock-invocationMetrics").getAsJsonObject().get("inputTokenCount").getAsInt();
                ret.completionTokens = jo.get("amazon-bedrock-invocationMetrics").getAsJsonObject().get("outputTokenCount").getAsInt();
            }
            return ret;
        }
    }

    public static class CohereCommandLLMMarshall
    implements GenericTextCompletionLLMMarshall {
        private static final CoreCompletionSettingsValidator validator = new CoreCompletionSettingsValidator("AWS Cohere command").allowMaxTokens().allowTemperature().allowTopK().allowTopP().allowStopSequences();

        @Override
        public JsonObject prepareTextCompletionQuery(String prompt, CoreCompletionSettings ccs) {
            validator.validate(ccs);
            ccs.maxTokens = (Integer)MoreObjects.firstNonNull((Object)ccs.maxTokens, (Object)2048);
            return RawCohereClient.buildCompleteQuery(null, prompt, ccs);
        }

        @Override
        public LLMClient.SimpleCompletionResponse parseTextCompletionResponse(JsonElement response, String prompt) {
            JsonObject jo = response instanceof JsonArray ? (JsonObject)((JsonArray)response).get(0) : (JsonObject)response;
            LLMClient.SimpleCompletionResponse ret = new LLMClient.SimpleCompletionResponse();
            JsonObject firstGen = jo.get("generations").getAsJsonArray().get(0).getAsJsonObject();
            ret.text = firstGen.get("text").getAsString();
            String finishReason = firstGen.get("finish_reason").getAsString();
            ret.finishReason = FinishReasonResponseAdapter.adapt(finishReason);
            ret.promptTokens = (int)(2.5f * (float)new TokenizedText(prompt).size());
            ret.completionTokens = (int)(2.5f * (float)new TokenizedText(ret.text).size());
            ret.tokenCountsAreEstimated = true;
            return ret;
        }

        @Override
        public EnrichedStreamedCompletionResponseChunk parseTextCompletionChunk(JsonObject jo) {
            throw new IllegalArgumentException("Streaming not supported on Cohere");
        }
    }

    public static class HuggingFaceLLMMarshall
    implements GenericTextCompletionLLMMarshall {
        private static final CoreCompletionSettingsValidator validator = new CoreCompletionSettingsValidator("HuggingFace").allowMaxTokens().allowTemperature().allowTopK().allowTopP();

        @Override
        public JsonObject prepareTextCompletionQuery(String prompt, CoreCompletionSettings ccs) {
            validator.validate(ccs);
            JF.ObjectBuilder ob = JF.obj().with("inputs", prompt);
            JF.ObjectBuilder params = JF.obj();
            if (ccs.maxTokens != null) {
                params.with("max_new_tokens", (Number)ccs.maxTokens);
            } else {
                params.with("max_new_tokens", (Number)250);
            }
            if (ccs.temperature != null) {
                params.with("temperature", (Number)ccs.temperature);
            }
            if (ccs.topK != null) {
                ob.with("top_k", (Number)ccs.topK);
            }
            if (ccs.topP != null) {
                ob.with("top_p", (Number)ccs.topP);
            }
            ob.with("parameters", (JsonElement)params.get());
            return ob.get();
        }

        @Override
        public LLMClient.SimpleCompletionResponse parseTextCompletionResponse(JsonElement response, String prompt) throws IOException {
            JsonElement elemResponse;
            if (response instanceof JsonArray) {
                JsonArray rcr = (JsonArray)response;
                if (rcr == null || rcr.size() != 1) {
                    throw new IOException("HuggingFace API did not respond with valid completion");
                }
                elemResponse = rcr.get(0);
            } else {
                elemResponse = response;
            }
            RawHuggingFaceInferenceAPIClient.RawGenerationGeneration rgg = (RawHuggingFaceInferenceAPIClient.RawGenerationGeneration)JSON.parse((JsonElement)elemResponse, RawHuggingFaceInferenceAPIClient.RawGenerationGeneration.class);
            if (rgg == null) {
                throw new IOException("HuggingFace API did not respond with valid completion");
            }
            LLMClient.SimpleCompletionResponse ret = new LLMClient.SimpleCompletionResponse();
            ret.text = rgg.generated_text;
            return ret;
        }

        @Override
        public EnrichedStreamedCompletionResponseChunk parseTextCompletionChunk(JsonObject jo) {
            throw new IllegalArgumentException("Streaming not supported on HuggingFace");
        }
    }

    public static class MetaLlamaBedrockLLMMarshall
    implements GenericTextCompletionLLMMarshall {
        private static final CoreCompletionSettingsValidator validator = new CoreCompletionSettingsValidator("Bedrock Meta LLaMa").allowMaxTokens().allowTemperature().allowTopP();

        @Override
        public JsonObject prepareTextCompletionQuery(String prompt, CoreCompletionSettings ccs) {
            validator.validate(ccs);
            JF.ObjectBuilder ob = JF.obj();
            ob.with("prompt", prompt);
            if (ccs.maxTokens == null) {
                ob.with("max_gen_len", (Number)2048);
            } else {
                ob.with("max_gen_len", (Number)ccs.maxTokens);
            }
            if (ccs.temperature != null) {
                ob.with("temperature", (Number)ccs.temperature);
            }
            if (ccs.topP != null) {
                ob.with("top_p", (Number)ccs.topP);
            }
            return ob.get();
        }

        @Override
        public LLMClient.SimpleCompletionResponse parseTextCompletionResponse(JsonElement response, String prompt) {
            JsonObject jo = response instanceof JsonArray ? (JsonObject)((JsonArray)response).get(0) : (JsonObject)response;
            LLMClient.SimpleCompletionResponse ret = new LLMClient.SimpleCompletionResponse();
            ret.text = jo.get("generation").getAsString();
            String stopReason = jo.get("stop_reason").getAsString();
            ret.finishReason = FinishReasonResponseAdapter.adapt(stopReason);
            ret.promptTokens = jo.get("prompt_token_count").getAsInt();
            ret.completionTokens = jo.get("generation_token_count").getAsInt();
            return ret;
        }

        @Override
        public EnrichedStreamedCompletionResponseChunk parseTextCompletionChunk(JsonObject jo) {
            throw new IllegalArgumentException("Streaming not supported on LLaMa");
        }
    }

    public static class MetaLlama2SageMakerLLMMarshall
    implements GenericTextCompletionLLMMarshall {
        private static final CoreCompletionSettingsValidator validator = new CoreCompletionSettingsValidator("SageMaker Meta LLaMa").allowMaxTokens().allowTemperature().allowTopP();
        private static final DKULogger logger = DKULogger.getLogger((String)"dku.llm.marshall.text_completion.sagemaker_llama");

        @Override
        public JsonObject prepareTextCompletionQuery(String prompt, CoreCompletionSettings ccs) {
            validator.validate(ccs);
            JF.ObjectBuilder ob = JF.obj();
            ob.with("inputs", prompt);
            JF.ObjectBuilder params = JF.obj();
            if (ccs.maxTokens == null) {
                params.with("max_new_tokens", (Number)2048);
            } else {
                params.with("max_new_tokens", (Number)ccs.maxTokens);
            }
            if (ccs.temperature != null) {
                params.with("temperature", (Number)ccs.temperature);
            }
            if (ccs.topP != null) {
                params.with("top_p", (Number)ccs.topP);
            }
            ob.with("parameters", (JsonElement)params.get());
            return ob.get();
        }

        @Override
        public LLMClient.SimpleCompletionResponse parseTextCompletionResponse(JsonElement response, String prompt) {
            JsonObject jo = response instanceof JsonArray ? (JsonObject)((JsonArray)response).get(0) : (JsonObject)response;
            LLMClient.SimpleCompletionResponse ret = new LLMClient.SimpleCompletionResponse();
            if (jo.has("generation")) {
                ret.text = jo.get("generation").getAsString();
            } else if (jo.has("generated_text")) {
                ret.text = jo.get("generated_text").getAsString();
            } else {
                ret.text = "Unexpected object: " + jo.getAsString();
                logger.error((Object)ret.text);
            }
            return ret;
        }

        @Override
        public EnrichedStreamedCompletionResponseChunk parseTextCompletionChunk(JsonObject jo) {
            throw new IllegalArgumentException("Streaming not supported on LLaMa");
        }
    }

    public static class MistralAILLMMarshall
    implements GenericTextCompletionLLMMarshall {
        private static final CoreCompletionSettingsValidator validator = new CoreCompletionSettingsValidator("Bedrock MistralAI").allowMaxTokens().allowTemperature().allowTopP().allowTopK().allowStopSequences();

        @Override
        public JsonObject prepareTextCompletionQuery(String prompt, CoreCompletionSettings ccs) {
            validator.validate(ccs);
            JF.ObjectBuilder ob = JF.obj();
            ob.with("prompt", prompt);
            if (ccs.maxTokens != null) {
                ob.with("max_tokens", (Number)ccs.maxTokens);
            }
            if (ccs.temperature != null) {
                ob.with("temperature", (Number)ccs.temperature);
            }
            if (ccs.topP != null) {
                ob.with("top_p", (Number)ccs.topP);
            }
            if (ccs.topK != null) {
                ob.with("top_k", (Number)ccs.topK);
            }
            if (ccs.stopSequences != null && !ccs.stopSequences.isEmpty()) {
                ob.with("stop", ccs.stopSequences);
            }
            return ob.get();
        }

        @Override
        public LLMClient.SimpleCompletionResponse parseTextCompletionResponse(JsonElement response, String prompt) {
            JsonObject jo = (JsonObject)response;
            LLMClient.SimpleCompletionResponse ret = new LLMClient.SimpleCompletionResponse();
            JsonObject firstOutput = jo.get("outputs").getAsJsonArray().get(0).getAsJsonObject();
            ret.text = firstOutput.get("text").getAsString();
            String stopReason = firstOutput.get("stop_reason").getAsString();
            ret.finishReason = FinishReasonResponseAdapter.adapt(stopReason);
            ret.promptTokens = (int)(2.5f * (float)new TokenizedText(prompt).size());
            ret.completionTokens = (int)(2.5f * (float)new TokenizedText(ret.text).size());
            ret.tokenCountsAreEstimated = true;
            return ret;
        }

        @Override
        public EnrichedStreamedCompletionResponseChunk parseTextCompletionChunk(JsonObject jo) {
            throw new IllegalArgumentException("Streaming not supported on MistralAI");
        }
    }

    public static class FullyCustomLLMMarshall
    implements GenericTextCompletionLLMMarshall {
        public final SageMakerGenericLLMConnection.SageMakerGenericLLMConnectionParams connectionParams;
        private static final CoreCompletionSettingsValidator validator = new CoreCompletionSettingsValidator("SageMaker custom").allowMaxTokens().allowTemperature().allowTopK().allowTopP().allowFrequencyPenalty().allowPresencePenalty().allowLogitBias().allowStopSequences();
        private static final DKULogger logger = DKULogger.getLogger((String)"dku.llm.marshall.text_completion.fully_custom");

        protected FullyCustomLLMMarshall(SageMakerGenericLLMConnection.SageMakerGenericLLMConnectionParams connectionParams) {
            this.connectionParams = connectionParams;
        }

        @Override
        public JsonObject prepareTextCompletionQuery(String prompt, CoreCompletionSettings ccs) {
            validator.validate(ccs);
            if (StringUtils.isEmpty((String)this.connectionParams.customQuery)) {
                throw new IllegalArgumentException("Empty custom query");
            }
            String query = this.connectionParams.customQuery;
            if (null != ccs.maxTokens) {
                query = query.replace("__MAX_TOKENS__", Integer.toString(ccs.maxTokens));
            }
            if (null != ccs.temperature) {
                query = query.replace("__TEMPERATURE__", Double.toString(ccs.temperature));
            }
            if (null != ccs.topK) {
                query = query.replace("__TOPK__", Integer.toString(ccs.topK));
            }
            if (null != ccs.topP) {
                query = query.replace("__TOPP__", Double.toString(ccs.topP));
            }
            if (null != ccs.frequencyPenalty) {
                query = query.replace("__FREQUENCY_PENALTY__", Double.toString(ccs.frequencyPenalty));
            }
            if (null != ccs.presencePenalty) {
                query = query.replace("__PRESENCE_PENALTY__", Double.toString(ccs.presencePenalty));
            }
            if (ccs.logitBias != null && !ccs.logitBias.isEmpty()) {
                String logitBiasJson = JSON.json(ccs.logitBias);
                query = query.replace("__LOGIT_BIAS__", logitBiasJson);
            }
            if (ccs.stopSequences != null && !ccs.stopSequences.isEmpty()) {
                Object strStopSequences = ccs.stopSequences.stream().map(seq -> "\"" + StringEscapeUtils.escapeJson((String)seq) + "\"").collect(Collectors.joining(","));
                strStopSequences = "[" + (String)strStopSequences + "]";
                query = query.replace("__STOP_SEQUENCES__", (CharSequence)strStopSequences);
            }
            query = query.replace("__PROMPT__", "\"" + StringEscapeUtils.escapeJson((String)prompt) + "\"");
            try {
                return JsonParser.parseString((String)query).getAsJsonObject();
            }
            catch (Exception e) {
                throw new RuntimeException("Error parsing processed customJson:\n" + query);
            }
        }

        @Override
        public LLMClient.SimpleCompletionResponse parseTextCompletionResponse(JsonElement response, String prompt) {
            if (StringUtils.isBlank((String)this.connectionParams.responseJsonPath)) {
                throw new IllegalArgumentException("Empty response path");
            }
            String responseAsString = response.toString();
            LLMClient.SimpleCompletionResponse ret = new LLMClient.SimpleCompletionResponse();
            String responseJsonPath = this.connectionParams.responseJsonPath;
            ret.text = (String)JsonPath.compile((String)responseJsonPath, (Predicate[])new Predicate[0]).read(responseAsString);
            if (StringUtils.isNotBlank((String)this.connectionParams.finishReasonJsonPath)) {
                String finishReasonJsonPath = this.connectionParams.finishReasonJsonPath;
                try {
                    String finishReason = (String)JsonPath.compile((String)finishReasonJsonPath, (Predicate[])new Predicate[0]).read(responseAsString);
                    ret.finishReason = FinishReasonResponseAdapter.adapt(finishReason);
                }
                catch (InvalidPathException ipe) {
                    logger.error((Object)("Error with finishReasonJsonPath " + finishReasonJsonPath), (Throwable)ipe);
                }
            }
            if (StringUtils.isNotBlank((String)this.connectionParams.promptTokensJsonPath)) {
                String promptTokensJsonPath = this.connectionParams.promptTokensJsonPath;
                try {
                    ret.promptTokens = (Integer)JsonPath.compile((String)promptTokensJsonPath, (Predicate[])new Predicate[0]).read(responseAsString);
                }
                catch (InvalidPathException ipe) {
                    logger.error((Object)("Error with promptTokensJsonPath " + promptTokensJsonPath), (Throwable)ipe);
                }
            }
            if (StringUtils.isNotBlank((String)this.connectionParams.completionTokensJsonPath)) {
                String completionTokensJsonPath = this.connectionParams.completionTokensJsonPath;
                try {
                    ret.completionTokens = (Integer)JsonPath.compile((String)completionTokensJsonPath, (Predicate[])new Predicate[0]).read(responseAsString);
                }
                catch (InvalidPathException ipe) {
                    logger.error((Object)("Error with completionTokensJsonPath " + completionTokensJsonPath), (Throwable)ipe);
                }
            }
            return ret;
        }

        @Override
        public EnrichedStreamedCompletionResponseChunk parseTextCompletionChunk(JsonObject jo) {
            throw new IllegalArgumentException("Streaming not supported on fully custom handling");
        }
    }

    public static class EnrichedStreamedCompletionResponseChunk {
        @Nonnull
        public LLMClient.StreamedCompletionResponseChunk chunk = new LLMClient.StreamedCompletionResponseChunk();
        @Nullable
        public LLMClient.FinishReason finishReason;
        public Integer promptTokens;
        public Integer completionTokens;
    }
}

